/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.InputStream;
import org.jboss.logging.Logger;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.saml.SamlAbstractMetadataPublicKeyLoader;

public class SamlMetadataPublicKeyLoader
extends SamlAbstractMetadataPublicKeyLoader {
    private static final Logger logger = Logger.getLogger(SamlMetadataPublicKeyLoader.class);
    private final KeycloakSession session;
    private final String metadataUrl;

    public SamlMetadataPublicKeyLoader(KeycloakSession session, String metadataUrl) {
        this(session, metadataUrl, true);
    }

    public SamlMetadataPublicKeyLoader(KeycloakSession session, String metadataUrl, boolean forIdP) {
        super(forIdP);
        this.session = session;
        this.metadataUrl = metadataUrl;
    }

    @Override
    protected InputStream openInputStream() throws Exception {
        logger.debugf("loading keys from metadata endpoint %s", (Object)this.metadataUrl);
        return ((HttpClientProvider)this.session.getProvider(HttpClientProvider.class)).get(this.metadataUrl);
    }
}

