/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import org.keycloak.common.VerificationException;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.ServerECDSASignatureSignerContext;
import org.keycloak.crypto.ServerECDSASignatureVerifierContext;
import org.keycloak.crypto.SignatureException;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.models.KeycloakSession;

public class ECDSASignatureProvider
implements SignatureProvider {
    private final KeycloakSession session;
    private final String algorithm;

    public ECDSASignatureProvider(KeycloakSession session, String algorithm) {
        this.session = session;
        this.algorithm = algorithm;
    }

    public SignatureSignerContext signer() throws SignatureException {
        return new ServerECDSASignatureSignerContext(this.session, this.algorithm);
    }

    public SignatureSignerContext signer(KeyWrapper key) throws SignatureException {
        SignatureProvider.checkKeyForSignature((KeyWrapper)key, (String)this.algorithm, (String)"EC");
        return new ServerECDSASignatureSignerContext(key);
    }

    public SignatureVerifierContext verifier(String kid) throws VerificationException {
        return new ServerECDSASignatureVerifierContext(this.session, kid, this.algorithm);
    }

    public SignatureVerifierContext verifier(KeyWrapper key) throws VerificationException {
        SignatureProvider.checkKeyForVerification((KeyWrapper)key, (String)this.algorithm, (String)"EC");
        return new ServerECDSASignatureVerifierContext(key);
    }

    public boolean isAsymmetricAlgorithm() {
        return true;
    }
}

