/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.linkedin;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.KeycloakSession;

@Deprecated
public class LinkedInIdentityProvider
extends AbstractOAuth2IdentityProvider<OAuth2IdentityProviderConfig>
implements SocialIdentityProvider<OAuth2IdentityProviderConfig> {
    private static final Logger log = Logger.getLogger(LinkedInIdentityProvider.class);
    public static final String AUTH_URL = "https://www.linkedin.com/oauth/v2/authorization";
    public static final String TOKEN_URL = "https://www.linkedin.com/oauth/v2/accessToken";
    public static final String PROFILE_URL = "https://api.linkedin.com/v2/me";
    public static final String EMAIL_URL = "https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))";
    public static final String EMAIL_SCOPE = "r_emailaddress";
    public static final String DEFAULT_SCOPE = "r_liteprofile r_emailaddress";
    private static final String PROFILE_PROJECTION = "profileProjection";

    public LinkedInIdentityProvider(KeycloakSession session, OAuth2IdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(this.getUserInfoUrl((String)config.getConfig().get(PROFILE_PROJECTION)));
        if (!config.getDefaultScope().contains(EMAIL_SCOPE)) {
            config.setDefaultScope(config.getDefaultScope() + " r_emailaddress");
        }
    }

    @Override
    protected boolean supportsExternalExchange() {
        return true;
    }

    @Override
    protected String getProfileEndpointForValidation(EventBuilder event) {
        return this.getConfig().getUserInfoUrl();
    }

    @Override
    protected BrokeredIdentityContext extractIdentityFromProfile(EventBuilder event, JsonNode profile) {
        BrokeredIdentityContext user = new BrokeredIdentityContext(this.getJsonProperty(profile, "id"));
        user.setFirstName(this.getFirstMultiLocaleString(profile, "firstName"));
        user.setLastName(this.getFirstMultiLocaleString(profile, "lastName"));
        user.setIdpConfig(this.getConfig());
        user.setIdp((IdentityProvider)this);
        AbstractJsonUserAttributeMapper.storeUserProfileForMapper(user, profile, this.getConfig().getAlias());
        return user;
    }

    @Override
    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        log.debug((Object)"doGetFederatedIdentity()");
        try {
            BrokeredIdentityContext identity = this.extractIdentityFromProfile(null, this.doHttpGet(this.getConfig().getUserInfoUrl(), accessToken));
            identity.setEmail(this.fetchEmailAddress(accessToken, identity));
            if (identity.getUsername() == null) {
                identity.setUsername(identity.getEmail());
            }
            return identity;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from linkedIn.", (Throwable)e);
        }
    }

    @Override
    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }

    private String fetchEmailAddress(String accessToken, BrokeredIdentityContext identity) {
        if (identity.getEmail() == null && this.getConfig().getDefaultScope() != null && this.getConfig().getDefaultScope().contains(EMAIL_SCOPE)) {
            try {
                JsonNode emailAddressNode = this.doHttpGet(EMAIL_URL, accessToken).findPath("emailAddress");
                if (emailAddressNode != null) {
                    return emailAddressNode.asText();
                }
            }
            catch (IOException cause) {
                throw new RuntimeException("Failed to retrieve user email", cause);
            }
        }
        return null;
    }

    private JsonNode doHttpGet(String url, String bearerToken) throws IOException {
        JsonNode response = SimpleHttp.doGet((String)url, (KeycloakSession)this.session).header("Authorization", "Bearer " + bearerToken).asJson();
        if (response.hasNonNull("serviceErrorCode")) {
            throw new IdentityBrokerException("Could not obtain response from [" + url + "]. Response from server: " + response);
        }
        return response;
    }

    private String getFirstMultiLocaleString(JsonNode node, String name) {
        Iterator iterator;
        JsonNode localized;
        JsonNode claim = node.get(name);
        if (claim != null && (localized = claim.get("localized")) != null && (iterator = localized.iterator()).hasNext()) {
            return ((JsonNode)iterator.next()).asText();
        }
        return null;
    }

    private String getUserInfoUrl(String projection) {
        return projection == null || projection.isEmpty() ? PROFILE_URL : "https://api.linkedin.com/v2/me?projection=" + projection;
    }
}

