/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.common.util.Encode;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RoleByIdResource;
import org.keycloak.services.resources.admin.RoleResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;

@Extension(name="x-smallrye-profile-admin", value="")
public class RoleContainerResource
extends RoleResource {
    private final RealmModel realm;
    protected AdminPermissionEvaluator auth;
    protected RoleContainerModel roleContainer;
    private AdminEventBuilder adminEvent;
    private UriInfo uriInfo;
    private KeycloakSession session;

    public RoleContainerResource(KeycloakSession session, UriInfo uriInfo, RealmModel realm, AdminPermissionEvaluator auth, RoleContainerModel roleContainer, AdminEventBuilder adminEvent) {
        super(realm);
        this.uriInfo = uriInfo;
        this.realm = realm;
        this.auth = auth;
        this.roleContainer = roleContainer;
        this.adminEvent = adminEvent;
        this.session = session;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Roles")
    @Operation(summary="Get all roles for the realm or client")
    public Stream<RoleRepresentation> getRoles(@QueryParam(value="search") @DefaultValue(value="") String search, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults, @QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation) {
        this.auth.roles().requireList(this.roleContainer);
        Stream roleModels = search != null && search.trim().length() > 0 ? this.roleContainer.searchForRolesStream(search, firstResult, maxResults) : (!Objects.isNull(firstResult) && !Objects.isNull(maxResults) ? this.roleContainer.getRolesStream(firstResult, maxResults) : this.roleContainer.getRolesStream());
        Function<RoleModel, RoleRepresentation> toRoleRepresentation = briefRepresentation ? ModelToRepresentation::toBriefRepresentation : ModelToRepresentation::toRepresentation;
        return roleModels.map(toRoleRepresentation);
    }

    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Roles")
    @Operation(summary="Create a new role for the realm or client")
    public Response createRole(RoleRepresentation rep) {
        this.auth.roles().requireManage(this.roleContainer);
        if (rep.getName() == null) {
            throw new BadRequestException("role has no name");
        }
        try {
            RoleModel role = this.roleContainer.addRole(rep.getName());
            role.setDescription(rep.getDescription());
            Map attributes = rep.getAttributes();
            if (attributes != null) {
                for (Map.Entry attr : attributes.entrySet()) {
                    role.setAttribute((String)attr.getKey(), (List)attr.getValue());
                }
            }
            rep.setId(role.getId());
            if (role.isClientRole()) {
                this.adminEvent.resource(ResourceType.CLIENT_ROLE);
            } else {
                this.adminEvent.resource(ResourceType.REALM_ROLE);
            }
            if (rep.isComposite() && rep.getComposites() != null) {
                Map compositeClientRoles;
                RoleRepresentation.Composites composites = rep.getComposites();
                Set compositeRealmRoles = composites.getRealm();
                if (compositeRealmRoles != null && !compositeRealmRoles.isEmpty()) {
                    LinkedHashSet<RoleModel> realmRoles = new LinkedHashSet<RoleModel>();
                    for (String roleName : compositeRealmRoles) {
                        RoleModel realmRole = this.realm.getRole(roleName);
                        if (realmRole == null) {
                            throw ErrorResponse.error("Realm Role with name " + roleName + " does not exist", Response.Status.NOT_FOUND);
                        }
                        realmRoles.add(realmRole);
                    }
                    realmRoles.stream().peek(this.auth.roles()::requireMapComposite).forEach(arg_0 -> ((RoleModel)role).addCompositeRole(arg_0));
                }
                if ((compositeClientRoles = composites.getClient()) != null && !compositeClientRoles.isEmpty()) {
                    Set entries = compositeClientRoles.entrySet();
                    for (Map.Entry clientIdWithClientRoleNames : entries) {
                        String clientId = (String)clientIdWithClientRoleNames.getKey();
                        List clientRoleNames = (List)clientIdWithClientRoleNames.getValue();
                        ClientModel client = this.realm.getClientByClientId(clientId);
                        if (client == null) continue;
                        LinkedHashSet<RoleModel> clientRoles = new LinkedHashSet<RoleModel>();
                        for (String roleName : clientRoleNames) {
                            RoleModel clientRole = client.getRole(roleName);
                            if (clientRole == null) {
                                throw ErrorResponse.error("Client Role with name " + roleName + " does not exist", Response.Status.NOT_FOUND);
                            }
                            clientRoles.add(clientRole);
                        }
                        clientRoles.stream().peek(this.auth.roles()::requireMapComposite).forEach(arg_0 -> ((RoleModel)role).addCompositeRole(arg_0));
                    }
                }
            }
            this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo, role.getName()).representation(rep).success();
            return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(Encode.encodePathSegmentAsIs((String)role.getName())).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            throw ErrorResponse.exists("Role with name " + rep.getName() + " already exists");
        }
    }

    @Path(value="{role-name}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Roles")
    @Operation(summary="Get a role by name")
    public RoleRepresentation getRole(@Parameter(description="role's name (not id!)") @PathParam(value="role-name") String roleName) {
        this.auth.roles().requireView(this.roleContainer);
        RoleModel roleModel = this.roleContainer.getRole(roleName);
        if (roleModel == null) {
            throw new NotFoundException("Could not find role");
        }
        return this.getRole(roleModel);
    }

    @Path(value="{role-name}")
    @DELETE
    @NoCache
    @Tag(name="Roles")
    @Operation(summary="Delete a role by name")
    public void deleteRole(@Parameter(description="role's name (not id!)") @PathParam(value="role-name") String roleName) {
        this.auth.roles().requireManage(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        if (this.realm.getDefaultRole().getId().equals(role.getId())) {
            throw ErrorResponse.error(roleName + " is default role of the realm and cannot be removed.", Response.Status.BAD_REQUEST);
        }
        this.deleteRole(role);
        if (role.isClientRole()) {
            this.adminEvent.resource(ResourceType.CLIENT_ROLE);
        } else {
            this.adminEvent.resource(ResourceType.REALM_ROLE);
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    @Path(value="{role-name}")
    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Roles")
    @Operation(summary="Update a role by name")
    public Response updateRole(@Parameter(description="role's name (not id!)") @PathParam(value="role-name") String roleName, RoleRepresentation rep) {
        this.auth.roles().requireManage(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        try {
            this.updateRole(rep, role, this.realm, this.session);
            if (role.isClientRole()) {
                this.adminEvent.resource(ResourceType.CLIENT_ROLE);
            } else {
                this.adminEvent.resource(ResourceType.REALM_ROLE);
            }
            this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(rep).success();
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            throw ErrorResponse.exists("Role with name " + rep.getName() + " already exists");
        }
    }

    @Path(value="{role-name}/composites")
    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Roles")
    @Operation(summary="Add a composite to the role")
    @APIResponse(responseCode="204", description="No Content")
    public void addComposites(@Parameter(description="role's name (not id!)") @PathParam(value="role-name") String roleName, List<RoleRepresentation> roles) {
        this.auth.roles().requireManage(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        this.addComposites(this.auth, this.adminEvent, this.uriInfo, roles, role);
    }

    @Path(value="{role-name}/composites")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Roles")
    @Operation(summary="Get composites of the role")
    public Stream<RoleRepresentation> getRoleComposites(@Parameter(description="role's name (not id!)") @PathParam(value="role-name") String roleName) {
        this.auth.roles().requireView(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        return role.getCompositesStream().map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="{role-name}/composites/realm")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Roles")
    @Operation(summary="Get realm-level roles of the role's composite")
    public Stream<RoleRepresentation> getRealmRoleComposites(@Parameter(description="role's name (not id!)") @PathParam(value="role-name") String roleName) {
        this.auth.roles().requireView(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        return this.getRealmRoleComposites(role);
    }

    @Path(value="{role-name}/composites/clients/{client-uuid}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Roles")
    @Operation(summary="Get client-level roles for the client that are in the role's composite")
    public Stream<RoleRepresentation> getClientRoleComposites(@Parameter(description="role's name (not id!)") @PathParam(value="role-name") String roleName, @PathParam(value="client-uuid") String clientUuid) {
        this.auth.roles().requireView(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        ClientModel clientModel = this.realm.getClientById(clientUuid);
        if (clientModel == null) {
            throw new NotFoundException("Could not find client");
        }
        return this.getClientRoleComposites(clientModel, role);
    }

    @Path(value="{role-name}/composites")
    @DELETE
    @Consumes(value={"application/json"})
    @Tag(name="Roles")
    @Operation(summary="Remove roles from the role's composite")
    public void deleteComposites(@Parameter(description="role's name (not id!)") @PathParam(value="role-name") String roleName, @Parameter(description="roles to remove") List<RoleRepresentation> roles) {
        this.auth.roles().requireManage(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        this.deleteComposites(this.adminEvent, this.uriInfo, roles, role);
    }

    @Path(value="{role-name}/management/permissions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Roles")
    @Operation(summary="Return object stating whether role Authorization permissions have been initialized or not and a reference")
    public ManagementPermissionReference getManagementPermissions(@PathParam(value="role-name") String roleName) {
        this.auth.roles().requireView(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        if (!permissions.roles().isPermissionsEnabled(role)) {
            return new ManagementPermissionReference();
        }
        return RoleByIdResource.toMgmtRef(role, permissions);
    }

    @Path(value="{role-name}/management/permissions")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @NoCache
    @Tag(name="Roles")
    @Operation(summary="Return object stating whether role Authorization permissions have been initialized or not and a reference")
    public ManagementPermissionReference setManagementPermissionsEnabled(@PathParam(value="role-name") String roleName, ManagementPermissionReference ref) {
        this.auth.roles().requireManage(this.roleContainer);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        permissions.roles().setPermissionsEnabled(role, ref.isEnabled());
        if (ref.isEnabled()) {
            return RoleByIdResource.toMgmtRef(role, permissions);
        }
        return new ManagementPermissionReference();
    }

    @Path(value="{role-name}/users")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Roles")
    @Operation(summary="Returns a stream of users that have the specified role name.")
    public Stream<UserRepresentation> getUsersInRole(@Parameter(description="the role name.") @PathParam(value="role-name") String roleName, @Parameter(description="first result to return. Ignored if negative or {@code null}.") @QueryParam(value="first") Integer firstResult, @Parameter(description="maximum number of results to return. Ignored if negative or {@code null}.") @QueryParam(value="max") Integer maxResults) {
        this.auth.roles().requireView(this.roleContainer);
        firstResult = firstResult != null ? firstResult : 0;
        maxResults = maxResults != null ? maxResults : 100;
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        return this.session.users().getRoleMembersStream(this.realm, role, firstResult, maxResults).map(user -> ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user));
    }

    @Path(value="{role-name}/groups")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Roles")
    @Operation(summary="Returns a stream of groups that have the specified role name")
    public Stream<GroupRepresentation> getGroupsInRole(@Parameter(description="the role name.") @PathParam(value="role-name") String roleName, @Parameter(description="first result to return. Ignored if negative or {@code null}.") @QueryParam(value="first") Integer firstResult, @Parameter(description="maximum number of results to return. Ignored if negative or {@code null}.") @QueryParam(value="max") Integer maxResults, @Parameter(description="if false, return a full representation of the {@code GroupRepresentation} objects.") @QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation) {
        this.auth.roles().requireView(this.roleContainer);
        firstResult = firstResult != null ? firstResult : 0;
        maxResults = maxResults != null ? maxResults : 100;
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        return this.session.groups().getGroupsByRoleStream(this.realm, role, firstResult, maxResults).map(g -> ModelToRepresentation.toRepresentation((GroupModel)g, (!briefRepresentation ? 1 : 0) != 0));
    }
}

