/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.keys.Attributes;
import org.keycloak.keys.JavaKeystoreKeyProvider;
import org.keycloak.keys.KeyProvider;
import org.keycloak.keys.KeyProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class JavaKeystoreKeyProviderFactory
implements KeyProviderFactory {
    private static final Logger logger = Logger.getLogger(JavaKeystoreKeyProviderFactory.class);
    public static final String ID = "java-keystore";
    public static String KEYSTORE_KEY = "keystore";
    public static ProviderConfigProperty KEYSTORE_PROPERTY = new ProviderConfigProperty(KEYSTORE_KEY, "Keystore", "Path to keys file", "String", null);
    public static String KEYSTORE_PASSWORD_KEY = "keystorePassword";
    public static ProviderConfigProperty KEYSTORE_PASSWORD_PROPERTY = new ProviderConfigProperty(KEYSTORE_PASSWORD_KEY, "Keystore Password", "Password for the keys", "String", null, true);
    public static String KEYSTORE_TYPE_KEY = "keystoreType";
    private ProviderConfigProperty keystoreTypeProperty;
    public static String KEY_ALIAS_KEY = "keyAlias";
    public static ProviderConfigProperty KEY_ALIAS_PROPERTY = new ProviderConfigProperty(KEY_ALIAS_KEY, "Key Alias", "Alias for the private key", "String", null);
    public static String KEY_PASSWORD_KEY = "keyPassword";
    public static ProviderConfigProperty KEY_PASSWORD_PROPERTY = new ProviderConfigProperty(KEY_PASSWORD_KEY, "Key Password", "Password for the private key", "String", null, true);
    private static final String HELP_TEXT = "Loads keys from a Java keys file";
    private List<ProviderConfigProperty> configProperties;

    public void init(Config.Scope config) {
        String[] supportedKeystoreTypes = (String[])CryptoIntegration.getProvider().getSupportedKeyStoreTypes().map(Enum::toString).toArray(String[]::new);
        this.keystoreTypeProperty = new ProviderConfigProperty(KEYSTORE_TYPE_KEY, "Keystore Type", "Keystore type. This parameter is not mandatory. If omitted, the type will be detected from keystore file or default keystore type will be used", "List", (Object)(supportedKeystoreTypes.length > 0 ? supportedKeystoreTypes[0] : null), supportedKeystoreTypes);
        this.configProperties = ProviderConfigurationBuilder.create().property(Attributes.PRIORITY_PROPERTY).property(Attributes.ENABLED_PROPERTY).property(Attributes.ACTIVE_PROPERTY).property(JavaKeystoreKeyProviderFactory.mergedAlgorithmProperties()).property(KEYSTORE_PROPERTY).property(KEYSTORE_PASSWORD_PROPERTY).property(this.keystoreTypeProperty).property(KEY_ALIAS_PROPERTY).property(KEY_PASSWORD_PROPERTY).property(Attributes.KEY_USE_PROPERTY).build();
    }

    public KeyProvider create(KeycloakSession session, ComponentModel model) {
        return new JavaKeystoreKeyProvider(session.getContext().getRealm(), model);
    }

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        ConfigurationValidationHelper.check((ComponentModel)model).checkLong(Attributes.PRIORITY_PROPERTY, false).checkBoolean(Attributes.ENABLED_PROPERTY, false).checkBoolean(Attributes.ACTIVE_PROPERTY, false).checkSingle(KEYSTORE_PROPERTY, true).checkSingle(KEYSTORE_PASSWORD_PROPERTY, true).checkSingle(this.keystoreTypeProperty, false).checkSingle(KEY_ALIAS_PROPERTY, true).checkSingle(KEY_PASSWORD_PROPERTY, true);
        try {
            new JavaKeystoreKeyProvider(realm, model).loadKey(realm, model);
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to load keys.", t);
            throw new ComponentValidationException("Failed to load keys. " + t.getMessage(), t);
        }
    }

    private static ProviderConfigProperty mergedAlgorithmProperties() {
        List<String> ecAlgorithms = List.of("ES256", "ES384", "ES512");
        List algorithms = Stream.of(Attributes.RS_ALGORITHM_PROPERTY.getOptions(), ecAlgorithms, Attributes.RS_ENC_ALGORITHM_PROPERTY.getOptions()).flatMap(Collection::stream).toList();
        return new ProviderConfigProperty(Attributes.RS_ALGORITHM_PROPERTY.getName(), Attributes.RS_ALGORITHM_PROPERTY.getLabel(), Attributes.RS_ALGORITHM_PROPERTY.getHelpText(), Attributes.RS_ALGORITHM_PROPERTY.getType(), Attributes.RS_ALGORITHM_PROPERTY.getDefaultValue(), (String[])algorithms.toArray(String[]::new));
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return this.configProperties;
    }

    public String getId() {
        return ID;
    }
}

