/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.keycloak.broker.oidc.mappers.AbstractClaimToGroupMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.provider.ProviderConfigProperty;

public class HardcodedGroupMapper
extends AbstractClaimToGroupMapper {
    public static final String PROVIDER_ID = "oidc-hardcoded-group-idp-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        ArrayList<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("group");
        property.setLabel("Group");
        property.setHelpText("Group to assign the user.");
        property.setType("Group");
        configProperties.add(property);
        return configProperties;
    }

    public String getDisplayCategory() {
        return "Group Importer";
    }

    public String getDisplayType() {
        return "Hardcoded Group";
    }

    public boolean supportsSyncMode(IdentityProviderSyncMode syncMode) {
        return EnumSet.allOf(IdentityProviderSyncMode.class).contains(syncMode);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return new String[]{"*"};
    }

    public String getHelpText() {
        return "Assign the user to the specified group.";
    }

    @Override
    protected boolean applies(IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        return true;
    }
}

