/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clienttype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.client.clienttype.ClientType;
import org.keycloak.client.clienttype.ClientTypeException;
import org.keycloak.client.clienttype.ClientTypeManager;
import org.keycloak.client.clienttype.ClientTypeProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ClientTypeRepresentation;
import org.keycloak.representations.idm.ClientTypesRepresentation;
import org.keycloak.services.clienttype.client.TypeAwareClientModelDelegate;
import org.keycloak.util.JsonSerialization;

public class DefaultClientTypeManager
implements ClientTypeManager {
    private static final Logger logger = Logger.getLogger(DefaultClientTypeManager.class);
    private static final String CLIENT_TYPE_REALM_ATTRIBUTE = "client-types";
    private final KeycloakSession session;
    private final List<ClientTypeRepresentation> globalClientTypes;

    public DefaultClientTypeManager(KeycloakSession session, List<ClientTypeRepresentation> globalClientTypes) {
        this.session = session;
        this.globalClientTypes = globalClientTypes;
    }

    public ClientTypesRepresentation getClientTypes(RealmModel realm) throws ClientTypeException {
        ClientTypesRepresentation result;
        String asStr = realm.getAttribute(CLIENT_TYPE_REALM_ATTRIBUTE);
        if (asStr == null) {
            result = new ClientTypesRepresentation(new ArrayList(), null);
            result.setGlobalClientTypes(this.globalClientTypes);
        } else {
            try {
                result = (ClientTypesRepresentation)JsonSerialization.readValue((String)asStr, ClientTypesRepresentation.class);
                result.setGlobalClientTypes(this.globalClientTypes);
            }
            catch (IOException ioe) {
                logger.errorf("Failed to load client type for realm '%s'.", (Object)realm.getName());
                throw ClientTypeException.Message.CLIENT_TYPE_FAILED_TO_LOAD.exception(new Object[]{ioe});
            }
        }
        return result;
    }

    public void updateClientTypes(RealmModel realm, ClientTypesRepresentation clientTypes) throws ClientTypeException {
        List<ClientTypeRepresentation> validatedClientTypes = DefaultClientTypeManager.validateAndCastConfiguration(this.session, clientTypes.getRealmClientTypes(), this.globalClientTypes);
        ClientTypesRepresentation noGlobalsCopy = new ClientTypesRepresentation(validatedClientTypes, null);
        try {
            String asStr = JsonSerialization.writeValueAsString((Object)noGlobalsCopy);
            realm.setAttribute(CLIENT_TYPE_REALM_ATTRIBUTE, asStr);
        }
        catch (IOException ioe) {
            logger.errorf("Failed to load global client type.", new Object[0]);
            throw ClientTypeException.Message.CLIENT_TYPE_FAILED_TO_LOAD.exception(new Object[]{ioe});
        }
    }

    public ClientType getClientType(RealmModel realm, String typeName) throws ClientTypeException {
        ClientTypesRepresentation clientTypes = this.getClientTypes(realm);
        ClientTypeRepresentation clientType = this.getClientTypeByName(clientTypes, typeName);
        if (clientType == null) {
            logger.errorf("Referenced client type '%s' not found", (Object)typeName);
            throw ClientTypeException.Message.CLIENT_TYPE_NOT_FOUND.exception(new Object[0]);
        }
        ClientTypeProvider provider = (ClientTypeProvider)this.session.getProvider(ClientTypeProvider.class, clientType.getProvider());
        return provider.getClientType(clientType);
    }

    public ClientModel augmentClient(ClientModel client) throws ClientTypeException {
        if (client.getType() == null) {
            return client;
        }
        try {
            ClientType clientType = this.getClientType(client.getRealm(), client.getType());
            return new TypeAwareClientModelDelegate(clientType, () -> client);
        }
        catch (ClientTypeException cte) {
            logger.errorf("Could not augment client, %s, due to client type exception: %s", (Object)client, (Object)cte);
            throw cte;
        }
    }

    static List<ClientTypeRepresentation> validateAndCastConfiguration(KeycloakSession session, List<ClientTypeRepresentation> clientTypes, List<ClientTypeRepresentation> globalTypes) {
        Set usedNames = globalTypes.stream().map(ClientTypeRepresentation::getName).collect(Collectors.toSet());
        return clientTypes.stream().map(clientType -> DefaultClientTypeManager.validateAndCastConfiguration(session, clientType, usedNames)).collect(Collectors.toList());
    }

    private static ClientTypeRepresentation validateAndCastConfiguration(KeycloakSession session, ClientTypeRepresentation clientType, Set<String> currentNames) {
        ClientTypeProvider clientTypeProvider = (ClientTypeProvider)session.getProvider(ClientTypeProvider.class, clientType.getProvider());
        if (clientTypeProvider == null) {
            logger.errorf("Did not find client type provider '%s' for the client type '%s'", (Object)clientType.getProvider(), (Object)clientType.getName());
            throw ClientTypeException.Message.INVALID_CLIENT_TYPE_PROVIDER.exception(new Object[0]);
        }
        if (currentNames.contains(clientType.getName())) {
            logger.errorf("Duplicated client type name '%s'", (Object)clientType.getName());
            throw ClientTypeException.Message.DUPLICATE_CLIENT_TYPE.exception(new Object[0]);
        }
        clientType = clientTypeProvider.checkClientTypeConfig(clientType);
        currentNames.add(clientType.getName());
        return clientType;
    }

    private ClientTypeRepresentation getClientTypeByName(ClientTypesRepresentation clientTypes, String clientTypeName) {
        if (clientTypes.getRealmClientTypes() != null) {
            for (ClientTypeRepresentation clientType : clientTypes.getRealmClientTypes()) {
                if (!clientTypeName.equals(clientType.getName())) continue;
                return clientType;
            }
        }
        if (clientTypes.getGlobalClientTypes() != null) {
            for (ClientTypeRepresentation clientType : clientTypes.getGlobalClientTypes()) {
                if (!clientTypeName.equals(clientType.getName())) continue;
                return clientType;
            }
        }
        return null;
    }
}

