/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.forms;

import jakarta.ws.rs.core.Response;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.FormAuthenticator;
import org.keycloak.authentication.FormAuthenticatorFactory;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.actiontoken.inviteorg.InviteOrgActionToken;
import org.keycloak.common.Profile;
import org.keycloak.common.VerificationException;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.OrganizationModel;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.provider.ProviderConfigProperty;

public class RegistrationPage
implements FormAuthenticator,
FormAuthenticatorFactory {
    public static final String FIELD_PASSWORD_CONFIRM = "password-confirm";
    public static final String FIELD_PASSWORD = "password";
    public static final String FIELD_EMAIL = "email";
    public static final String FIELD_USERNAME = "username";
    public static final String FIELD_LAST_NAME = "lastName";
    public static final String FIELD_FIRST_NAME = "firstName";
    public static final String FIELD_RECAPTCHA_RESPONSE = "g-recaptcha-response";
    public static final String PROVIDER_ID = "registration-page-form";
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};

    public Response render(FormContext context, LoginFormsProvider form) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION)) {
            try {
                InviteOrgActionToken token = Organizations.parseInvitationToken(context.getHttpRequest());
                if (token != null) {
                    KeycloakSession session = context.getSession();
                    OrganizationProvider provider = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
                    OrganizationModel organization = provider.getById(token.getOrgId());
                    if (organization == null || !organization.isEnabled()) {
                        return form.setError("expiredActionMessage", new Object[0]).createErrorPage(Response.Status.BAD_REQUEST);
                    }
                    form.setAttribute("messageHeader", (Object)"organization.member.register.title");
                    form.setAttribute("kc.org.name", (Object)organization.getName());
                }
            }
            catch (VerificationException e) {
                return form.setError("expiredActionMessage", new Object[0]).createErrorPage(Response.Status.BAD_REQUEST);
            }
        }
        return form.createRegistration();
    }

    public void close() {
    }

    public String getDisplayType() {
        return "Registration Page";
    }

    public String getHelpText() {
        return "This is the controller for the registration page";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public FormAuthenticator create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

