/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.broker;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.authenticators.broker.AbstractIdpAuthenticator;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.authentication.authenticators.browser.UsernamePasswordForm;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;

public class IdpUsernamePasswordForm
extends UsernamePasswordForm {
    private static final Logger log = Logger.getLogger(IdpUsernamePasswordForm.class);

    @Override
    protected Response challenge(AuthenticationFlowContext context, MultivaluedMap<String, String> formData) {
        return this.setupForm(context, formData, this.getExistingUser(context)).setStatus(Response.Status.OK).createLoginUsernamePassword();
    }

    @Override
    protected Response challenge(AuthenticationFlowContext context, String error, String field) {
        LoginFormsProvider form = this.setupForm(context, (MultivaluedMap<String, String>)new MultivaluedHashMap(), this.getExistingUser(context)).setExecution(context.getExecution().getId());
        if (error != null) {
            if (field != null) {
                form.addError(new FormMessage(field, error));
            } else {
                form.setError(error, new Object[0]);
            }
        }
        return this.createLoginForm(form);
    }

    @Override
    protected boolean validateForm(AuthenticationFlowContext context, MultivaluedMap<String, String> formData) {
        Optional<UserModel> existingUser = this.getExistingUser(context);
        existingUser.ifPresent(arg_0 -> ((AuthenticationFlowContext)context).setUser(arg_0));
        boolean result = this.validateUserAndPassword(context, formData);
        this.setupForm(context, formData, existingUser);
        return result;
    }

    protected LoginFormsProvider setupForm(AuthenticationFlowContext context, MultivaluedMap<String, String> formData, Optional<UserModel> existingUser) {
        SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromAuthenticationSession(context.getAuthenticationSession(), "BROKERED_CONTEXT");
        if (serializedCtx == null) {
            throw new AuthenticationFlowException("Not found serialized context in clientSession", AuthenticationFlowError.IDENTITY_PROVIDER_ERROR);
        }
        existingUser.ifPresent(u -> formData.putSingle((Object)"username", (Object)u.getUsername()));
        LoginFormsProvider form = context.form().setFormData(formData).setAttribute("registrationDisabled", (Object)true).setInfo("federatedIdentityConfirmReauthenticateMessage", new Object[]{serializedCtx.getIdentityProviderId()});
        SerializedBrokeredIdentityContext serializedCtx0 = SerializedBrokeredIdentityContext.readFromAuthenticationSession(context.getAuthenticationSession(), "NESTED_FIRST_BROKER_CONTEXT");
        if (serializedCtx0 != null) {
            BrokeredIdentityContext ctx0 = serializedCtx0.deserialize(context.getSession(), context.getAuthenticationSession());
            form.setError("nestedFirstBrokerFlowMessage", new Object[]{ctx0.getIdpConfig().getAlias(), ctx0.getUsername()});
            context.getAuthenticationSession().setAuthNote("NESTED_FIRST_BROKER_CONTEXT", null);
        }
        return form;
    }

    private Optional<UserModel> getExistingUser(AuthenticationFlowContext context) {
        try {
            return Optional.of(AbstractIdpAuthenticator.getExistingUser(context.getSession(), context.getRealm(), context.getAuthenticationSession()));
        }
        catch (AuthenticationFlowException ex) {
            log.debug((Object)"No existing user in authSession", (Throwable)ex);
            return Optional.empty();
        }
    }
}

