/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.jboss.logging.Logger;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.VCIssuanceContext;
import org.keycloak.protocol.oid4vc.issuance.VCIssuerException;
import org.keycloak.protocol.oid4vc.issuance.signing.JwtProofBasedSigningService;
import org.keycloak.protocol.oid4vc.issuance.signing.JwtSigningService;
import org.keycloak.protocol.oid4vc.issuance.signing.SigningServiceException;
import org.keycloak.protocol.oid4vc.issuance.signing.VerifiableCredentialsSigningService;
import org.keycloak.protocol.oid4vc.model.CredentialConfigId;
import org.keycloak.protocol.oid4vc.model.CredentialSubject;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.protocol.oid4vc.model.VerifiableCredentialType;
import org.keycloak.sdjwt.DisclosureSpec;
import org.keycloak.sdjwt.SdJwt;
import org.keycloak.sdjwt.SdJwtUtils;

public class SdJwtSigningService
extends JwtProofBasedSigningService<String> {
    private static final Logger LOGGER = Logger.getLogger(SdJwtSigningService.class);
    private static final String ISSUER_CLAIM = "iss";
    private static final String VERIFIABLE_CREDENTIAL_TYPE_CLAIM = "vct";
    private static final String CREDENTIAL_ID_CLAIM = "jti";
    private static final String CNF_CLAIM = "cnf";
    private static final String JWK_CLAIM = "jwk";
    private final ObjectMapper objectMapper;
    private final SignatureSignerContext signatureSignerContext;
    private final String tokenType;
    private final String hashAlgorithm;
    private final int decoys;
    private final List<String> visibleClaims;
    protected final String issuerDid;
    private final CredentialConfigId vcConfigId;
    private final VerifiableCredentialType vct;

    public SdJwtSigningService(KeycloakSession keycloakSession, ObjectMapper objectMapper, String keyId, String algorithmType, String tokenType, String hashAlgorithm, String issuerDid, int decoys, List<String> visibleClaims, Optional<String> kid, VerifiableCredentialType credentialType, CredentialConfigId vcConfigId) {
        super(keycloakSession, keyId, "vc+sd-jwt", algorithmType);
        this.objectMapper = objectMapper;
        this.issuerDid = issuerDid;
        this.tokenType = tokenType;
        this.hashAlgorithm = hashAlgorithm;
        this.decoys = decoys;
        this.visibleClaims = visibleClaims;
        this.vcConfigId = vcConfigId;
        this.vct = credentialType;
        if (this.vcConfigId != null && this.vct == null) {
            throw new SigningServiceException(String.format("Missing vct for credential config id %s.", vcConfigId));
        }
        KeyWrapper signingKey = this.getKey(keyId, algorithmType);
        if (signingKey == null) {
            throw new SigningServiceException(String.format("No key for id %s and algorithm %s available.", keyId, algorithmType));
        }
        if (kid.isPresent()) {
            signingKey = signingKey.cloneKey();
            signingKey.setKid(keyId);
        }
        SignatureProvider signatureProvider = (SignatureProvider)keycloakSession.getProvider(SignatureProvider.class, algorithmType);
        this.signatureSignerContext = signatureProvider.signer(signingKey);
        LOGGER.debugf("Successfully initiated the SD-JWT Signing Service with algorithm %s.", (Object)algorithmType);
    }

    @Override
    public String signCredential(VCIssuanceContext vcIssuanceContext) throws VCIssuerException {
        JWK jwk = null;
        try {
            jwk = this.validateProof(vcIssuanceContext);
        }
        catch (IOException | VerificationException | JWSInputException e) {
            throw new VCIssuerException("Can not verify proof", e);
        }
        VerifiableCredential verifiableCredential = vcIssuanceContext.getVerifiableCredential();
        DisclosureSpec.Builder disclosureSpecBuilder = DisclosureSpec.builder();
        CredentialSubject credentialSubject = verifiableCredential.getCredentialSubject();
        JsonNode claimSet = this.objectMapper.valueToTree((Object)credentialSubject);
        credentialSubject.getClaims().entrySet().stream().filter(entry -> !this.visibleClaims.contains(entry.getKey())).forEach(entry -> {
            if (entry instanceof List) {
                List listValue = (List)((Object)entry);
                IntStream.range(0, listValue.size()).forEach(i -> disclosureSpecBuilder.withUndisclosedArrayElt((String)entry.getKey(), Integer.valueOf(i), SdJwtUtils.randomSalt()));
            } else {
                disclosureSpecBuilder.withUndisclosedClaim((String)entry.getKey(), SdJwtUtils.randomSalt());
            }
        });
        if (this.decoys != 0) {
            IntStream.range(0, this.decoys).forEach(i -> disclosureSpecBuilder.withDecoyClaim(SdJwtUtils.randomSalt()));
        }
        ObjectNode rootNode = claimSet.withObject("");
        rootNode.put(ISSUER_CLAIM, this.issuerDid);
        rootNode.put(VERIFIABLE_CREDENTIAL_TYPE_CLAIM, this.vct.getValue());
        rootNode.put(CREDENTIAL_ID_CLAIM, JwtSigningService.createCredentialId(verifiableCredential));
        if (jwk != null) {
            rootNode.putPOJO(CNF_CLAIM, Map.of(JWK_CLAIM, jwk));
        }
        SdJwt sdJwt = SdJwt.builder().withDisclosureSpec(disclosureSpecBuilder.build()).withClaimSet(claimSet).withSigner(this.signatureSignerContext).withHashAlgorithm(this.hashAlgorithm).withJwsType(this.tokenType).build();
        return sdJwt.toSdJwtString();
    }

    @Override
    public String locator() {
        return VerifiableCredentialsSigningService.locator(this.format, this.vct, this.vcConfigId);
    }
}

