/*
 * Copyright 2024 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Represents an error response, containing the error type as defined by OID4VCI
 *
 * @author <a href="https://github.com/wistefan">Stefan Wiedemann</a>
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ErrorResponse {

    private ErrorType error;

    @JsonProperty("error_description")
    private String errorDescription;

    @JsonProperty("c_nonce")
    private String cNonce;

    @JsonProperty("c_nonce_expires_in")
    private long cNonceExpiresIn;

    public ErrorType getError() {
        return error;
    }

    public ErrorResponse setError(ErrorType error) {
        this.error = error;
        return this;
    }

    public String getErrorDescription() {
        return errorDescription;
    }

    public ErrorResponse setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
        return this;
    }

    public String getcNonce() {
        return cNonce;
    }

    public ErrorResponse setcNonce(String cNonce) {
        this.cNonce = cNonce;
        return this;
    }

    public long getcNonceExpiresIn() {
        return cNonceExpiresIn;
    }

    public ErrorResponse setcNonceExpiresIn(long cNonceExpiresIn) {
        this.cNonceExpiresIn = cNonceExpiresIn;
        return this;
    }
}