/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.authorization.AdminPermissionsSchema;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.ResourceWrapper;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.services.resources.admin.permissions.MgmtPermissions;
import org.keycloak.services.resources.admin.permissions.RolePermissions;

public class RolePermissionsV2
extends RolePermissions {
    RolePermissionsV2(KeycloakSession session, RealmModel realm, AuthorizationProvider authz, MgmtPermissions root) {
        super(session, realm, authz, root);
    }

    @Override
    public boolean canMapClientScope(RoleModel role) {
        if (this.root.clients().canManageClientsDefault()) {
            return true;
        }
        RoleContainerModel roleContainerModel = role.getContainer();
        if (roleContainerModel instanceof ClientModel) {
            ClientModel clientModel = (ClientModel)roleContainerModel;
            if (this.root.clients().canMapClientScopeRoles(clientModel)) {
                return true;
            }
        }
        return this.hasPermission(role, "map-role-client-scope");
    }

    @Override
    public boolean canMapComposite(RoleModel role) {
        if (this.canManageDefault(role)) {
            return this.checkAdminRoles(role);
        }
        RoleContainerModel roleContainerModel = role.getContainer();
        if (roleContainerModel instanceof ClientModel) {
            ClientModel clientModel = (ClientModel)roleContainerModel;
            if (this.root.clients().canMapCompositeRoles(clientModel)) {
                return true;
            }
        }
        return this.hasPermission(role, "map-role-composite") && this.checkAdminRoles(role);
    }

    @Override
    public boolean canMapRole(RoleModel role) {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_USERS)) {
            return this.checkAdminRoles(role);
        }
        RoleContainerModel roleContainerModel = role.getContainer();
        if (roleContainerModel instanceof ClientModel) {
            ClientModel clientModel = (ClientModel)roleContainerModel;
            if (this.root.clients().canMapRoles(clientModel)) {
                return true;
            }
        }
        return this.hasPermission(role, "map-role") && this.checkAdminRoles(role);
    }

    @Override
    public Set<String> getRoleIdsByScope(String scope) {
        if (!this.root.isAdminSameRealm()) {
            return Collections.emptySet();
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return Collections.emptySet();
        }
        HashSet<String> granted = new HashSet<String>();
        this.policyStore.findByResourceType(server, "Roles").stream().flatMap(policy -> policy.getResources().stream()).forEach(gr -> {
            if (this.hasGrantedPermission(server, (Resource)gr, scope)) {
                granted.add(gr.getName());
            }
        });
        return granted;
    }

    private boolean hasPermission(RoleModel role, String ... scopes) {
        return this.hasPermission(role, (EvaluationContext)null, scopes);
    }

    private boolean hasPermission(RoleModel role, EvaluationContext context, String ... scopes) {
        Resource resource;
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        String resourceType = "Roles";
        Resource resourceTypeResource = AdminPermissionsSchema.SCHEMA.getResourceTypeResource(this.session, server, resourceType);
        Resource resource2 = resource = role == null ? resourceTypeResource : this.resourceStore.findByName(server, role.getId());
        if (role != null && resource == null) {
            resource = new ResourceWrapper(role.getId(), role.getId(), new HashSet(resourceTypeResource.getScopes()), server);
        }
        Collection<Permission> permissions = context == null ? this.root.evaluatePermission(new ResourcePermission(resourceType, resource, (Collection)resource.getScopes(), server), server) : this.root.evaluatePermission(new ResourcePermission(resourceType, resource, (Collection)resource.getScopes(), server), server, context);
        List<String> expectedScopes = List.of(scopes);
        for (Permission permission : permissions) {
            if (!permission.getResourceId().equals(resource.getId())) continue;
            for (String scope : permission.getScopes()) {
                if (!expectedScopes.contains(scope)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasGrantedPermission(ResourceServer server, Resource resource, String scope) {
        Collection<Permission> permissions = this.root.evaluatePermission(new ResourcePermission(resource, (Collection)resource.getScopes(), server), server);
        for (Permission permission : permissions) {
            if (!permission.getResourceId().equals(resource.getId())) continue;
            for (String s : permission.getScopes()) {
                if (!scope.equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPermissionsEnabled(RoleModel role) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public void setPermissionsEnabled(RoleModel role, boolean enable) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Map<String, String> getPermissions(RoleModel role) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy mapRolePermission(RoleModel role) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy mapCompositePermission(RoleModel role) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy mapClientScopePermission(RoleModel role) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Resource resource(RoleModel role) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public ResourceServer resourceServer(RoleModel role) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy manageUsersPolicy(ResourceServer server) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy viewUsersPolicy(ResourceServer server) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy rolePolicy(ResourceServer server, RoleModel role) {
        throw new UnsupportedOperationException("Not supported in V2");
    }
}

