/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import jakarta.ws.rs.ForbiddenException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.keycloak.authorization.AdminPermissionsSchema;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.common.DefaultEvaluationContext;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.identity.UserModelIdentity;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.ResourceWrapper;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ImpersonationConstants;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.services.resources.admin.permissions.MgmtPermissionsV2;
import org.keycloak.services.resources.admin.permissions.UserPermissions;

class UserPermissionsV2
extends UserPermissions {
    UserPermissionsV2(KeycloakSession session, AuthorizationProvider authz, MgmtPermissionsV2 root) {
        super(session, authz, root);
    }

    @Override
    public boolean canView(UserModel user) {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_USERS, AdminRoles.VIEW_USERS)) {
            return true;
        }
        return this.hasPermission(user, null, "view");
    }

    @Override
    public boolean canView() {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_USERS, AdminRoles.VIEW_USERS)) {
            return true;
        }
        return this.hasPermission((UserModel)null, null, "view");
    }

    @Override
    public boolean canManage(UserModel user) {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_USERS)) {
            return true;
        }
        return this.hasPermission(user, null, "manage");
    }

    @Override
    public boolean canManage() {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_USERS)) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        return this.hasPermission((UserModel)null, null, "manage");
    }

    @Override
    public void requireManage() {
        if (!this.canManage()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canImpersonate(UserModel user, ClientModel requester) {
        if (this.root.hasOneAdminRole(ImpersonationConstants.IMPERSONATION_ROLE)) {
            return true;
        }
        DefaultEvaluationContext context = requester == null ? null : new DefaultEvaluationContext((Identity)new UserModelIdentity(this.root.realm, user), Map.of("kc.client.id", List.of(requester.getClientId())), this.session);
        return this.hasPermission(user, context, "impersonate");
    }

    @Override
    public boolean canMapRoles(UserModel user) {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_USERS)) {
            return true;
        }
        return this.hasPermission(user, null, "map-roles");
    }

    @Override
    public boolean canManageGroupMembership(UserModel user) {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_USERS)) {
            return true;
        }
        return this.hasPermission(user, null, "manage-group-membership");
    }

    private boolean hasPermission(UserModel user, EvaluationContext context, String scope) {
        Resource resource;
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        String resourceType = "Users";
        Resource resourceTypeResource = AdminPermissionsSchema.SCHEMA.getResourceTypeResource(this.session, server, resourceType);
        Resource resource2 = resource = user == null ? resourceTypeResource : this.resourceStore.findByName(server, user.getId());
        if (user != null && resource == null) {
            resource = new ResourceWrapper(user.getId(), user.getId(), new HashSet(resourceTypeResource.getScopes()), server);
        }
        Collection<Permission> permissions = context == null ? this.root.evaluatePermission(new ResourcePermission(resourceType, resource, (Collection)resource.getScopes(), server), server) : this.root.evaluatePermission(new ResourcePermission(resourceType, resource, (Collection)resource.getScopes(), server), server, context);
        for (Permission permission : permissions) {
            if (!permission.getResourceId().equals(resource.getId()) || !permission.getScopes().contains(scope)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canClientImpersonate(ClientModel client, UserModel user) {
        return this.canImpersonate(user, client);
    }

    @Override
    public boolean isImpersonatable(UserModel user, ClientModel requester) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public boolean isImpersonatable(UserModel user) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public boolean isPermissionsEnabled() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public void setPermissionsEnabled(boolean enable) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Map<String, String> getPermissions() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Resource resource() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy managePermission() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy viewPermission() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy manageGroupMembershipPermission() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy mapRolesPermission() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy adminImpersonatingPermission() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy userImpersonatedPermission() {
        throw new UnsupportedOperationException("Not supported in V2");
    }
}

