/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin.representation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.admin.PolicyEvaluationService;
import org.keycloak.authorization.admin.representation.FGAPPolicyEvaluationResponseBuilder;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.authorization.DecisionEffect;
import org.keycloak.representations.idm.authorization.PolicyEvaluationRequest;
import org.keycloak.representations.idm.authorization.PolicyEvaluationResponse;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;

public class PolicyEvaluationResponseBuilder {
    public static PolicyEvaluationResponse build(PolicyEvaluationService.EvaluationDecisionCollector decision, ResourceServer resourceServer, AuthorizationProvider authorization, KeycloakIdentity identity, PolicyEvaluationRequest request) {
        if (AdminPermissionsSchema.SCHEMA.isAdminPermissionClient(authorization.getRealm(), resourceServer.getId())) {
            return FGAPPolicyEvaluationResponseBuilder.build(decision, resourceServer, authorization, request);
        }
        PolicyEvaluationResponse response = new PolicyEvaluationResponse();
        ArrayList<PolicyEvaluationResponse.EvaluationResultRepresentation> resultsRep = new ArrayList<PolicyEvaluationResponse.EvaluationResultRepresentation>();
        AccessToken accessToken = identity.getAccessToken();
        AccessToken.Authorization authorizationData = new AccessToken.Authorization();
        authorizationData.setPermissions(decision.results());
        accessToken.setAuthorization(authorizationData);
        ClientModel clientModel = authorization.getRealm().getClientById(resourceServer.getClientId());
        if (!accessToken.hasAudience(clientModel.getClientId())) {
            accessToken.audience(new String[]{clientModel.getClientId()});
        }
        response.setRpt(accessToken);
        Collection<Result> results = decision.getResults();
        if (results.stream().anyMatch(evaluationResult -> evaluationResult.getEffect().equals((Object)Decision.Effect.DENY))) {
            response.setStatus(DecisionEffect.DENY);
        } else {
            response.setStatus(DecisionEffect.PERMIT);
        }
        for (Result result : results) {
            PolicyEvaluationResponse.EvaluationResultRepresentation rep = new PolicyEvaluationResponse.EvaluationResultRepresentation();
            if (result.getEffect() == Decision.Effect.DENY) {
                rep.setStatus(DecisionEffect.DENY);
            } else {
                rep.setStatus(DecisionEffect.PERMIT);
            }
            resultsRep.add(rep);
            if (result.getPermission().getResource() != null) {
                resource = new ResourceRepresentation();
                resource.setId(result.getPermission().getResource().getId());
                resource.setName(result.getPermission().getResource().getName());
                rep.setResource(resource);
            } else {
                resource = new ResourceRepresentation();
                resource.setName("Any Resource with Scopes " + String.valueOf(result.getPermission().getScopes().stream().map(Scope::getName).collect(Collectors.toList())));
                rep.setResource(resource);
            }
            rep.setScopes(result.getPermission().getScopes().stream().map(scope -> {
                ScopeRepresentation representation = new ScopeRepresentation();
                representation.setId(scope.getId());
                representation.setName(scope.getName());
                return representation;
            }).collect(Collectors.toList()));
            HashSet<PolicyEvaluationResponse.PolicyResultRepresentation> policies = new HashSet<PolicyEvaluationResponse.PolicyResultRepresentation>();
            for (Result.PolicyResult policy : result.getResults()) {
                PolicyEvaluationResponse.PolicyResultRepresentation policyRep = PolicyEvaluationResponseBuilder.toRepresentation(policy, authorization);
                if ("resource".equals(policy.getPolicy().getType())) {
                    policyRep.getPolicy().setScopes(result.getPermission().getResource().getScopes().stream().map(Scope::getName).collect(Collectors.toSet()));
                }
                policies.add(policyRep);
            }
            rep.setPolicies(policies);
        }
        resultsRep.sort(Comparator.comparing(o -> o.getResource().getName()));
        HashMap groupedResults = new HashMap();
        resultsRep.forEach(evaluationResultRepresentation -> {
            PolicyEvaluationResponse.EvaluationResultRepresentation result = (PolicyEvaluationResponse.EvaluationResultRepresentation)groupedResults.get(evaluationResultRepresentation.getResource().getId());
            ResourceRepresentation resource = evaluationResultRepresentation.getResource();
            if (result == null) {
                groupedResults.put(resource.getId(), evaluationResultRepresentation);
                result = evaluationResultRepresentation;
            }
            if (result.getStatus().equals((Object)DecisionEffect.PERMIT) || evaluationResultRepresentation.getStatus().equals((Object)DecisionEffect.PERMIT) && result.getStatus().equals((Object)DecisionEffect.DENY)) {
                result.setStatus(DecisionEffect.PERMIT);
            }
            List scopes = result.getScopes();
            if (DecisionEffect.PERMIT.equals((Object)result.getStatus())) {
                result.setAllowedScopes(new HashSet(scopes));
            }
            if (resource.getId() != null) {
                if (!scopes.isEmpty()) {
                    result.getResource().setName(evaluationResultRepresentation.getResource().getName() + " with scopes " + String.valueOf(scopes.stream().flatMap(scopeRepresentation -> Stream.of(scopeRepresentation.getName())).toList()));
                } else {
                    result.getResource().setName(evaluationResultRepresentation.getResource().getName());
                }
            } else {
                result.getResource().setName("Any Resource with Scopes " + String.valueOf(scopes.stream().flatMap(scopeRepresentation -> Stream.of(scopeRepresentation.getName())).toList()));
            }
            result.getPolicies().addAll(evaluationResultRepresentation.getPolicies());
        });
        response.setResults(new ArrayList(groupedResults.values()));
        return response;
    }

    private static PolicyEvaluationResponse.PolicyResultRepresentation toRepresentation(Result.PolicyResult result, AuthorizationProvider authorization) {
        PolicyEvaluationResponse.PolicyResultRepresentation policyResultRep = new PolicyEvaluationResponse.PolicyResultRepresentation();
        PolicyRepresentation representation = new PolicyRepresentation();
        Policy policy = result.getPolicy();
        ResourceServer resourceServer = policy.getResourceServer();
        representation.setId(policy.getId());
        representation.setName(policy.getName());
        representation.setType(policy.getType());
        representation.setDecisionStrategy(policy.getDecisionStrategy());
        representation.setDescription(policy.getDescription());
        if ("uma".equals(representation.getType())) {
            EnumMap<PermissionTicket.FilterOption, String> filters = new EnumMap<PermissionTicket.FilterOption, String>(PermissionTicket.FilterOption.class);
            filters.put(PermissionTicket.FilterOption.POLICY_ID, policy.getId());
            List tickets = authorization.getStoreFactory().getPermissionTicketStore().find(resourceServer, filters, Integer.valueOf(-1), Integer.valueOf(1));
            if (!tickets.isEmpty()) {
                String resourceOwner;
                KeycloakSession keycloakSession = authorization.getKeycloakSession();
                RealmModel realm = authorization.getRealm();
                PermissionTicket ticket = (PermissionTicket)tickets.get(0);
                UserModel userOwner = keycloakSession.users().getUserById(realm, ticket.getOwner());
                UserModel requester = keycloakSession.users().getUserById(realm, ticket.getRequester());
                if (userOwner != null) {
                    resourceOwner = PolicyEvaluationResponseBuilder.getUserEmailOrUserName(userOwner);
                } else {
                    ClientModel clientOwner = realm.getClientById(ticket.getOwner());
                    resourceOwner = clientOwner.getClientId();
                }
                representation.setDescription("Resource owner (" + resourceOwner + ") grants access to " + PolicyEvaluationResponseBuilder.getUserEmailOrUserName(requester));
            } else {
                String description = representation.getDescription();
                if (description != null) {
                    representation.setDescription(description + " (User-Managed Policy)");
                } else {
                    representation.setDescription("User-Managed Policy");
                }
            }
        }
        representation.setResources(policy.getResources().stream().map(resource -> resource.getName()).collect(Collectors.toSet()));
        Set scopeNames = policy.getScopes().stream().map(scope -> scope.getName()).collect(Collectors.toSet());
        representation.setScopes(scopeNames);
        policyResultRep.setPolicy(representation);
        if (result.getEffect() == Decision.Effect.DENY) {
            policyResultRep.setStatus(DecisionEffect.DENY);
            policyResultRep.setScopes(representation.getScopes());
        } else {
            policyResultRep.setStatus(DecisionEffect.PERMIT);
        }
        policyResultRep.setAssociatedPolicies(result.getAssociatedPolicies().stream().map(policy1 -> PolicyEvaluationResponseBuilder.toRepresentation(policy1, authorization)).collect(Collectors.toList()));
        return policyResultRep;
    }

    private static String getUserEmailOrUserName(UserModel user) {
        return user.getEmail() != null ? user.getEmail() : user.getUsername();
    }
}

