/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import java.util.HashMap;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.models.ClientModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.CertificateRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.util.JWKSUtils;
import org.keycloak.util.JsonSerialization;

public class CertificateInfoHelper {
    public static final String PRIVATE_KEY = "private.key";
    public static final String X509CERTIFICATE = "certificate";
    public static final String PUBLIC_KEY = "public.key";
    public static final String KID = "kid";

    public static CertificateRepresentation getCertificateFromClient(ClientModel client, String attributePrefix) {
        String privateKeyAttribute = attributePrefix + ".private.key";
        String certificateAttribute = attributePrefix + ".certificate";
        String publicKeyAttribute = attributePrefix + ".public.key";
        String kidAttribute = attributePrefix + ".kid";
        if ("openid-connect".equals(client.getProtocol()) && Boolean.parseBoolean(client.getAttribute("use.jwks.string"))) {
            return CertificateInfoHelper.jwksStringToSigCertificateRepresentation(client.getAttribute("jwks.string"));
        }
        CertificateRepresentation rep = new CertificateRepresentation();
        rep.setCertificate(client.getAttribute(certificateAttribute));
        rep.setPublicKey(client.getAttribute(publicKeyAttribute));
        rep.setPrivateKey(client.getAttribute(privateKeyAttribute));
        rep.setKid(client.getAttribute(kidAttribute));
        return rep;
    }

    public static CertificateRepresentation jwksStringToSigCertificateRepresentation(String jwks) {
        if (jwks == null) {
            throw new IllegalStateException("The jwks is null!");
        }
        try {
            JSONWebKeySet keySet = (JSONWebKeySet)JsonSerialization.readValue((String)jwks, JSONWebKeySet.class);
            JWK publicKeyJwk = JWKSUtils.getKeyForUse((JSONWebKeySet)keySet, (JWK.Use)JWK.Use.SIG);
            if (publicKeyJwk == null) {
                throw new IllegalStateException("Certificate not found for use sig");
            }
            PublicKey publicKey = JWKParser.create((JWK)publicKeyJwk).toPublicKey();
            String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
            CertificateRepresentation info = new CertificateRepresentation();
            info.setPublicKey(publicKeyPem);
            info.setKid(publicKeyJwk.getKeyId());
            return info;
        }
        catch (IOException e) {
            throw new IllegalStateException("Invalid jwks representation!", e);
        }
    }

    public static void updateClientModelCertificateInfo(ClientModel client, CertificateRepresentation rep, String attributePrefix) {
        if (rep.getPublicKey() == null && rep.getCertificate() == null) {
            throw new IllegalStateException("Both certificate and publicKey are null!");
        }
        if (rep.getPublicKey() != null && rep.getCertificate() != null) {
            throw new IllegalStateException("Both certificate and publicKey are not null!");
        }
        String privateKeyAttribute = attributePrefix + ".private.key";
        String certificateAttribute = attributePrefix + ".certificate";
        String publicKeyAttribute = attributePrefix + ".public.key";
        String kidAttribute = attributePrefix + ".kid";
        CertificateInfoHelper.setOrRemoveAttr(client, privateKeyAttribute, rep.getPrivateKey());
        CertificateInfoHelper.setOrRemoveAttr(client, publicKeyAttribute, rep.getPublicKey());
        CertificateInfoHelper.setOrRemoveAttr(client, certificateAttribute, rep.getCertificate());
        CertificateInfoHelper.setOrRemoveAttr(client, kidAttribute, rep.getKid());
        if ("openid-connect".equals(client.getProtocol())) {
            CertificateInfoHelper.setOrRemoveAttr(client, "use.jwks.string", null);
            CertificateInfoHelper.setOrRemoveAttr(client, "jwks.string", null);
        }
    }

    public static void updateClientModelJwksString(ClientModel client, String attributePrefix, String jwks) {
        if (jwks == null) {
            throw new IllegalStateException("jwks string is null!");
        }
        if (!"openid-connect".equals(client.getProtocol())) {
            throw new IllegalStateException("jwks can only be set for OIDC clients!");
        }
        String privateKeyAttribute = attributePrefix + ".private.key";
        String certificateAttribute = attributePrefix + ".certificate";
        String publicKeyAttribute = attributePrefix + ".public.key";
        String kidAttribute = attributePrefix + ".kid";
        CertificateInfoHelper.setOrRemoveAttr(client, privateKeyAttribute, null);
        CertificateInfoHelper.setOrRemoveAttr(client, publicKeyAttribute, null);
        CertificateInfoHelper.setOrRemoveAttr(client, certificateAttribute, null);
        CertificateInfoHelper.setOrRemoveAttr(client, kidAttribute, null);
        CertificateInfoHelper.setOrRemoveAttr(client, "use.jwks.string", Boolean.TRUE.toString());
        CertificateInfoHelper.setOrRemoveAttr(client, "jwks.string", jwks);
    }

    private static void setOrRemoveAttr(ClientModel client, String attrName, String attrValue) {
        if (attrValue != null) {
            client.setAttribute(attrName, attrValue);
        } else {
            client.removeAttribute(attrName);
        }
    }

    public static void updateClientRepresentationCertificateInfo(ClientRepresentation client, CertificateRepresentation rep, String attributePrefix) {
        String privateKeyAttribute = attributePrefix + ".private.key";
        String certificateAttribute = attributePrefix + ".certificate";
        String publicKeyAttribute = attributePrefix + ".public.key";
        String kidAttribute = attributePrefix + ".kid";
        if (rep.getPublicKey() == null && rep.getCertificate() == null) {
            throw new IllegalStateException("Both certificate and publicKey are null!");
        }
        if (rep.getPublicKey() != null && rep.getCertificate() != null) {
            throw new IllegalStateException("Both certificate and publicKey are not null!");
        }
        CertificateInfoHelper.setOrRemoveAttr(client, privateKeyAttribute, rep.getPrivateKey());
        CertificateInfoHelper.setOrRemoveAttr(client, publicKeyAttribute, rep.getPublicKey());
        CertificateInfoHelper.setOrRemoveAttr(client, certificateAttribute, rep.getCertificate());
        CertificateInfoHelper.setOrRemoveAttr(client, kidAttribute, rep.getKid());
    }

    private static void setOrRemoveAttr(ClientRepresentation client, String attrName, String attrValue) {
        if (attrValue != null) {
            if (client.getAttributes() == null) {
                client.setAttributes(new HashMap());
            }
            client.getAttributes().put(attrName, attrValue);
        } else if (client.getAttributes() != null) {
            client.getAttributes().remove(attrName);
        }
    }
}

