/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.authenticators.broker.AbstractIdpAuthenticator;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.provider.IdentityProviderMapper;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.common.util.Time;
import org.keycloak.common.util.UriUtils;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ErrorPageException;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.services.validation.Validation;
import org.keycloak.util.JsonSerialization;

public class IdentityBrokerService
implements IdentityProvider.AuthenticationCallback {
    private static final Logger logger = Logger.getLogger(IdentityBrokerService.class);
    private final RealmModel realmModel;
    @Context
    private UriInfo uriInfo;
    @Context
    private KeycloakSession session;
    @Context
    private ClientConnection clientConnection;
    @Context
    private HttpRequest request;
    @Context
    private HttpHeaders headers;
    private EventBuilder event;

    public IdentityBrokerService(RealmModel realmModel) {
        if (realmModel == null) {
            throw new IllegalArgumentException("Realm can not be null.");
        }
        this.realmModel = realmModel;
    }

    public void init() {
        this.event = new EventBuilder(this.realmModel, this.session, this.clientConnection).event(EventType.IDENTITY_PROVIDER_LOGIN);
    }

    private void checkRealm() {
        if (!this.realmModel.isEnabled()) {
            this.event.error("realm_disabled");
            throw new ErrorPageException(this.session, "realmNotEnabledMessage", new Object[0]);
        }
    }

    private ClientModel checkClient(String clientId) {
        if (clientId == null) {
            this.event.error("invalid_request");
            throw new ErrorPageException(this.session, "missingParameterMessage", "client_id");
        }
        this.event.client(clientId);
        ClientModel client = this.realmModel.getClientByClientId(clientId);
        if (client == null) {
            this.event.error("client_not_found");
            throw new ErrorPageException(this.session, "invalidRequestMessage", new Object[0]);
        }
        if (!client.isEnabled()) {
            this.event.error("client_disabled");
            throw new ErrorPageException(this.session, "invalidRequestMessage", new Object[0]);
        }
        return client;
    }

    @OPTIONS
    @Path(value="/{provider_id}/link")
    public Response clientIntiatedAccountLinkingPreflight(@PathParam(value="provider_id") String providerId) {
        return Response.status((int)403).build();
    }

    @GET
    @NoCache
    @Path(value="/{provider_id}/link")
    public Response clientInitiatedAccountLinking(@PathParam(value="provider_id") String providerId, @QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="client_id") String clientId, @QueryParam(value="nonce") String nonce, @QueryParam(value="hash") String hash) {
        IdentityProviderModel identityProviderModel;
        String redirectOrigin;
        this.event.event(EventType.CLIENT_INITIATED_ACCOUNT_LINKING);
        this.checkRealm();
        ClientModel client = this.checkClient(clientId);
        AuthenticationManager authenticationManager = new AuthenticationManager();
        redirectUri = RedirectUtils.verifyRedirectUri(this.uriInfo, redirectUri, this.realmModel, client);
        if (redirectUri == null) {
            this.event.error("invalid_redirect_uri");
            throw new ErrorPageException(this.session, "invalidRequestMessage", new Object[0]);
        }
        if (nonce == null || hash == null) {
            this.event.error("invalid_redirect_uri");
            throw new ErrorPageException(this.session, "invalidRequestMessage", new Object[0]);
        }
        String origin = (String)this.headers.getRequestHeaders().getFirst((Object)"Origin");
        if (origin != null && !(redirectOrigin = UriUtils.getOrigin((String)redirectUri)).equals(origin)) {
            this.event.error("illegal_origin");
            throw new ErrorPageException(this.session, "invalidRequestMessage", new Object[0]);
        }
        AuthenticationManager.AuthResult cookieResult = AuthenticationManager.authenticateIdentityCookie(this.session, this.realmModel, true);
        String errorParam = "link_error";
        if (cookieResult == null) {
            this.event.error("not_logged_in");
            UriBuilder builder = UriBuilder.fromUri((String)redirectUri).queryParam(errorParam, new Object[]{"not_logged_in"}).queryParam("nonce", new Object[]{nonce});
            return Response.status((int)302).location(builder.build(new Object[0])).build();
        }
        ClientSessionModel clientSession = null;
        for (ClientSessionModel cs : cookieResult.getSession().getClientSessions()) {
            if (!cs.getClient().getClientId().equals(clientId)) continue;
            byte[] decoded = Base64Url.decode((String)hash);
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new ErrorPageException(this.session, "unexpectedErrorHandlingRequestMessage", new Object[0]);
            }
            String input = nonce + cookieResult.getSession().getId() + cs.getId() + providerId;
            byte[] check = md.digest(input.getBytes(StandardCharsets.UTF_8));
            if (!MessageDigest.isEqual(decoded, check)) continue;
            clientSession = cs;
            break;
        }
        if (clientSession == null) {
            this.event.error("invalid_token");
            throw new ErrorPageException(this.session, "invalidRequestMessage", new Object[0]);
        }
        ClientModel accountService = this.realmModel.getClientByClientId("account");
        if (!accountService.getId().equals(client.getId())) {
            RoleModel manageAccountRole = accountService.getRole("manage-account");
            if (!clientSession.getRoles().contains(manageAccountRole.getId())) {
                RoleModel linkRole = accountService.getRole("manage-account-links");
                if (!clientSession.getRoles().contains(linkRole.getId())) {
                    this.event.error("not_allowed");
                    UriBuilder builder = UriBuilder.fromUri((String)redirectUri).queryParam(errorParam, new Object[]{"not_allowed"}).queryParam("nonce", new Object[]{nonce});
                    return Response.status((int)302).location(builder.build(new Object[0])).build();
                }
            }
        }
        if ((identityProviderModel = this.realmModel.getIdentityProviderByAlias(providerId)) == null) {
            this.event.error("unknown_identity_provider");
            UriBuilder builder = UriBuilder.fromUri((String)redirectUri).queryParam(errorParam, new Object[]{"unknown_identity_provider"}).queryParam("nonce", new Object[]{nonce});
            return Response.status((int)302).location(builder.build(new Object[0])).build();
        }
        ClientSessionCode clientSessionCode = new ClientSessionCode(this.session, this.realmModel, clientSession);
        clientSessionCode.setAction(ClientSessionModel.Action.AUTHENTICATE.name());
        clientSessionCode.getCode();
        clientSession.setRedirectUri(redirectUri);
        clientSession.setNote("state", UUID.randomUUID().toString());
        this.event.success();
        try {
            IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(this.session, this.realmModel, providerId);
            Response response = identityProvider.performLogin(this.createAuthenticationRequest(providerId, clientSessionCode));
            if (response != null) {
                if (this.isDebugEnabled()) {
                    logger.debugf("Identity provider [%s] is going to send a request [%s].", (Object)identityProvider, (Object)response);
                }
                return response;
            }
        }
        catch (IdentityBrokerException e) {
            return this.redirectToErrorPage("couldNotSendAuthenticationRequestMessage", e, providerId);
        }
        catch (Exception e) {
            return this.redirectToErrorPage("unexpectedErrorHandlingRequestMessage", e, providerId);
        }
        return this.redirectToErrorPage("couldNotProceedWithAuthenticationRequestMessage", new Object[0]);
    }

    @POST
    @Path(value="/{provider_id}/login")
    public Response performPostLogin(@PathParam(value="provider_id") String providerId, @QueryParam(value="code") String code) {
        return this.performLogin(providerId, code);
    }

    @GET
    @NoCache
    @Path(value="/{provider_id}/login")
    public Response performLogin(@PathParam(value="provider_id") String providerId, @QueryParam(value="code") String code) {
        this.event.detail("identity_provider", providerId);
        if (this.isDebugEnabled()) {
            logger.debugf("Sending authentication request to identity provider [%s].", (Object)providerId);
        }
        try {
            ParsedCodeContext parsedCode = this.parseClientSessionCode(code);
            if (parsedCode.response != null) {
                return parsedCode.response;
            }
            ClientSessionCode clientSessionCode = parsedCode.clientSessionCode;
            IdentityProviderModel identityProviderModel = this.realmModel.getIdentityProviderByAlias(providerId);
            if (identityProviderModel == null) {
                throw new IdentityBrokerException("Identity Provider [" + providerId + "] not found.");
            }
            if (identityProviderModel.isLinkOnly()) {
                throw new IdentityBrokerException("Identity Provider [" + providerId + "] is not allowed to perform a login.");
            }
            IdentityProviderFactory providerFactory = IdentityBrokerService.getIdentityProviderFactory(this.session, identityProviderModel);
            IdentityProvider identityProvider = providerFactory.create(this.session, identityProviderModel);
            Response response = identityProvider.performLogin(this.createAuthenticationRequest(providerId, clientSessionCode));
            if (response != null) {
                if (this.isDebugEnabled()) {
                    logger.debugf("Identity provider [%s] is going to send a request [%s].", (Object)identityProvider, (Object)response);
                }
                return response;
            }
        }
        catch (IdentityBrokerException e) {
            return this.redirectToErrorPage("couldNotSendAuthenticationRequestMessage", e, providerId);
        }
        catch (Exception e) {
            return this.redirectToErrorPage("unexpectedErrorHandlingRequestMessage", e, providerId);
        }
        return this.redirectToErrorPage("couldNotProceedWithAuthenticationRequestMessage", new Object[0]);
    }

    @Path(value="{provider_id}/endpoint")
    public Object getEndpoint(@PathParam(value="provider_id") String providerId) {
        IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(this.session, this.realmModel, providerId);
        Object callback = identityProvider.callback(this.realmModel, (IdentityProvider.AuthenticationCallback)this, this.event);
        ResteasyProviderFactory.getInstance().injectProperties(callback);
        return callback;
    }

    @Path(value="{provider_id}/token")
    @OPTIONS
    public Response retrieveTokenPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @GET
    @NoCache
    @Path(value="{provider_id}/token")
    public Response retrieveToken(@PathParam(value="provider_id") String providerId) {
        return this.getToken(providerId, false);
    }

    private boolean canReadBrokerToken(AccessToken token) {
        Map resourceAccess = token.getResourceAccess();
        AccessToken.Access brokerRoles = resourceAccess == null ? null : (AccessToken.Access)resourceAccess.get("broker");
        return brokerRoles != null && brokerRoles.isUserInRole("read-token");
    }

    private Response getToken(String providerId, boolean forceRetrieval) {
        this.event.event(EventType.IDENTITY_PROVIDER_RETRIEVE_TOKEN);
        try {
            AppAuthManager authManager = new AppAuthManager();
            AuthenticationManager.AuthResult authResult = authManager.authenticateBearerToken(this.session, this.realmModel, this.uriInfo, this.clientConnection, this.request.getHttpHeaders());
            if (authResult != null) {
                AccessToken token = authResult.getToken();
                String[] audience = token.getAudience();
                ClientModel clientModel = this.realmModel.getClientByClientId(audience[0]);
                if (clientModel == null) {
                    return this.badRequest("Invalid client.");
                }
                this.session.getContext().setClient(clientModel);
                ClientModel brokerClient = this.realmModel.getClientByClientId("broker");
                if (brokerClient == null) {
                    return this.corsResponse(this.forbidden("Realm has not migrated to support the broker token exchange service"), clientModel);
                }
                if (!this.canReadBrokerToken(token)) {
                    return this.corsResponse(this.forbidden("Client [" + clientModel.getClientId() + "] not authorized to retrieve tokens from identity provider [" + providerId + "]."), clientModel);
                }
                IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(this.session, this.realmModel, providerId);
                IdentityProviderModel identityProviderConfig = this.getIdentityProviderConfig(providerId);
                if (identityProviderConfig.isStoreToken()) {
                    FederatedIdentityModel identity = this.session.users().getFederatedIdentity(authResult.getUser(), providerId, this.realmModel);
                    if (identity == null) {
                        return this.corsResponse(this.badRequest("User [" + authResult.getUser().getId() + "] is not associated with identity provider [" + providerId + "]."), clientModel);
                    }
                    this.event.success();
                    return this.corsResponse(identityProvider.retrieveToken(this.session, identity), clientModel);
                }
                return this.corsResponse(this.badRequest("Identity Provider [" + providerId + "] does not support this operation."), clientModel);
            }
            return this.badRequest("Invalid token.");
        }
        catch (IdentityBrokerException e) {
            return this.redirectToErrorPage("couldNotObtainTokenMessage", e, providerId);
        }
        catch (Exception e) {
            return this.redirectToErrorPage("unexpectedErrorRetrievingTokenMessage", e, providerId);
        }
    }

    public Response authenticated(BrokeredIdentityContext context) {
        IdentityProviderModel identityProviderConfig = context.getIdpConfig();
        ParsedCodeContext parsedCode = context.getContextData().get("SAML_IDP_INITIATED_CLIENT_ID") != null ? this.samlIdpInitiatedSSO((String)context.getContextData().get("SAML_IDP_INITIATED_CLIENT_ID")) : this.parseClientSessionCode(context.getCode());
        if (parsedCode.response != null) {
            return parsedCode.response;
        }
        ClientSessionCode clientCode = parsedCode.clientSessionCode;
        String providerId = identityProviderConfig.getAlias();
        if (!identityProviderConfig.isStoreToken()) {
            if (this.isDebugEnabled()) {
                logger.debugf("Token will not be stored for identity provider [%s].", (Object)providerId);
            }
            context.setToken(null);
        }
        ClientSessionModel clientSession = clientCode.getClientSession();
        context.setClientSession(clientSession);
        this.session.getContext().setClient(clientSession.getClient());
        context.getIdp().preprocessFederatedIdentity(this.session, this.realmModel, context);
        Set mappers = this.realmModel.getIdentityProviderMappersByAlias(context.getIdpConfig().getAlias());
        if (mappers != null) {
            KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
            for (IdentityProviderMapperModel mapper : mappers) {
                IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                target.preprocessFederatedIdentity(this.session, this.realmModel, mapper, context);
            }
        }
        FederatedIdentityModel federatedIdentityModel = new FederatedIdentityModel(providerId, context.getId(), context.getUsername(), context.getToken());
        this.event.event(EventType.IDENTITY_PROVIDER_LOGIN).detail("redirect_uri", clientSession.getRedirectUri()).detail("identity_provider_identity", context.getUsername());
        UserModel federatedUser = this.session.users().getUserByFederatedIdentity(federatedIdentityModel, this.realmModel);
        if (clientSession.getUserSession() != null) {
            return this.performAccountLinking(clientSession, context, federatedIdentityModel, federatedUser);
        }
        if (federatedUser == null) {
            logger.debugf("Federated user not found for provider '%s' and broker username '%s' . Redirecting to flow for firstBrokerLogin", (Object)providerId, (Object)context.getUsername());
            String username = context.getModelUsername();
            if (username == null) {
                username = this.realmModel.isRegistrationEmailAsUsername() && !Validation.isBlank(context.getEmail()) ? context.getEmail() : (context.getUsername() == null ? context.getIdpConfig().getAlias() + "." + context.getId() : context.getUsername());
            }
            username = username.trim();
            context.setModelUsername(username);
            clientSession.setTimestamp(Time.currentTime());
            SerializedBrokeredIdentityContext ctx = SerializedBrokeredIdentityContext.serialize(context);
            ctx.saveToClientSession(clientSession, "BROKERED_CONTEXT");
            URI redirect = LoginActionsService.firstBrokerLoginProcessor(this.uriInfo).queryParam("code", new Object[]{clientCode.getCode()}).build(new Object[]{this.realmModel.getName()});
            return Response.status((int)302).location(redirect).build();
        }
        Response response = this.validateUser(federatedUser, this.realmModel);
        if (response != null) {
            return response;
        }
        this.updateFederatedIdentity(context, federatedUser);
        clientSession.setAuthenticatedUser(federatedUser);
        return this.finishOrRedirectToPostBrokerLogin(clientSession, context, false, parsedCode.clientSessionCode);
    }

    public Response validateUser(UserModel user, RealmModel realm) {
        if (!user.isEnabled()) {
            this.event.error("user_disabled");
            return ErrorPage.error(this.session, "accountDisabledMessage", new Object[0]);
        }
        if (realm.isBruteForceProtected() && ((BruteForceProtector)this.session.getProvider(BruteForceProtector.class)).isTemporarilyDisabled(this.session, realm, user)) {
            this.event.error("user_temporarily_disabled");
            return ErrorPage.error(this.session, "accountDisabledMessage", new Object[0]);
        }
        return null;
    }

    @GET
    @NoCache
    @Path(value="/after-first-broker-login")
    public Response afterFirstBrokerLogin(@QueryParam(value="code") String code) {
        ParsedCodeContext parsedCode = this.parseClientSessionCode(code);
        if (parsedCode.response != null) {
            return parsedCode.response;
        }
        return this.afterFirstBrokerLogin(parsedCode.clientSessionCode);
    }

    private Response afterFirstBrokerLogin(ClientSessionCode clientSessionCode) {
        ClientSessionModel clientSession = clientSessionCode.getClientSession();
        try {
            this.event.detail("code_id", clientSession.getId()).removeDetail("auth_method");
            SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromClientSession(clientSession, "BROKERED_CONTEXT");
            if (serializedCtx == null) {
                throw new IdentityBrokerException("Not found serialized context in clientSession");
            }
            BrokeredIdentityContext context = serializedCtx.deserialize(this.session, clientSession);
            String providerId = context.getIdpConfig().getAlias();
            this.event.detail("identity_provider", providerId);
            this.event.detail("identity_provider_identity", context.getUsername());
            clientSession.removeNote("BROKERED_CONTEXT");
            UserModel federatedUser = clientSession.getAuthenticatedUser();
            if (federatedUser == null) {
                throw new IdentityBrokerException("Couldn't found authenticated federatedUser in clientSession");
            }
            this.event.user(federatedUser);
            this.event.detail("username", federatedUser.getUsername());
            if (context.getIdpConfig().isAddReadTokenRoleOnCreate()) {
                ClientModel brokerClient = this.realmModel.getClientByClientId("broker");
                if (brokerClient == null) {
                    throw new IdentityBrokerException("Client 'broker' not available. Maybe realm has not migrated to support the broker token exchange service");
                }
                RoleModel readTokenRole = brokerClient.getRole("read-token");
                federatedUser.grantRole(readTokenRole);
            }
            FederatedIdentityModel federatedIdentityModel = new FederatedIdentityModel(context.getIdpConfig().getAlias(), context.getId(), context.getUsername(), context.getToken());
            this.session.users().addFederatedIdentity(this.realmModel, federatedUser, federatedIdentityModel);
            String isRegisteredNewUser = clientSession.getNote("BROKER_REGISTERED_NEW_USER");
            if (Boolean.parseBoolean(isRegisteredNewUser)) {
                logger.debugf("Registered new user '%s' after first login with identity provider '%s'. Identity provider username is '%s' . ", (Object)federatedUser.getUsername(), (Object)providerId, (Object)context.getUsername());
                context.getIdp().importNewUser(this.session, this.realmModel, federatedUser, context);
                Set mappers = this.realmModel.getIdentityProviderMappersByAlias(providerId);
                if (mappers != null) {
                    KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
                    for (IdentityProviderMapperModel mapper : mappers) {
                        IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                        target.importNewUser(this.session, this.realmModel, federatedUser, mapper, context);
                    }
                }
                if (context.getIdpConfig().isTrustEmail() && !Validation.isBlank(federatedUser.getEmail()) && !Boolean.parseBoolean(clientSession.getNote("UPDATE_PROFILE_EMAIL_CHANGED"))) {
                    logger.debugf("Email verified automatically after registration of user '%s' through Identity provider '%s' ", (Object)federatedUser.getUsername(), (Object)context.getIdpConfig().getAlias());
                    federatedUser.setEmailVerified(true);
                }
                this.event.event(EventType.REGISTER).detail("register_method", "broker").detail("email", federatedUser.getEmail()).success();
            } else {
                logger.debugf("Linked existing keycloak user '%s' with identity provider '%s' . Identity provider username is '%s' .", (Object)federatedUser.getUsername(), (Object)providerId, (Object)context.getUsername());
                this.event.event(EventType.FEDERATED_IDENTITY_LINK).success();
                this.updateFederatedIdentity(context, federatedUser);
            }
            return this.finishOrRedirectToPostBrokerLogin(clientSession, context, true, clientSessionCode);
        }
        catch (Exception e) {
            return this.redirectToErrorPage("identityProviderUnexpectedErrorMessage", e, new Object[0]);
        }
    }

    private Response finishOrRedirectToPostBrokerLogin(ClientSessionModel clientSession, BrokeredIdentityContext context, boolean wasFirstBrokerLogin, ClientSessionCode clientSessionCode) {
        String postBrokerLoginFlowId = context.getIdpConfig().getPostBrokerLoginFlowId();
        if (postBrokerLoginFlowId == null) {
            logger.debugf("Skip redirect to postBrokerLogin flow. PostBrokerLogin flow not set for identityProvider '%s'.", (Object)context.getIdpConfig().getAlias());
            return this.afterPostBrokerLoginFlowSuccess(clientSession, context, wasFirstBrokerLogin, clientSessionCode);
        }
        logger.debugf("Redirect to postBrokerLogin flow after authentication with identityProvider '%s'.", (Object)context.getIdpConfig().getAlias());
        clientSession.setTimestamp(Time.currentTime());
        SerializedBrokeredIdentityContext ctx = SerializedBrokeredIdentityContext.serialize(context);
        ctx.saveToClientSession(clientSession, "PBL_BROKERED_IDENTITY_CONTEXT");
        clientSession.setNote("PBL_AFTER_FIRST_BROKER_LOGIN", String.valueOf(wasFirstBrokerLogin));
        URI redirect = LoginActionsService.postBrokerLoginProcessor(this.uriInfo).queryParam("code", new Object[]{clientSessionCode.getCode()}).build(new Object[]{this.realmModel.getName()});
        return Response.status((int)302).location(redirect).build();
    }

    @GET
    @NoCache
    @Path(value="/after-post-broker-login")
    public Response afterPostBrokerLoginFlow(@QueryParam(value="code") String code) {
        ParsedCodeContext parsedCode = this.parseClientSessionCode(code);
        if (parsedCode.response != null) {
            return parsedCode.response;
        }
        ClientSessionModel clientSession = parsedCode.clientSessionCode.getClientSession();
        try {
            SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromClientSession(clientSession, "PBL_BROKERED_IDENTITY_CONTEXT");
            if (serializedCtx == null) {
                throw new IdentityBrokerException("Not found serialized context in clientSession. Note PBL_BROKERED_IDENTITY_CONTEXT was null");
            }
            BrokeredIdentityContext context = serializedCtx.deserialize(this.session, clientSession);
            String wasFirstBrokerLoginNote = clientSession.getNote("PBL_AFTER_FIRST_BROKER_LOGIN");
            boolean wasFirstBrokerLogin = Boolean.parseBoolean(wasFirstBrokerLoginNote);
            String authStateNoteKey = "PBL_AUTH_STATE." + context.getIdpConfig().getAlias();
            String authState = clientSession.getNote(authStateNoteKey);
            if (!Boolean.parseBoolean(authState)) {
                throw new IdentityBrokerException("Invalid request. Not found the flag that post-broker-login flow was finished");
            }
            clientSession.removeNote("PBL_BROKERED_IDENTITY_CONTEXT");
            clientSession.removeNote("PBL_AFTER_FIRST_BROKER_LOGIN");
            return this.afterPostBrokerLoginFlowSuccess(clientSession, context, wasFirstBrokerLogin, parsedCode.clientSessionCode);
        }
        catch (IdentityBrokerException e) {
            return this.redirectToErrorPage("identityProviderUnexpectedErrorMessage", e, new Object[0]);
        }
    }

    private Response afterPostBrokerLoginFlowSuccess(ClientSessionModel clientSession, BrokeredIdentityContext context, boolean wasFirstBrokerLogin, ClientSessionCode clientSessionCode) {
        boolean firstBrokerLoginInProgress;
        String providerId = context.getIdpConfig().getAlias();
        UserModel federatedUser = clientSession.getAuthenticatedUser();
        if (wasFirstBrokerLogin) {
            String isDifferentBrowser = clientSession.getNote("IS_DIFFERENT_BROWSER");
            if (Boolean.parseBoolean(isDifferentBrowser)) {
                this.session.sessions().removeClientSession(this.realmModel, clientSession);
                return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setSuccess("identityProviderLinkSuccess", new Object[]{context.getIdpConfig().getAlias(), context.getUsername()}).createInfoPage();
            }
            return this.finishBrokerAuthentication(context, federatedUser, clientSession, providerId);
        }
        boolean bl = firstBrokerLoginInProgress = clientSession.getNote("BROKERED_CONTEXT") != null;
        if (firstBrokerLoginInProgress) {
            logger.debugf("Reauthenticated with broker '%s' when linking user '%s' with other broker", (Object)context.getIdpConfig().getAlias(), (Object)federatedUser.getUsername());
            UserModel linkingUser = AbstractIdpAuthenticator.getExistingUser(this.session, this.realmModel, clientSession);
            if (!linkingUser.getId().equals(federatedUser.getId())) {
                return this.redirectToErrorPage("identityProviderDifferentUserMessage", federatedUser.getUsername(), linkingUser.getUsername());
            }
            return this.afterFirstBrokerLogin(clientSessionCode);
        }
        return this.finishBrokerAuthentication(context, federatedUser, clientSession, providerId);
    }

    private Response finishBrokerAuthentication(BrokeredIdentityContext context, UserModel federatedUser, ClientSessionModel clientSession, String providerId) {
        UserSessionModel userSession = this.session.sessions().createUserSession(this.realmModel, federatedUser, federatedUser.getUsername(), this.clientConnection.getRemoteAddr(), "broker", false, context.getBrokerSessionId(), context.getBrokerUserId());
        this.event.user(federatedUser);
        this.event.session(userSession);
        TokenManager.attachClientSession(userSession, clientSession);
        context.getIdp().attachUserSession(userSession, clientSession, context);
        userSession.setNote("identity_provider", providerId);
        userSession.setNote("identity_provider_identity", context.getUsername());
        if (this.isDebugEnabled()) {
            logger.debugf("Performing local authentication for user [%s].", (Object)federatedUser);
        }
        return AuthenticationProcessor.redirectToRequiredActions(this.session, this.realmModel, clientSession, this.uriInfo);
    }

    public Response cancelled(String code) {
        ParsedCodeContext parsedCode = this.parseClientSessionCode(code);
        if (parsedCode.response != null) {
            return parsedCode.response;
        }
        ClientSessionCode clientCode = parsedCode.clientSessionCode;
        Response accountManagementFailedLinking = this.checkAccountManagementFailedLinking(clientCode.getClientSession(), "consentDenied", new Object[0]);
        if (accountManagementFailedLinking != null) {
            return accountManagementFailedLinking;
        }
        return this.browserAuthentication(clientCode.getClientSession(), null);
    }

    public Response error(String code, String message) {
        ParsedCodeContext parsedCode = this.parseClientSessionCode(code);
        if (parsedCode.response != null) {
            return parsedCode.response;
        }
        ClientSessionCode clientCode = parsedCode.clientSessionCode;
        Response accountManagementFailedLinking = this.checkAccountManagementFailedLinking(clientCode.getClientSession(), message, new Object[0]);
        if (accountManagementFailedLinking != null) {
            return accountManagementFailedLinking;
        }
        return this.browserAuthentication(clientCode.getClientSession(), message);
    }

    private Response performAccountLinking(ClientSessionModel clientSession, BrokeredIdentityContext context, FederatedIdentityModel federatedIdentityModel, UserModel federatedUser) {
        this.event.event(EventType.FEDERATED_IDENTITY_LINK);
        UserModel authenticatedUser = clientSession.getUserSession().getUser();
        if (federatedUser != null) {
            if (authenticatedUser.getId().equals(federatedUser.getId())) {
                if (context.getIdpConfig().isStoreToken()) {
                    federatedIdentityModel = this.session.users().getFederatedIdentity(federatedUser, context.getIdpConfig().getAlias(), this.realmModel);
                    if (!ObjectUtil.isEqualOrBothNull((Object)context.getToken(), (Object)federatedIdentityModel.getToken())) {
                        this.session.users().updateFederatedIdentity(this.realmModel, federatedUser, federatedIdentityModel);
                        if (this.isDebugEnabled()) {
                            logger.debugf("Identity [%s] update with response from identity provider [%s].", (Object)federatedUser, (Object)context.getIdpConfig().getAlias());
                        }
                    }
                }
                return Response.status((int)302).location(UriBuilder.fromUri((String)clientSession.getRedirectUri()).build(new Object[0])).build();
            }
            return this.redirectToAccountErrorPage(clientSession, "identityProviderAlreadyLinkedMessage", context.getIdpConfig().getAlias());
        }
        if (this.isDebugEnabled()) {
            logger.debugf("Linking account [%s] from identity provider [%s] to user [%s].", (Object)federatedIdentityModel, (Object)context.getIdpConfig().getAlias(), (Object)authenticatedUser);
        }
        if (!authenticatedUser.isEnabled()) {
            return this.redirectToAccountErrorPage(clientSession, "accountDisabledMessage", new Object[0]);
        }
        if (!authenticatedUser.hasRole(this.realmModel.getClientByClientId("account").getRole("manage-account"))) {
            return this.redirectToErrorPage("insufficientPermissionMessage", new Object[0]);
        }
        this.session.users().addFederatedIdentity(this.realmModel, authenticatedUser, federatedIdentityModel);
        context.getIdp().attachUserSession(clientSession.getUserSession(), clientSession, context);
        this.event.user(authenticatedUser).detail("username", authenticatedUser.getUsername()).detail("identity_provider", federatedIdentityModel.getIdentityProvider()).detail("identity_provider_identity", federatedIdentityModel.getUserName()).success();
        return Response.status((int)302).location(UriBuilder.fromUri((String)clientSession.getRedirectUri()).build(new Object[0])).build();
    }

    private void updateFederatedIdentity(BrokeredIdentityContext context, UserModel federatedUser) {
        FederatedIdentityModel federatedIdentityModel = this.session.users().getFederatedIdentity(federatedUser, context.getIdpConfig().getAlias(), this.realmModel);
        this.updateToken(context, federatedUser, federatedIdentityModel);
        context.getIdp().updateBrokeredUser(this.session, this.realmModel, federatedUser, context);
        Set mappers = this.realmModel.getIdentityProviderMappersByAlias(context.getIdpConfig().getAlias());
        if (mappers != null) {
            KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
            for (IdentityProviderMapperModel mapper : mappers) {
                IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                target.updateBrokeredUser(this.session, this.realmModel, federatedUser, mapper, context);
            }
        }
    }

    private void updateToken(BrokeredIdentityContext context, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        if (context.getIdpConfig().isStoreToken() && !ObjectUtil.isEqualOrBothNull((Object)context.getToken(), (Object)federatedIdentityModel.getToken())) {
            federatedIdentityModel.setToken(context.getToken());
            this.session.users().updateFederatedIdentity(this.realmModel, federatedUser, federatedIdentityModel);
            if (this.isDebugEnabled()) {
                logger.debugf("Identity [%s] update with response from identity provider [%s].", (Object)federatedUser, (Object)context.getIdpConfig().getAlias());
            }
        }
    }

    private ParsedCodeContext parseClientSessionCode(String code) {
        ClientSessionCode clientCode = ClientSessionCode.parse((String)code, (KeycloakSession)this.session, (RealmModel)this.realmModel);
        if (clientCode != null) {
            ClientModel client;
            ClientSessionModel clientSession = clientCode.getClientSession();
            if (clientSession.getUserSession() != null) {
                this.event.session(clientSession.getUserSession());
            }
            if ((client = clientSession.getClient()) != null) {
                logger.debugf("Got authorization code from client [%s].", (Object)client.getClientId());
                this.event.client(client);
                this.session.getContext().setClient(client);
                if (!clientCode.isValid(ClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
                    logger.debugf("Authorization code is not valid. Client session ID: %s, Client session's action: %s", (Object)clientSession.getId(), (Object)clientSession.getAction());
                    Response accountManagementFailedLinking = this.checkAccountManagementFailedLinking(clientCode.getClientSession(), "staleCodeAccountMessage", new Object[0]);
                    Response staleCodeError = accountManagementFailedLinking != null ? accountManagementFailedLinking : this.redirectToErrorPage("staleCodeMessage", new Object[0]);
                    return ParsedCodeContext.response(staleCodeError);
                }
                if (this.isDebugEnabled()) {
                    logger.debugf("Authorization code is valid.", new Object[0]);
                }
                return ParsedCodeContext.clientSessionCode(clientCode);
            }
        }
        logger.debugf("Authorization code is not valid. Code: %s", (Object)code);
        Response staleCodeError = this.redirectToErrorPage("staleCodeMessage", new Object[0]);
        return ParsedCodeContext.response(staleCodeError);
    }

    private ParsedCodeContext samlIdpInitiatedSSO(String clientUrlName) {
        this.event.event(EventType.LOGIN);
        CacheControlUtil.noBackButtonCacheControlHeader();
        Optional<ClientModel> oClient = this.realmModel.getClients().stream().filter(c -> Objects.equals(c.getAttribute("saml_idp_initiated_sso_url_name"), clientUrlName)).findFirst();
        if (!oClient.isPresent()) {
            this.event.error("client_not_found");
            return ParsedCodeContext.response(this.redirectToErrorPage("clientNotFoundMessage", new Object[0]));
        }
        ClientSessionModel clientSession = SamlService.createClientSessionForIdpInitiatedSso(this.session, this.realmModel, oClient.get(), null);
        return ParsedCodeContext.clientSessionCode(new ClientSessionCode(this.session, this.realmModel, clientSession));
    }

    protected boolean isClientSessionRegistered(String code) {
        if (code == null) {
            return false;
        }
        try {
            return ClientSessionCode.getClientSession((String)code, (KeycloakSession)this.session, (RealmModel)this.realmModel) != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private Response checkAccountManagementFailedLinking(ClientSessionModel clientSession, String error, Object ... parameters) {
        if (clientSession.getUserSession() != null && clientSession.getClient() != null && clientSession.getClient().getClientId().equals("account")) {
            this.event.event(EventType.FEDERATED_IDENTITY_LINK);
            UserModel user = clientSession.getUserSession().getUser();
            this.event.user(user);
            this.event.detail("username", user.getUsername());
            return this.redirectToAccountErrorPage(clientSession, error, parameters);
        }
        return null;
    }

    private AuthenticationRequest createAuthenticationRequest(String providerId, ClientSessionCode clientSessionCode) {
        ClientSessionModel clientSession = null;
        String relayState = null;
        if (clientSessionCode != null) {
            clientSession = clientSessionCode.getClientSession();
            relayState = clientSessionCode.getCode();
        }
        return new AuthenticationRequest(this.session, this.realmModel, clientSession, this.request, this.uriInfo, relayState, this.getRedirectUri(providerId));
    }

    private String getRedirectUri(String providerId) {
        return Urls.identityProviderAuthnResponse(this.uriInfo.getBaseUri(), providerId, this.realmModel.getName()).toString();
    }

    private Response redirectToErrorPage(String message, Object ... parameters) {
        return this.redirectToErrorPage(message, null, parameters);
    }

    private Response redirectToErrorPage(String message, Throwable throwable, Object ... parameters) {
        if (message == null) {
            message = "identityProviderUnexpectedErrorMessage";
        }
        this.fireErrorEvent(message, throwable);
        return ErrorPage.error(this.session, message, parameters);
    }

    private Response redirectToAccountErrorPage(ClientSessionModel clientSession, String message, Object ... parameters) {
        this.fireErrorEvent(message);
        FormMessage errorMessage = new FormMessage(message, parameters);
        try {
            String serializedError = JsonSerialization.writeValueAsString((Object)errorMessage);
            clientSession.setNote("ACCOUNT_MGMT_FORWARDED_ERROR", serializedError);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return Response.status((int)302).location(UriBuilder.fromUri((String)clientSession.getRedirectUri()).build(new Object[0])).build();
    }

    private Response redirectToLoginPage(Throwable t, ClientSessionCode clientCode) {
        String message = t.getMessage();
        if (message == null) {
            message = "identityProviderUnexpectedErrorMessage";
        }
        this.fireErrorEvent(message);
        return this.browserAuthentication(clientCode.getClientSession(), message);
    }

    protected Response browserAuthentication(ClientSessionModel clientSession, String errorMessage) {
        this.event.event(EventType.LOGIN);
        AuthenticationFlowModel flow = this.realmModel.getBrowserFlow();
        String flowId = flow.getId();
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setClientSession(clientSession).setFlowPath("authenticate").setFlowId(flowId).setBrowserFlow(true).setConnection(this.clientConnection).setEventBuilder(this.event).setRealm(this.realmModel).setSession(this.session).setUriInfo(this.uriInfo).setRequest(this.request);
        if (errorMessage != null) {
            processor.setForwardedErrorMessage(new FormMessage(null, errorMessage));
        }
        try {
            CacheControlUtil.noBackButtonCacheControlHeader();
            return processor.authenticate();
        }
        catch (Exception e) {
            return processor.handleBrowserException(e);
        }
    }

    private Response badRequest(String message) {
        this.fireErrorEvent(message);
        return ErrorResponse.error(message, Response.Status.BAD_REQUEST);
    }

    private Response forbidden(String message) {
        this.fireErrorEvent(message);
        return ErrorResponse.error(message, Response.Status.FORBIDDEN);
    }

    public static IdentityProvider getIdentityProvider(KeycloakSession session, RealmModel realm, String alias) {
        IdentityProviderModel identityProviderModel = realm.getIdentityProviderByAlias(alias);
        if (identityProviderModel != null) {
            IdentityProviderFactory providerFactory = IdentityBrokerService.getIdentityProviderFactory(session, identityProviderModel);
            if (providerFactory == null) {
                throw new IdentityBrokerException("Could not find factory for identity provider [" + alias + "].");
            }
            return providerFactory.create(session, identityProviderModel);
        }
        throw new IdentityBrokerException("Identity Provider [" + alias + "] not found.");
    }

    private static IdentityProviderFactory getIdentityProviderFactory(KeycloakSession session, IdentityProviderModel model) {
        HashMap<String, IdentityProviderFactory> availableProviders = new HashMap<String, IdentityProviderFactory>();
        ArrayList allProviders = new ArrayList();
        allProviders.addAll(session.getKeycloakSessionFactory().getProviderFactories(IdentityProvider.class));
        allProviders.addAll(session.getKeycloakSessionFactory().getProviderFactories(SocialIdentityProvider.class));
        for (ProviderFactory providerFactory : allProviders) {
            availableProviders.put(providerFactory.getId(), (IdentityProviderFactory)providerFactory);
        }
        return (IdentityProviderFactory)availableProviders.get(model.getProviderId());
    }

    private IdentityProviderModel getIdentityProviderConfig(String providerId) {
        IdentityProviderModel model = this.realmModel.getIdentityProviderByAlias(providerId);
        if (model == null) {
            throw new IdentityBrokerException("Configuration for identity provider [" + providerId + "] not found.");
        }
        return model;
    }

    private Response corsResponse(Response response, ClientModel clientModel) {
        return Cors.add(this.request, Response.fromResponse((Response)response)).auth().allowedOrigins(this.uriInfo, clientModel).build();
    }

    private void fireErrorEvent(String message, Throwable throwable) {
        if (!this.event.getEvent().getType().toString().endsWith("_ERROR")) {
            boolean newTransaction = !this.session.getTransactionManager().isActive();
            try {
                if (newTransaction) {
                    this.session.getTransactionManager().begin();
                }
                this.event.error(message);
                if (newTransaction) {
                    this.session.getTransactionManager().commit();
                }
            }
            catch (Exception e) {
                ServicesLogger.LOGGER.couldNotFireEvent(e);
                this.rollback();
            }
        }
        if (throwable != null) {
            logger.error((Object)message, throwable);
        } else {
            logger.error((Object)message);
        }
    }

    private void fireErrorEvent(String message) {
        this.fireErrorEvent(message, null);
    }

    private boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    private void rollback() {
        if (this.session.getTransactionManager().isActive()) {
            this.session.getTransactionManager().rollback();
        }
    }

    private static class ParsedCodeContext {
        private ClientSessionCode clientSessionCode;
        private Response response;

        private ParsedCodeContext() {
        }

        public static ParsedCodeContext clientSessionCode(ClientSessionCode clientSessionCode) {
            ParsedCodeContext ctx = new ParsedCodeContext();
            ctx.clientSessionCode = clientSessionCode;
            return ctx;
        }

        public static ParsedCodeContext response(Response response) {
            ParsedCodeContext ctx = new ParsedCodeContext();
            ctx.response = response;
            return ctx;
        }
    }
}

