/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.resetcred;

import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.resetcred.AbstractSetRequiredActionAuthenticator;
import org.keycloak.models.UserModel;
import org.keycloak.services.resources.LoginActionsService;

public class ResetPassword
extends AbstractSetRequiredActionAuthenticator {
    public static final String PROVIDER_ID = "reset-password";

    public void authenticate(AuthenticationFlowContext context) {
        String actionCookie = LoginActionsService.getActionCookie(context.getSession().getContext().getRequestHeaders(), context.getRealm(), context.getUriInfo(), context.getConnection());
        if (actionCookie == null || !actionCookie.equals(context.getClientSession().getId())) {
            context.getClientSession().setNote("END_AFTER_REQUIRED_ACTIONS", "true");
        }
        if (context.getExecution().isRequired() || context.getExecution().isOptional() && this.configuredFor(context)) {
            context.getClientSession().addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        context.success();
    }

    protected boolean configuredFor(AuthenticationFlowContext context) {
        return context.getSession().userCredentialManager().isConfiguredFor(context.getRealm(), context.getUser(), "password");
    }

    public String getDisplayType() {
        return "Reset Password";
    }

    public String getHelpText() {
        return "Sets the Update Password required action if execution is REQUIRED.  Will also set it if execution is OPTIONAL and the password is currently configured for it.";
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

