/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.x509;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.x509.CertificateValidator;
import org.keycloak.authentication.authenticators.x509.UserIdentityExtractor;
import org.keycloak.authentication.authenticators.x509.UserIdentityToModelMapper;
import org.keycloak.authentication.authenticators.x509.X509AuthenticatorConfigModel;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;

public abstract class AbstractX509ClientCertificateAuthenticator
implements Authenticator {
    public static final String DEFAULT_ATTRIBUTE_NAME = "usercertificate";
    protected static ServicesLogger logger = ServicesLogger.LOGGER;
    public static final String JAVAX_SERVLET_REQUEST_X509_CERTIFICATE = "javax.servlet.request.X509Certificate";
    public static final String REGULAR_EXPRESSION = "x509-cert-auth.regular-expression";
    public static final String ENABLE_CRL = "x509-cert-auth.crl-checking-enabled";
    public static final String ENABLE_OCSP = "x509-cert-auth.ocsp-checking-enabled";
    public static final String ENABLE_CRLDP = "x509-cert-auth.crldp-checking-enabled";
    public static final String CRL_RELATIVE_PATH = "x509-cert-auth.crl-relative-path";
    public static final String OCSPRESPONDER_URI = "x509-cert-auth.ocsp-responder-uri";
    public static final String MAPPING_SOURCE_SELECTION = "x509-cert-auth.mapping-source-selection";
    public static final String MAPPING_SOURCE_CERT_SUBJECTDN = "Match SubjectDN using regular expression";
    public static final String MAPPING_SOURCE_CERT_SUBJECTDN_EMAIL = "Subject's e-mail";
    public static final String MAPPING_SOURCE_CERT_SUBJECTDN_CN = "Subject's Common Name";
    public static final String MAPPING_SOURCE_CERT_ISSUERDN = "Match IssuerDN using regular expression";
    public static final String MAPPING_SOURCE_CERT_ISSUERDN_EMAIL = "Issuer's e-mail";
    public static final String MAPPING_SOURCE_CERT_ISSUERDN_CN = "Issuer's Common Name";
    public static final String MAPPING_SOURCE_CERT_SERIALNUMBER = "Certificate Serial Number";
    public static final String USER_MAPPER_SELECTION = "x509-cert-auth.mapper-selection";
    public static final String USER_ATTRIBUTE_MAPPER = "Custom Attribute Mapper";
    public static final String USERNAME_EMAIL_MAPPER = "Username or Email";
    public static final String CUSTOM_ATTRIBUTE_NAME = "x509-cert-auth.mapper-selection.user-attribute-name";
    public static final String CERTIFICATE_KEY_USAGE = "x509-cert-auth.keyusage";
    public static final String CERTIFICATE_EXTENDED_KEY_USAGE = "x509-cert-auth.extendedkeyusage";
    static final String DEFAULT_MATCH_ALL_EXPRESSION = "(.*?)(?:$)";
    public static final String CONFIRMATION_PAGE_DISALLOWED = "x509-cert-auth.confirmation-page-disallowed";

    protected Response createInfoResponse(AuthenticationFlowContext context, String infoMessage, Object ... parameters) {
        LoginFormsProvider form = context.form();
        return form.setInfo(infoMessage, parameters).createInfoPage();
    }

    public CertificateValidator.CertificateValidatorBuilder certificateValidationParameters(X509AuthenticatorConfigModel config) throws Exception {
        return CertificateValidatorConfigBuilder.fromConfig(config);
    }

    public void close() {
    }

    protected X509Certificate[] getCertificateChain(AuthenticationFlowContext context) {
        X509Certificate[] certs = (X509Certificate[])context.getHttpRequest().getAttribute(JAVAX_SERVLET_REQUEST_X509_CERTIFICATE);
        if (certs != null) {
            for (X509Certificate cert : certs) {
                logger.tracef("[X509ClientCertificateAuthenticator:getCertificateChain] \"%s\"", cert.getSubjectDN().getName());
            }
        }
        return certs;
    }

    public UserIdentityExtractor getUserIdentityExtractor(X509AuthenticatorConfigModel config) {
        return UserIdentityExtractorBuilder.fromConfig(config);
    }

    public UserIdentityToModelMapper getUserIdentityToModelMapper(X509AuthenticatorConfigModel config) {
        return UserIdentityToModelMapperBuilder.fromConfig(config);
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    protected static class UserIdentityToModelMapperBuilder {
        protected UserIdentityToModelMapperBuilder() {
        }

        static UserIdentityToModelMapper fromConfig(X509AuthenticatorConfigModel config) {
            X509AuthenticatorConfigModel.IdentityMapperType mapperType = config.getUserIdentityMapperType();
            String attributeName = config.getCustomAttributeName();
            UserIdentityToModelMapper mapper = null;
            switch (mapperType) {
                case USER_ATTRIBUTE: {
                    mapper = UserIdentityToModelMapper.getUserIdentityToCustomAttributeMapper(attributeName);
                    break;
                }
                case USERNAME_EMAIL: {
                    mapper = UserIdentityToModelMapper.getUsernameOrEmailMapper();
                    break;
                }
                default: {
                    logger.warnf("[UserIdentityToModelMapperBuilder:fromConfig] Unknown or unsupported user identity mapper: \"%s\"", mapperType.getName());
                }
            }
            return mapper;
        }
    }

    protected static class UserIdentityExtractorBuilder {
        private static final Function<X509Certificate[], X500Name> subject = certs -> {
            try {
                return new JcaX509CertificateHolder(certs[0]).getSubject();
            }
            catch (CertificateEncodingException e) {
                logger.warn("Unable to get certificate Subject", e);
                return null;
            }
        };
        private static final Function<X509Certificate[], X500Name> issuer = certs -> {
            try {
                return new JcaX509CertificateHolder(certs[0]).getIssuer();
            }
            catch (CertificateEncodingException e) {
                logger.warn("Unable to get certificate Issuer", e);
                return null;
            }
        };

        protected UserIdentityExtractorBuilder() {
        }

        static UserIdentityExtractor fromConfig(X509AuthenticatorConfigModel config) {
            X509AuthenticatorConfigModel.MappingSourceType userIdentitySource = config.getMappingSourceType();
            String pattern = config.getRegularExpression();
            UserIdentityExtractor extractor = null;
            switch (userIdentitySource) {
                case SUBJECTDN: {
                    extractor = UserIdentityExtractor.getPatternIdentityExtractor(pattern, certs -> certs[0].getSubjectDN().getName());
                    break;
                }
                case ISSUERDN: {
                    extractor = UserIdentityExtractor.getPatternIdentityExtractor(pattern, certs -> certs[0].getIssuerDN().getName());
                    break;
                }
                case SERIALNUMBER: {
                    extractor = UserIdentityExtractor.getPatternIdentityExtractor(AbstractX509ClientCertificateAuthenticator.DEFAULT_MATCH_ALL_EXPRESSION, certs -> certs[0].getSerialNumber().toString());
                    break;
                }
                case SUBJECTDN_CN: {
                    extractor = UserIdentityExtractor.getX500NameExtractor(BCStyle.CN, subject);
                    break;
                }
                case SUBJECTDN_EMAIL: {
                    extractor = UserIdentityExtractor.either(UserIdentityExtractor.getX500NameExtractor(BCStyle.EmailAddress, subject)).or(UserIdentityExtractor.getX500NameExtractor(BCStyle.E, subject));
                    break;
                }
                case ISSUERDN_CN: {
                    extractor = UserIdentityExtractor.getX500NameExtractor(BCStyle.CN, issuer);
                    break;
                }
                case ISSUERDN_EMAIL: {
                    extractor = UserIdentityExtractor.either(UserIdentityExtractor.getX500NameExtractor(BCStyle.EmailAddress, issuer)).or(UserIdentityExtractor.getX500NameExtractor(BCStyle.E, issuer));
                    break;
                }
                default: {
                    logger.warnf("[UserIdentityExtractorBuilder:fromConfig] Unknown or unsupported user identity source: \"%s\"", userIdentitySource.getName());
                }
            }
            return extractor;
        }
    }

    protected static class CertificateValidatorConfigBuilder {
        protected CertificateValidatorConfigBuilder() {
        }

        static CertificateValidator.CertificateValidatorBuilder fromConfig(X509AuthenticatorConfigModel config) throws Exception {
            CertificateValidator.CertificateValidatorBuilder builder = new CertificateValidator.CertificateValidatorBuilder();
            return builder.keyUsage().parse(config.getKeyUsage()).extendedKeyUsage().parse(config.getExtendedKeyUsage()).revocation().cRLEnabled(config.getCRLEnabled()).cRLDPEnabled(config.getCRLDistributionPointEnabled()).cRLrelativePath(config.getCRLRelativePath()).oCSPEnabled(config.getOCSPEnabled()).oCSPResponderURI(config.getOCSPResponder());
        }
    }
}

