/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.actiontoken.ActionTokenHandler;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;

public class ActionTokenContext<T extends JsonWebToken> {
    private final KeycloakSession session;
    private final RealmModel realm;
    private final UriInfo uriInfo;
    private final ClientConnection clientConnection;
    private final HttpRequest request;
    private EventBuilder event;
    private final ActionTokenHandler<T> handler;
    private AuthenticationSessionModel authenticationSession;
    private boolean authenticationSessionFresh;
    private String executionId;
    private final ProcessAuthenticateFlow processAuthenticateFlow;
    private final ProcessBrokerFlow processBrokerFlow;

    public ActionTokenContext(KeycloakSession session, RealmModel realm, UriInfo uriInfo, ClientConnection clientConnection, HttpRequest request, EventBuilder event, ActionTokenHandler<T> handler, String executionId, ProcessAuthenticateFlow processFlow, ProcessBrokerFlow processBrokerFlow) {
        this.session = session;
        this.realm = realm;
        this.uriInfo = uriInfo;
        this.clientConnection = clientConnection;
        this.request = request;
        this.event = event;
        this.handler = handler;
        this.executionId = executionId;
        this.processAuthenticateFlow = processFlow;
        this.processBrokerFlow = processBrokerFlow;
    }

    public EventBuilder getEvent() {
        return this.event;
    }

    public void setEvent(EventBuilder event) {
        this.event = event;
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public ClientConnection getClientConnection() {
        return this.clientConnection;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public AuthenticationSessionModel createAuthenticationSessionForClient(String clientId) throws UriBuilderException, IllegalArgumentException {
        ClientModel client = this.realm.getClientByClientId(clientId == null ? "account" : clientId);
        AuthenticationSessionModel authSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, client, true);
        authSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        authSession.setProtocol("openid-connect");
        String redirectUri = Urls.accountBase(this.uriInfo.getBaseUri()).path("/").build(new Object[]{this.realm.getName()}).toString();
        authSession.setRedirectUri(redirectUri);
        authSession.setClientNote("redirect_uri", redirectUri);
        authSession.setClientNote("response_type", "code");
        authSession.setClientNote("iss", Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
        return authSession;
    }

    public boolean isAuthenticationSessionFresh() {
        return this.authenticationSessionFresh;
    }

    public AuthenticationSessionModel getAuthenticationSession() {
        return this.authenticationSession;
    }

    public void setAuthenticationSession(AuthenticationSessionModel authenticationSession, boolean isFresh) {
        this.authenticationSession = authenticationSession;
        this.authenticationSessionFresh = isFresh;
        if (this.event != null) {
            ClientModel client = authenticationSession == null ? null : authenticationSession.getClient();
            this.event.client(client == null ? null : client.getClientId());
        }
    }

    public ActionTokenHandler<T> getHandler() {
        return this.handler;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public Response processFlow(boolean action, String flowPath, AuthenticationFlowModel flow, String errorMessage, AuthenticationProcessor processor) {
        return this.processAuthenticateFlow.processFlow(action, this.getExecutionId(), this.getAuthenticationSession(), flowPath, flow, errorMessage, processor);
    }

    public Response brokerFlow(String code, String flowPath) {
        ClientModel client = this.authenticationSession.getClient();
        return this.processBrokerFlow.brokerLoginFlow(code, this.getExecutionId(), client.getClientId(), flowPath);
    }

    @FunctionalInterface
    public static interface ProcessBrokerFlow {
        public Response brokerLoginFlow(String var1, String var2, String var3, String var4);
    }

    @FunctionalInterface
    public static interface ProcessAuthenticateFlow {
        public Response processFlow(boolean var1, String var2, AuthenticationSessionModel var3, String var4, AuthenticationFlowModel var5, String var6, AuthenticationProcessor var7);
    }
}

