/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken.idpverifyemail;

import java.util.Collections;
import javax.ws.rs.core.Response;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.actiontoken.AbstractActionTokenHander;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.TokenUtils;
import org.keycloak.authentication.actiontoken.idpverifyemail.IdpVerifyAccountLinkActionToken;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.AuthenticationSessionProvider;

public class IdpVerifyAccountLinkActionTokenHandler
extends AbstractActionTokenHander<IdpVerifyAccountLinkActionToken> {
    public IdpVerifyAccountLinkActionTokenHandler() {
        super("idp-verify-account-via-email", IdpVerifyAccountLinkActionToken.class, "staleCodeMessage", EventType.IDENTITY_PROVIDER_LINK_ACCOUNT, "invalid_token");
    }

    @Override
    public TokenVerifier.Predicate<? super IdpVerifyAccountLinkActionToken>[] getVerifiers(ActionTokenContext<IdpVerifyAccountLinkActionToken> tokenContext) {
        return TokenUtils.predicates(new TokenVerifier.Predicate[0]);
    }

    @Override
    public Response handleToken(IdpVerifyAccountLinkActionToken token, ActionTokenContext<IdpVerifyAccountLinkActionToken> tokenContext) {
        UserModel user = tokenContext.getAuthenticationSession().getAuthenticatedUser();
        EventBuilder event = tokenContext.getEvent();
        event.event(EventType.IDENTITY_PROVIDER_LINK_ACCOUNT).detail("email", user.getEmail()).detail("identity_provider", token.getIdentityProviderAlias()).detail("identity_provider_identity", token.getIdentityProviderUsername()).success();
        user.setEmailVerified(true);
        AuthenticationSessionModel authSession = tokenContext.getAuthenticationSession();
        if (tokenContext.isAuthenticationSessionFresh()) {
            AuthenticationSessionManager asm = new AuthenticationSessionManager(tokenContext.getSession());
            asm.removeAuthenticationSession(tokenContext.getRealm(), authSession, true);
            AuthenticationSessionProvider authSessProvider = tokenContext.getSession().authenticationSessions();
            authSession = authSessProvider.getAuthenticationSession(tokenContext.getRealm(), token.getAuthenticationSessionId());
            if (authSession != null) {
                authSession.setAuthNote("VERIFY_ACCOUNT_IDP_USERNAME", token.getIdentityProviderUsername());
            } else {
                authSessProvider.updateNonlocalSessionAuthNotes(token.getAuthenticationSessionId(), Collections.singletonMap("VERIFY_ACCOUNT_IDP_USERNAME", token.getIdentityProviderUsername()));
            }
            return ((LoginFormsProvider)tokenContext.getSession().getProvider(LoginFormsProvider.class)).setSuccess("identityProviderLinkSuccess", new Object[]{token.getIdentityProviderAlias(), token.getIdentityProviderUsername()}).setAttribute("skipLink", (Object)true).createInfoPage();
        }
        authSession.setAuthNote("VERIFY_ACCOUNT_IDP_USERNAME", token.getIdentityProviderUsername());
        return tokenContext.brokerFlow(null, authSession.getAuthNote("current.flow.path"));
    }
}

