/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.util.regex.Pattern;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;

public class SamlSessionUtils {
    private static final String DELIMITER = "::";
    private static final Pattern PATTERN = Pattern.compile("::");

    public static String getSessionIndex(AuthenticatedClientSessionModel clientSession) {
        UserSessionModel userSession = clientSession.getUserSession();
        ClientModel client = clientSession.getClient();
        return userSession.getId() + DELIMITER + client.getId();
    }

    public static AuthenticatedClientSessionModel getClientSession(KeycloakSession session, RealmModel realm, String sessionIndex) {
        if (sessionIndex == null) {
            return null;
        }
        String[] parts = PATTERN.split(sessionIndex);
        if (parts.length != 2) {
            return null;
        }
        UserSessionModel userSession = session.sessions().getUserSession(realm, parts[0]);
        if (userSession == null) {
            return null;
        }
        return (AuthenticatedClientSessionModel)userSession.getAuthenticatedClientSessions().get(parts[1]);
    }
}

