/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.AuthorizationProviderFactory;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.common.DefaultEvaluationContext;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.common.UserModelIdentity;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.permission.evaluator.PermissionEvaluator;
import org.keycloak.authorization.policy.evaluation.DecisionResult;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.util.Permissions;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.ClientPermissions;
import org.keycloak.services.resources.admin.permissions.GroupPermissions;
import org.keycloak.services.resources.admin.permissions.RealmPermissions;
import org.keycloak.services.resources.admin.permissions.RealmsPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.RolePermissions;
import org.keycloak.services.resources.admin.permissions.UserPermissions;

class MgmtPermissions
implements AdminPermissionEvaluator,
AdminPermissionManagement,
RealmsPermissionEvaluator {
    private static final Logger logger = Logger.getLogger(MgmtPermissions.class);
    protected RealmModel realm;
    protected KeycloakSession session;
    protected AuthorizationProvider authz;
    protected AdminAuth auth;
    protected Identity identity;
    protected UserModel admin;
    protected RealmModel adminsRealm;
    protected ResourceServer realmResourceServer;
    protected UserPermissions users;
    protected GroupPermissions groups;
    protected RealmPermissions realmPermissions;
    protected ClientPermissions clientPermissions;
    protected Scope manageScope;
    protected Scope viewScope;

    MgmtPermissions(KeycloakSession session, RealmModel realm) {
        this.session = session;
        this.realm = realm;
        KeycloakSessionFactory keycloakSessionFactory = session.getKeycloakSessionFactory();
        AuthorizationProviderFactory factory = (AuthorizationProviderFactory)keycloakSessionFactory.getProviderFactory(AuthorizationProvider.class);
        this.authz = factory.create(session, realm);
    }

    MgmtPermissions(KeycloakSession session, RealmModel realm, AdminAuth auth) {
        this(session, realm);
        this.auth = auth;
        this.admin = auth.getUser();
        this.adminsRealm = auth.getRealm();
        if (!auth.getRealm().equals(realm) && !auth.getRealm().equals(new RealmManager(session).getKeycloakAdminstrationRealm())) {
            throw new ForbiddenException();
        }
        this.identity = auth.getClient().getClientId().equals("admin-cli") || auth.getClient().getClientId().equals("security-admin-console") ? new UserModelIdentity(auth.getRealm(), auth.getUser()) : new KeycloakIdentity(auth.getToken(), session);
    }

    MgmtPermissions(KeycloakSession session, AdminAuth auth) {
        this.session = session;
        this.auth = auth;
        this.admin = auth.getUser();
        this.adminsRealm = auth.getRealm();
        this.identity = auth.getClient().getClientId().equals("admin-cli") || auth.getClient().getClientId().equals("security-admin-console") ? new UserModelIdentity(auth.getRealm(), auth.getUser()) : new KeycloakIdentity(auth.getToken(), session);
    }

    MgmtPermissions(KeycloakSession session, RealmModel realm, RealmModel adminsRealm, UserModel admin) {
        this(session, realm);
        this.admin = admin;
        this.adminsRealm = adminsRealm;
        this.identity = new UserModelIdentity(realm, admin);
    }

    public ClientModel getRealmManagementClient() {
        ClientModel client = null;
        client = this.realm.getName().equals(Config.getAdminRealm()) ? this.realm.getClientByClientId(Config.getAdminRealm() + "-realm") : this.realm.getClientByClientId("realm-management");
        return client;
    }

    @Override
    public AuthorizationProvider authz() {
        return this.authz;
    }

    @Override
    public void requireAnyAdminRole() {
        if (!this.hasAnyAdminRole()) {
            throw new ForbiddenException();
        }
    }

    public boolean hasAnyAdminRole() {
        return this.hasOneAdminRole(AdminRoles.ALL_REALM_ROLES);
    }

    public boolean hasAnyAdminRole(RealmModel realm) {
        return this.hasOneAdminRole(realm, AdminRoles.ALL_REALM_ROLES);
    }

    public boolean hasOneAdminRole(String ... adminRoles) {
        RealmModel realm = this.realm;
        return this.hasOneAdminRole(realm, adminRoles);
    }

    public boolean hasOneAdminRole(RealmModel realm, String ... adminRoles) {
        String clientId;
        RealmManager realmManager = new RealmManager(this.session);
        if (this.adminsRealm.equals(realmManager.getKeycloakAdminstrationRealm())) {
            clientId = realm.getMasterAdminClient().getClientId();
        } else if (this.adminsRealm.equals(realm)) {
            clientId = realm.getClientByClientId(realmManager.getRealmAdminClientId(realm)).getClientId();
        } else {
            return false;
        }
        for (String adminRole : adminRoles) {
            if (!this.identity.hasClientRole(clientId, adminRole)) continue;
            return true;
        }
        return false;
    }

    public boolean isAdminSameRealm() {
        return this.auth == null || this.realm.getId().equals(this.auth.getRealm().getId());
    }

    @Override
    public AdminAuth adminAuth() {
        return this.auth;
    }

    public Identity identity() {
        return this.identity;
    }

    public UserModel admin() {
        return this.admin;
    }

    @Override
    public RolePermissions roles() {
        return new RolePermissions(this.session, this.realm, this.authz, this);
    }

    @Override
    public UserPermissions users() {
        if (this.users != null) {
            return this.users;
        }
        this.users = new UserPermissions(this.session, this.realm, this.authz, this);
        return this.users;
    }

    @Override
    public RealmPermissions realm() {
        if (this.realmPermissions != null) {
            return this.realmPermissions;
        }
        this.realmPermissions = new RealmPermissions(this.session, this.realm, this.authz, this);
        return this.realmPermissions;
    }

    @Override
    public ClientPermissions clients() {
        if (this.clientPermissions != null) {
            return this.clientPermissions;
        }
        this.clientPermissions = new ClientPermissions(this.session, this.realm, this.authz, this);
        return this.clientPermissions;
    }

    @Override
    public GroupPermissions groups() {
        if (this.groups != null) {
            return this.groups;
        }
        this.groups = new GroupPermissions(this.session, this.realm, this.authz, this);
        return this.groups;
    }

    public ResourceServer findOrCreateResourceServer(ClientModel client) {
        return this.initializeRealmResourceServer();
    }

    public ResourceServer resourceServer(ClientModel client) {
        return this.realmResourceServer();
    }

    @Override
    public ResourceServer realmResourceServer() {
        if (this.realmResourceServer != null) {
            return this.realmResourceServer;
        }
        ResourceServerStore resourceServerStore = this.authz.getStoreFactory().getResourceServerStore();
        ClientModel client = this.getRealmManagementClient();
        if (client == null) {
            return null;
        }
        this.realmResourceServer = this.authz.getStoreFactory().getResourceServerStore().findByClient(client.getId());
        return this.realmResourceServer;
    }

    public ResourceServer initializeRealmResourceServer() {
        if (this.realmResourceServer != null) {
            return this.realmResourceServer;
        }
        ClientModel client = this.getRealmManagementClient();
        this.realmResourceServer = this.authz.getStoreFactory().getResourceServerStore().findByClient(client.getId());
        if (this.realmResourceServer == null) {
            this.realmResourceServer = this.authz.getStoreFactory().getResourceServerStore().create(client.getId());
        }
        return this.realmResourceServer;
    }

    public void initializeRealmDefaultScopes() {
        ResourceServer server = this.initializeRealmResourceServer();
        this.manageScope = this.initializeRealmScope("manage");
        this.viewScope = this.initializeRealmScope("view");
    }

    public Scope initializeRealmScope(String name) {
        ResourceServer server = this.initializeRealmResourceServer();
        Scope scope = this.authz.getStoreFactory().getScopeStore().findByName(name, server.getId());
        if (scope == null) {
            scope = this.authz.getStoreFactory().getScopeStore().create(name, server);
        }
        return scope;
    }

    public Scope realmManageScope() {
        if (this.manageScope != null) {
            return this.manageScope;
        }
        this.manageScope = this.realmScope("manage");
        return this.manageScope;
    }

    public Scope realmViewScope() {
        if (this.viewScope != null) {
            return this.viewScope;
        }
        this.viewScope = this.realmScope("view");
        return this.viewScope;
    }

    public Scope realmScope(String scope) {
        ResourceServer server = this.realmResourceServer();
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getScopeStore().findByName(scope, server.getId());
    }

    public boolean evaluatePermission(Resource resource, Scope scope, ResourceServer resourceServer) {
        Identity identity = this.identity();
        if (identity == null) {
            throw new RuntimeException("Identity of admin is not set for permission query");
        }
        return this.evaluatePermission(resource, scope, resourceServer, identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluatePermission(Resource resource, Scope scope, ResourceServer resourceServer, Identity identity) {
        RealmModel oldRealm = this.session.getContext().getRealm();
        try {
            this.session.getContext().setRealm(this.realm);
            DefaultEvaluationContext context = new DefaultEvaluationContext(identity, this.session);
            DecisionResult decisionCollector = new DecisionResult();
            List<ResourcePermission> permissions = Permissions.permission(resourceServer, resource, scope);
            PermissionEvaluator from = this.authz.evaluators().from(permissions, (EvaluationContext)context);
            from.evaluate((Decision)decisionCollector);
            if (!decisionCollector.completed()) {
                logger.error((Object)"Failed to run permission check", decisionCollector.getError());
                boolean bl = false;
                return bl;
            }
            boolean bl = ((Result)decisionCollector.getResults().get(0)).getEffect() == Decision.Effect.PERMIT;
            return bl;
        }
        finally {
            this.session.getContext().setRealm(oldRealm);
        }
    }

    @Override
    public boolean canView(RealmModel realm) {
        return this.hasOneAdminRole(realm, AdminRoles.VIEW_REALM, AdminRoles.MANAGE_REALM);
    }

    @Override
    public boolean isAdmin(RealmModel realm) {
        return this.hasAnyAdminRole(realm);
    }

    @Override
    public boolean isAdmin() {
        RealmManager realmManager = new RealmManager(this.session);
        if (this.adminsRealm.equals(realmManager.getKeycloakAdminstrationRealm())) {
            if (this.identity.hasRealmRole(AdminRoles.ADMIN) || this.identity.hasRealmRole(AdminRoles.CREATE_REALM)) {
                return true;
            }
            for (RealmModel realm : this.session.realms().getRealms()) {
                if (!this.isAdmin(realm)) continue;
                return true;
            }
            return false;
        }
        return this.isAdmin(this.adminsRealm);
    }

    @Override
    public boolean canCreateRealm() {
        RealmManager realmManager = new RealmManager(this.session);
        if (!this.auth.getRealm().equals(realmManager.getKeycloakAdminstrationRealm())) {
            return false;
        }
        return this.identity.hasRealmRole(AdminRoles.CREATE_REALM);
    }

    @Override
    public void requireCreateRealm() {
        if (!this.canCreateRealm()) {
            throw new ForbiddenException();
        }
    }
}

