/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.scripting;

import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.keycloak.models.ScriptModel;
import org.keycloak.scripting.AbstractEvaluatableScriptAdapter;
import org.keycloak.scripting.CompiledEvaluatableScriptAdapter;
import org.keycloak.scripting.InvocableScriptAdapter;
import org.keycloak.scripting.Script;
import org.keycloak.scripting.ScriptBindingsConfigurer;
import org.keycloak.scripting.ScriptExecutionException;
import org.keycloak.scripting.ScriptingProvider;
import org.keycloak.scripting.UncompiledEvaluatableScriptAdapter;

public class DefaultScriptingProvider
implements ScriptingProvider {
    private final ScriptEngineManager scriptEngineManager;

    DefaultScriptingProvider(ScriptEngineManager scriptEngineManager) {
        if (scriptEngineManager == null) {
            throw new IllegalStateException("scriptEngineManager must not be null!");
        }
        this.scriptEngineManager = scriptEngineManager;
    }

    public InvocableScriptAdapter prepareInvocableScript(ScriptModel scriptModel, ScriptBindingsConfigurer bindingsConfigurer) {
        AbstractEvaluatableScriptAdapter evaluatable = this.prepareEvaluatableScript(scriptModel);
        return evaluatable.prepareInvokableScript(bindingsConfigurer);
    }

    public AbstractEvaluatableScriptAdapter prepareEvaluatableScript(ScriptModel scriptModel) {
        if (scriptModel == null) {
            throw new IllegalArgumentException("script must not be null");
        }
        if (scriptModel.getCode() == null || scriptModel.getCode().trim().isEmpty()) {
            throw new IllegalArgumentException("script must not be null or empty");
        }
        ScriptEngine engine = this.createPreparedScriptEngine(scriptModel);
        if (engine instanceof Compilable) {
            try {
                CompiledScript compiledScript = ((Compilable)((Object)engine)).compile(scriptModel.getCode());
                return new CompiledEvaluatableScriptAdapter(scriptModel, compiledScript);
            }
            catch (ScriptException e) {
                throw new ScriptExecutionException(scriptModel, (Exception)e);
            }
        }
        return new UncompiledEvaluatableScriptAdapter(scriptModel, engine);
    }

    public ScriptModel createScript(String realmId, String mimeType, String scriptName, String scriptCode, String scriptDescription) {
        return new Script(null, realmId, scriptName, mimeType, scriptCode, scriptDescription);
    }

    public void close() {
    }

    private ScriptEngine createPreparedScriptEngine(ScriptModel script) {
        ScriptEngine scriptEngine = this.lookupScriptEngineFor(script);
        if (scriptEngine == null) {
            throw new IllegalStateException("Could not find ScriptEngine for script: " + script);
        }
        return scriptEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptEngine lookupScriptEngineFor(ScriptModel script) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(DefaultScriptingProvider.class.getClassLoader());
            ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByMimeType(script.getMimeType());
            return scriptEngine;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

