/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken.verifyemail;

import java.util.Objects;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.actiontoken.AbstractActionTokenHander;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.TokenUtils;
import org.keycloak.authentication.actiontoken.verifyemail.VerifyEmailActionToken;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.sessions.AuthenticationSessionModel;

public class VerifyEmailActionTokenHandler
extends AbstractActionTokenHander<VerifyEmailActionToken> {
    public VerifyEmailActionTokenHandler() {
        super("verify-email", VerifyEmailActionToken.class, "staleEmailVerificationLink", EventType.VERIFY_EMAIL, "invalid_token");
    }

    @Override
    public TokenVerifier.Predicate<? super VerifyEmailActionToken>[] getVerifiers(ActionTokenContext<VerifyEmailActionToken> tokenContext) {
        return TokenUtils.predicates(TokenUtils.checkThat(t -> Objects.equals(t.getEmail(), tokenContext.getAuthenticationSession().getAuthenticatedUser().getEmail()), "invalid_email", this.getDefaultErrorMessage()));
    }

    @Override
    public Response handleToken(VerifyEmailActionToken token, ActionTokenContext<VerifyEmailActionToken> tokenContext) {
        UserModel user = tokenContext.getAuthenticationSession().getAuthenticatedUser();
        EventBuilder event = tokenContext.getEvent();
        event.event(EventType.VERIFY_EMAIL).detail("email", user.getEmail());
        AuthenticationSessionModel authSession = tokenContext.getAuthenticationSession();
        UriInfo uriInfo = tokenContext.getUriInfo();
        RealmModel realm = tokenContext.getRealm();
        KeycloakSession session = tokenContext.getSession();
        if (tokenContext.isAuthenticationSessionFresh()) {
            token.setOriginalAuthenticationSessionId(token.getAuthenticationSessionId());
            token.setAuthenticationSessionId(authSession.getId());
            UriBuilder builder = Urls.actionTokenBuilder(uriInfo.getBaseUri(), token.serialize(session, realm, uriInfo));
            String confirmUri = builder.build(new Object[]{realm.getName()}).toString();
            return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setSuccess("confirmEmailAddressVerification", new Object[]{user.getEmail()}).setAttribute("actionUri", (Object)confirmUri).createInfoPage();
        }
        user.setEmailVerified(true);
        user.removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
        authSession.removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
        event.success();
        if (token.getOriginalAuthenticationSessionId() != null) {
            AuthenticationSessionManager asm = new AuthenticationSessionManager(tokenContext.getSession());
            asm.removeAuthenticationSession(tokenContext.getRealm(), authSession, true);
            return ((LoginFormsProvider)tokenContext.getSession().getProvider(LoginFormsProvider.class)).setSuccess("emailVerifiedMessage", new Object[0]).createInfoPage();
        }
        tokenContext.setEvent(event.clone().removeDetail("email").event(EventType.LOGIN));
        String nextAction = AuthenticationManager.nextRequiredAction(session, authSession, tokenContext.getClientConnection(), tokenContext.getRequest(), uriInfo, event);
        return AuthenticationManager.redirectToRequiredActions(session, realm, authSession, uriInfo, nextAction);
    }
}

