/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.docker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.keycloak.common.Profile;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.AbstractLoginProtocolFactory;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.docker.DockerAuthV2Protocol;
import org.keycloak.protocol.docker.DockerV2LoginProtocolService;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientTemplateRepresentation;

public class DockerAuthV2ProtocolFactory
extends AbstractLoginProtocolFactory
implements EnvironmentDependentProviderFactory {
    static List<ProtocolMapperModel> builtins = new ArrayList<ProtocolMapperModel>();
    static List<ProtocolMapperModel> defaultBuiltins = new ArrayList<ProtocolMapperModel>();

    protected void addDefaults(ClientModel client) {
        defaultBuiltins.forEach(builtinMapper -> client.addProtocolMapper(builtinMapper));
    }

    public List<ProtocolMapperModel> getBuiltinMappers() {
        return builtins;
    }

    public List<ProtocolMapperModel> getDefaultBuiltinMappers() {
        return defaultBuiltins;
    }

    public Object createProtocolEndpoint(RealmModel realm, EventBuilder event) {
        return new DockerV2LoginProtocolService(realm, event);
    }

    public void setupClientDefaults(ClientRepresentation rep, ClientModel newClient) {
    }

    public void setupTemplateDefaults(ClientTemplateRepresentation clientRep, ClientTemplateModel newClient) {
    }

    public LoginProtocol create(KeycloakSession session) {
        return new DockerAuthV2Protocol().setSession(session);
    }

    public String getId() {
        return "docker-v2";
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DOCKER);
    }

    public int order() {
        return -100;
    }

    static {
        ProtocolMapperModel addAllRequestedScopeMapper = new ProtocolMapperModel();
        addAllRequestedScopeMapper.setName("docker-v2-allow-all-mapper");
        addAllRequestedScopeMapper.setProtocolMapper("docker-v2-allow-all-mapper");
        addAllRequestedScopeMapper.setProtocol("docker-v2");
        addAllRequestedScopeMapper.setConsentRequired(false);
        addAllRequestedScopeMapper.setConfig(Collections.EMPTY_MAP);
        builtins.add(addAllRequestedScopeMapper);
        defaultBuiltins.add(addAllRequestedScopeMapper);
    }
}

