/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.Config;
import org.keycloak.common.util.SystemEnvProperties;
import org.keycloak.exportimport.ExportImportManager;
import org.keycloak.migration.MigrationModelManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.dblock.DBLockManager;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.DefaultKeycloakSessionFactory;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.filters.KeycloakTransactionCommitter;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.UserStorageSyncManager;
import org.keycloak.services.resources.JsResource;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.RobotsResource;
import org.keycloak.services.resources.ServerVersionResource;
import org.keycloak.services.resources.ThemeResource;
import org.keycloak.services.resources.WelcomeResource;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.scheduled.ClearExpiredClientInitialAccessTokens;
import org.keycloak.services.scheduled.ClearExpiredEvents;
import org.keycloak.services.scheduled.ClearExpiredUserSessions;
import org.keycloak.services.scheduled.ClusterAwareScheduledTaskRunner;
import org.keycloak.services.scheduled.ScheduledTaskRunner;
import org.keycloak.services.util.JsonConfigProvider;
import org.keycloak.services.util.ObjectMapperResolver;
import org.keycloak.timer.TimerProvider;
import org.keycloak.transaction.JtaTransactionManagerLookup;
import org.keycloak.util.JsonSerialization;

public class KeycloakApplication
extends Application {
    public static final String KEYCLOAK_CONFIG_PARAM_NAME = "org.keycloak.server-subsystem.Config";
    public static final String KEYCLOAK_EMBEDDED = "keycloak.embedded";
    public static final String SERVER_CONTEXT_CONFIG_PROPERTY_OVERRIDES = "keycloak.server.context.config.property-overrides";
    private static final Logger logger = Logger.getLogger(KeycloakApplication.class);
    protected boolean embedded = false;
    protected Set<Object> singletons = new HashSet<Object>();
    protected Set<Class<?>> classes = new HashSet();
    protected KeycloakSessionFactory sessionFactory;
    protected String contextPath;

    public KeycloakApplication(@Context ServletContext context, @Context Dispatcher dispatcher) {
        try {
            if ("true".equals(context.getInitParameter(KEYCLOAK_EMBEDDED))) {
                this.embedded = true;
            }
            KeycloakApplication.loadConfig(context);
            this.contextPath = context.getContextPath();
            this.sessionFactory = KeycloakApplication.createSessionFactory();
            dispatcher.getDefaultContextObjects().put(KeycloakApplication.class, this);
            ResteasyProviderFactory.pushContext(KeycloakApplication.class, (Object)((Object)this));
            context.setAttribute(KeycloakSessionFactory.class.getName(), (Object)this.sessionFactory);
            this.singletons.add(new ServerVersionResource());
            this.singletons.add(new RobotsResource());
            this.singletons.add(new RealmsResource());
            this.singletons.add(new AdminRoot());
            this.classes.add(ThemeResource.class);
            this.classes.add(JsResource.class);
            this.classes.add(KeycloakTransactionCommitter.class);
            this.singletons.add(new ObjectMapperResolver(Boolean.parseBoolean(System.getProperty("keycloak.jsonPrettyPrint", "false"))));
            final ExportImportManager[] exportImportManager = new ExportImportManager[1];
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(KeycloakSession lockSession) {
                    DBLockManager dbLockManager = new DBLockManager(lockSession);
                    dbLockManager.checkForcedUnlock();
                    DBLockProvider dbLock = dbLockManager.getDBLock();
                    dbLock.waitForLock();
                    try {
                        exportImportManager[0] = KeycloakApplication.this.migrateAndBootstrap();
                    }
                    finally {
                        dbLock.releaseLock();
                    }
                }
            });
            if (exportImportManager[0].isRunExport()) {
                exportImportManager[0].runExport();
            }
            final AtomicBoolean bootstrapAdminUser = new AtomicBoolean(false);
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                public void run(KeycloakSession session) {
                    boolean shouldBootstrapAdmin = new ApplianceBootstrap(session).isNoMasterUser();
                    bootstrapAdminUser.set(shouldBootstrapAdmin);
                    KeycloakApplication.this.sessionFactory.publish((ProviderEvent)new PostMigrationEvent(session));
                }
            });
            this.singletons.add(new WelcomeResource(bootstrapAdminUser.get()));
            KeycloakApplication.setupScheduledTasks(this.sessionFactory);
        }
        catch (Throwable t) {
            if (!this.embedded) {
                this.exit(1);
            }
            throw t;
        }
    }

    protected ExportImportManager migrateAndBootstrap() {
        ExportImportManager exportImportManager;
        logger.debug((Object)"Calling migrateModel");
        this.migrateModel();
        logger.debug((Object)"bootstrap");
        try (KeycloakSession session = this.sessionFactory.create();){
            session.getTransactionManager().begin();
            JtaTransactionManagerLookup lookup = (JtaTransactionManagerLookup)this.sessionFactory.getProviderFactory(JtaTransactionManagerLookup.class);
            if (lookup != null && lookup.getTransactionManager() != null) {
                try {
                    Transaction transaction = lookup.getTransactionManager().getTransaction();
                    logger.debugv("bootstrap current transaction? {0}", (Object)(transaction != null ? 1 : 0));
                    if (transaction != null) {
                        logger.debugv("bootstrap current transaction status? {0}", (Object)transaction.getStatus());
                    }
                }
                catch (SystemException e) {
                    throw new RuntimeException(e);
                }
            }
            ApplianceBootstrap applianceBootstrap = new ApplianceBootstrap(session);
            exportImportManager = new ExportImportManager(session);
            boolean createMasterRealm = applianceBootstrap.isNewInstall();
            if (exportImportManager.isRunImport() && exportImportManager.isImportMasterIncluded()) {
                createMasterRealm = false;
            }
            if (createMasterRealm) {
                applianceBootstrap.createMasterRealm(this.contextPath);
            }
            session.getTransactionManager().commit();
        }
        if (exportImportManager.isRunImport()) {
            exportImportManager.runImport();
        } else {
            this.importRealms();
        }
        this.importAddUser();
        return exportImportManager;
    }

    protected void migrateModel() {
        try (KeycloakSession session = this.sessionFactory.create();){
            session.getTransactionManager().begin();
            MigrationModelManager.migrate((KeycloakSession)session);
            session.getTransactionManager().commit();
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public URI getBaseUri(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().replacePath(this.getContextPath()).build(new Object[0]);
    }

    public static void loadConfig(ServletContext context) {
        try {
            HashMap propertyOverridesMap;
            URL resource;
            File f;
            JsonNode node = null;
            String dmrConfig = KeycloakApplication.loadDmrConfig(context);
            if (dmrConfig != null) {
                node = new ObjectMapper().readTree(dmrConfig);
                ServicesLogger.LOGGER.loadingFrom("standalone.xml or domain.xml");
            }
            String configDir = System.getProperty("jboss.server.config.dir");
            if (node == null && configDir != null && (f = new File(configDir + File.separator + "keycloak-server.json")).isFile()) {
                ServicesLogger.LOGGER.loadingFrom(f.getAbsolutePath());
                node = new ObjectMapper().readTree(f);
            }
            if (node == null && (resource = Thread.currentThread().getContextClassLoader().getResource("META-INF/keycloak-server.json")) != null) {
                ServicesLogger.LOGGER.loadingFrom(resource);
                node = new ObjectMapper().readTree(resource);
            }
            if (node != null) {
                propertyOverridesMap = new HashMap();
                String propertyOverrides = context.getInitParameter(SERVER_CONTEXT_CONFIG_PROPERTY_OVERRIDES);
                if (context.getInitParameter(SERVER_CONTEXT_CONFIG_PROPERTY_OVERRIDES) != null) {
                    JsonNode jsonObj = new ObjectMapper().readTree(propertyOverrides);
                    jsonObj.fields().forEachRemaining(e -> propertyOverridesMap.put(e.getKey(), ((JsonNode)e.getValue()).asText()));
                }
            } else {
                throw new RuntimeException("Keycloak config not found.");
            }
            SystemEnvProperties properties = new SystemEnvProperties(propertyOverridesMap);
            Config.init((Config.ConfigProvider)new JsonConfigProvider(node, (Properties)properties));
        }
        catch (IOException e2) {
            throw new RuntimeException("Failed to load config", e2);
        }
    }

    private static String loadDmrConfig(ServletContext context) {
        String dmrConfig = context.getInitParameter(KEYCLOAK_CONFIG_PARAM_NAME);
        if (dmrConfig == null) {
            return null;
        }
        ModelNode dmrConfigNode = ModelNode.fromString((String)dmrConfig);
        if (dmrConfigNode.asPropertyList().isEmpty()) {
            return null;
        }
        return dmrConfigNode.resolve().toJSONString(true);
    }

    public static KeycloakSessionFactory createSessionFactory() {
        DefaultKeycloakSessionFactory factory = new DefaultKeycloakSessionFactory();
        factory.init();
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupScheduledTasks(KeycloakSessionFactory sessionFactory) {
        long interval = Config.scope((String[])new String[]{"scheduled"}).getLong("interval", Long.valueOf(60L)) * 1000L;
        try (KeycloakSession session = sessionFactory.create();){
            TimerProvider timer = (TimerProvider)session.getProvider(TimerProvider.class);
            timer.schedule((Runnable)new ClusterAwareScheduledTaskRunner(sessionFactory, new ClearExpiredEvents(), interval), interval, "ClearExpiredEvents");
            timer.schedule((Runnable)new ClusterAwareScheduledTaskRunner(sessionFactory, new ClearExpiredClientInitialAccessTokens(), interval), interval, "ClearExpiredClientInitialAccessTokens");
            timer.schedule((Runnable)new ScheduledTaskRunner(sessionFactory, new ClearExpiredUserSessions()), interval, "ClearExpiredUserSessions");
            new UserStorageSyncManager().bootstrapPeriodic(sessionFactory, timer);
        }
    }

    public KeycloakSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public void importRealms() {
        String files = System.getProperty("keycloak.import");
        if (files != null) {
            StringTokenizer tokenizer = new StringTokenizer(files, ",");
            while (tokenizer.hasMoreTokens()) {
                RealmRepresentation rep;
                String file = tokenizer.nextToken().trim();
                try {
                    rep = KeycloakApplication.loadJson(new FileInputStream(file), RealmRepresentation.class);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.importRealm(rep, "file " + file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importRealm(RealmRepresentation rep, String from) {
        boolean exists = false;
        try (KeycloakSession session = this.sessionFactory.create();){
            session.getTransactionManager().begin();
            try {
                RealmManager manager = new RealmManager(session);
                manager.setContextPath(this.getContextPath());
                if (rep.getId() != null && manager.getRealm(rep.getId()) != null) {
                    ServicesLogger.LOGGER.realmExists(rep.getRealm(), from);
                    exists = true;
                }
                if (manager.getRealmByName(rep.getRealm()) != null) {
                    ServicesLogger.LOGGER.realmExists(rep.getRealm(), from);
                    exists = true;
                }
                if (!exists) {
                    RealmModel realm = manager.importRealm(rep);
                    ServicesLogger.LOGGER.importedRealm(realm.getName(), from);
                }
                session.getTransactionManager().commit();
            }
            catch (Throwable t) {
                session.getTransactionManager().rollback();
                if (!exists) {
                    ServicesLogger.LOGGER.unableToImportRealm(t, rep.getRealm(), from);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importAddUser() {
        File addUserFile;
        String configDir = System.getProperty("jboss.server.config.dir");
        if (configDir != null && (addUserFile = new File(configDir + File.separator + "keycloak-add-user.json")).isFile()) {
            List realms;
            ServicesLogger.LOGGER.imprtingUsersFrom(addUserFile);
            try {
                realms = (List)JsonSerialization.readValue((InputStream)new FileInputStream(addUserFile), (TypeReference)new TypeReference<List<RealmRepresentation>>(){});
            }
            catch (IOException e) {
                ServicesLogger.LOGGER.failedToLoadUsers(e);
                return;
            }
            for (RealmRepresentation realmRep : realms) {
                for (UserRepresentation userRep : realmRep.getUsers()) {
                    try (KeycloakSession session = this.sessionFactory.create();){
                        session.getTransactionManager().begin();
                        RealmModel realm = session.realms().getRealmByName(realmRep.getRealm());
                        if (realm == null) {
                            ServicesLogger.LOGGER.addUserFailedRealmNotFound(userRep.getUsername(), realmRep.getRealm());
                        } else {
                            UserModel user = session.users().addUser(realm, userRep.getUsername());
                            user.setEnabled(userRep.isEnabled().booleanValue());
                            RepresentationToModel.createCredentials((UserRepresentation)userRep, (KeycloakSession)session, (RealmModel)realm, (UserModel)user);
                            RepresentationToModel.createRoleMappings((UserRepresentation)userRep, (UserModel)user, (RealmModel)realm);
                        }
                        session.getTransactionManager().commit();
                        ServicesLogger.LOGGER.addUserSuccess(userRep.getUsername(), realmRep.getRealm());
                    }
                }
            }
            if (!addUserFile.delete()) {
                ServicesLogger.LOGGER.failedToDeleteFile(addUserFile.getAbsolutePath());
            }
        }
    }

    private static <T> T loadJson(InputStream is, Class<T> type) {
        try {
            return (T)JsonSerialization.readValue((InputStream)is, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse json", e);
        }
    }

    private void exit(final int status) {
        new Thread(){

            @Override
            public void run() {
                System.exit(status);
            }
        }.start();
    }
}

