/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.facebook;

import com.fasterxml.jackson.databind.JsonNode;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.models.KeycloakSession;

public class FacebookIdentityProvider
extends AbstractOAuth2IdentityProvider
implements SocialIdentityProvider {
    public static final String AUTH_URL = "https://graph.facebook.com/oauth/authorize";
    public static final String TOKEN_URL = "https://graph.facebook.com/oauth/access_token";
    public static final String PROFILE_URL = "https://graph.facebook.com/me?fields=id,name,email,first_name,last_name";
    public static final String DEFAULT_SCOPE = "email";

    public FacebookIdentityProvider(KeycloakSession session, OAuth2IdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(PROFILE_URL);
    }

    @Override
    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        try {
            JsonNode profile = SimpleHttp.doGet((String)PROFILE_URL, (KeycloakSession)this.session).header("Authorization", "Bearer " + accessToken).asJson();
            String id = this.getJsonProperty(profile, "id");
            BrokeredIdentityContext user = new BrokeredIdentityContext(id);
            String email = this.getJsonProperty(profile, DEFAULT_SCOPE);
            user.setEmail(email);
            String username = this.getJsonProperty(profile, "username");
            if (username == null) {
                username = email != null ? email : id;
            }
            user.setUsername(username);
            String firstName = this.getJsonProperty(profile, "first_name");
            String lastName = this.getJsonProperty(profile, "last_name");
            lastName = lastName == null ? "" : " " + lastName;
            user.setName(firstName + lastName);
            user.setIdpConfig(this.getConfig());
            user.setIdp((IdentityProvider)this);
            AbstractJsonUserAttributeMapper.storeUserProfileForMapper(user, profile, this.getConfig().getAlias());
            return user;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from facebook.", (Throwable)e);
        }
    }

    @Override
    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }
}

