/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.account.AccountConsole;
import org.keycloak.services.resources.account.AccountFormService;
import org.keycloak.services.resources.account.AccountRestService;
import org.keycloak.services.resources.account.CorsPreflightService;
import org.keycloak.theme.Theme;
import org.keycloak.theme.ThemeProvider;

public class AccountLoader {
    private static final Logger logger = Logger.getLogger(AccountLoader.class);

    public Object getAccountService(KeycloakSession session, EventBuilder event) {
        RealmModel realm = session.getContext().getRealm();
        ClientModel client = realm.getClientByClientId("account");
        if (client == null || !client.isEnabled()) {
            logger.debug((Object)"account management not enabled");
            throw new NotFoundException("account management not enabled");
        }
        HttpRequest request = (HttpRequest)session.getContext().getContextObject(HttpRequest.class);
        HttpHeaders headers = session.getContext().getRequestHeaders();
        MediaType content = headers.getMediaType();
        List accepts = headers.getAcceptableMediaTypes();
        Theme theme = this.getTheme(session);
        boolean deprecatedAccount = this.isDeprecatedFormsAccountConsole(theme);
        if (request.getHttpMethod().equals("OPTIONS")) {
            return new CorsPreflightService(request);
        }
        if ((accepts.contains(MediaType.APPLICATION_JSON_TYPE) || MediaType.APPLICATION_JSON_TYPE.equals((Object)content)) && !request.getUri().getPath().endsWith("keycloak.json")) {
            AuthenticationManager.AuthResult authResult = new AppAuthManager().authenticateBearerToken(session);
            if (authResult == null) {
                throw new NotAuthorizedException((Object)"Bearer token required", new Object[0]);
            }
            Auth auth = new Auth(session.getContext().getRealm(), authResult.getToken(), authResult.getUser(), client, authResult.getSession(), false);
            AccountRestService accountRestService = new AccountRestService(session, auth, client, event);
            ResteasyProviderFactory.getInstance().injectProperties((Object)accountRestService);
            accountRestService.init();
            return accountRestService;
        }
        if (deprecatedAccount) {
            AccountFormService accountFormService = new AccountFormService(realm, client, event);
            ResteasyProviderFactory.getInstance().injectProperties((Object)accountFormService);
            accountFormService.init();
            return accountFormService;
        }
        AccountConsole console = new AccountConsole(realm, client, theme);
        ResteasyProviderFactory.getInstance().injectProperties((Object)console);
        console.init();
        return console;
    }

    private Theme getTheme(KeycloakSession session) {
        try {
            ThemeProvider themeProvider = (ThemeProvider)session.getProvider(ThemeProvider.class, "extending");
            return themeProvider.getTheme(session.getContext().getRealm().getAccountTheme(), Theme.Type.ACCOUNT);
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    private boolean isDeprecatedFormsAccountConsole(Theme theme) {
        try {
            return Boolean.parseBoolean(theme.getProperties().getProperty("deprecatedMode", "true"));
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }
}

