/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.keycloak.authorization.common.DefaultEvaluationContext;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.AccessToken;

public class KeycloakEvaluationContext
extends DefaultEvaluationContext {
    private final KeycloakIdentity identity;

    public KeycloakEvaluationContext(KeycloakSession keycloakSession) {
        this(new KeycloakIdentity(keycloakSession), keycloakSession);
    }

    public KeycloakEvaluationContext(KeycloakIdentity identity, KeycloakSession keycloakSession) {
        super(identity, keycloakSession);
        this.identity = identity;
    }

    @Override
    public Identity getIdentity() {
        return this.identity;
    }

    @Override
    public Map<String, Collection<String>> getBaseAttributes() {
        Map<String, Collection<String>> attributes = super.getBaseAttributes();
        AccessToken accessToken = this.identity.getAccessToken();
        if (accessToken != null) {
            attributes.put("kc.client.id", Arrays.asList(accessToken.getIssuedFor()));
        }
        return attributes;
    }
}

