/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc;

import java.io.IOException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.broker.oidc.OIDCIdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.events.EventBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.adapters.action.AdminAction;
import org.keycloak.representations.adapters.action.LogoutAction;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.util.JsonSerialization;

public class KeycloakOIDCIdentityProvider
extends OIDCIdentityProvider {
    public static final String VALIDATED_ACCESS_TOKEN = "VALIDATED_ACCESS_TOKEN";

    public KeycloakOIDCIdentityProvider(KeycloakSession session, OIDCIdentityProviderConfig config) {
        super(session, config);
    }

    @Override
    public Object callback(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
        return new KeycloakEndpoint(callback, realm, event);
    }

    @Override
    protected void processAccessTokenResponse(BrokeredIdentityContext context, AccessTokenResponse response) {
        JsonWebToken access = this.validateToken(response.getToken());
        context.getContextData().put(VALIDATED_ACCESS_TOKEN, access);
    }

    @Override
    protected BrokeredIdentityContext exchangeExternalImpl(EventBuilder event, MultivaluedMap<String, String> params) {
        String subjectToken = (String)params.getFirst((Object)"subject_token");
        if (subjectToken == null) {
            event.detail("reason", "subject_token param unset");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "token not set", Response.Status.BAD_REQUEST);
        }
        String subjectTokenType = (String)params.getFirst((Object)"subject_token_type");
        if (subjectTokenType == null) {
            subjectTokenType = "urn:ietf:params:oauth:token-type:access_token";
        }
        return this.validateJwt(event, subjectToken, subjectTokenType);
    }

    protected class KeycloakEndpoint
    extends OIDCIdentityProvider.OIDCEndpoint {
        public KeycloakEndpoint(IdentityProvider.AuthenticationCallback callback, RealmModel realm, EventBuilder event) {
            super(KeycloakOIDCIdentityProvider.this, callback, realm, event);
        }

        @POST
        @Path(value="k_logout")
        public Response backchannelLogout(String input) {
            JWSInput token = null;
            try {
                token = new JWSInput(input);
            }
            catch (JWSInputException e) {
                OIDCIdentityProvider.logger.warn((Object)"Failed to verify logout request");
                return Response.status((int)400).build();
            }
            if (!KeycloakOIDCIdentityProvider.this.verify(token)) {
                OIDCIdentityProvider.logger.warn((Object)"Failed to verify logout request");
                return Response.status((int)400).build();
            }
            LogoutAction action = null;
            try {
                action = (LogoutAction)JsonSerialization.readValue((byte[])token.getContent(), LogoutAction.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!this.validateAction((AdminAction)action)) {
                return Response.status((int)400).build();
            }
            if (action.getKeycloakSessionIds() != null) {
                for (String sessionId : action.getKeycloakSessionIds()) {
                    String brokerSessionId = ((OIDCIdentityProviderConfig)KeycloakOIDCIdentityProvider.this.getConfig()).getAlias() + "." + sessionId;
                    UserSessionModel userSession = this.session.sessions().getUserSessionByBrokerSessionId(this.realm, brokerSessionId);
                    if (userSession == null || userSession.getState() == UserSessionModel.State.LOGGING_OUT || userSession.getState() == UserSessionModel.State.LOGGED_OUT) continue;
                    AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, this.uriInfo, this.clientConnection, this.headers, false);
                }
            }
            return Response.ok().build();
        }

        protected boolean validateAction(AdminAction action) {
            if (!action.validate()) {
                OIDCIdentityProvider.logger.warn((Object)("admin request failed, not validated" + action.getAction()));
                return false;
            }
            if (action.isExpired()) {
                OIDCIdentityProvider.logger.warn((Object)"admin request failed, expired token");
                return false;
            }
            if (!((OIDCIdentityProviderConfig)KeycloakOIDCIdentityProvider.this.getConfig()).getClientId().equals(action.getResource())) {
                OIDCIdentityProvider.logger.warn((Object)"Resource name does not match");
                return false;
            }
            return true;
        }

        @Override
        public SimpleHttp generateTokenRequest(String authorizationCode) {
            return super.generateTokenRequest(authorizationCode).param("client_session_state", "n/a");
        }
    }
}

