/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AuthenticationManager;

public class AppAuthManager
extends AuthenticationManager {
    @Override
    public AuthenticationManager.AuthResult authenticateIdentityCookie(KeycloakSession session, RealmModel realm) {
        AuthenticationManager.AuthResult authResult = super.authenticateIdentityCookie(session, realm);
        if (authResult == null) {
            return null;
        }
        AppAuthManager.createLoginCookie(session, realm, authResult.getUser(), authResult.getSession(), session.getContext().getUri(), session.getContext().getConnection());
        if (authResult.getSession().isRememberMe()) {
            AppAuthManager.createRememberMeCookie(realm, authResult.getUser().getUsername(), session.getContext().getUri(), session.getContext().getConnection());
        }
        return authResult;
    }

    public String extractAuthorizationHeaderToken(HttpHeaders headers) {
        String tokenString = null;
        String authHeader = (String)headers.getRequestHeaders().getFirst((Object)"Authorization");
        if (authHeader != null) {
            String[] split = authHeader.trim().split("\\s+");
            if (split == null || split.length != 2) {
                throw new UnauthorizedException("Bearer");
            }
            if (!split[0].equalsIgnoreCase("Bearer")) {
                throw new UnauthorizedException("Bearer");
            }
            tokenString = split[1];
        }
        return tokenString;
    }

    public AuthenticationManager.AuthResult authenticateBearerToken(KeycloakSession session, RealmModel realm) {
        KeycloakContext ctx = session.getContext();
        return this.authenticateBearerToken(session, realm, ctx.getUri(), ctx.getConnection(), ctx.getRequestHeaders());
    }

    public AuthenticationManager.AuthResult authenticateBearerToken(KeycloakSession session) {
        return this.authenticateBearerToken(session, session.getContext().getRealm(), session.getContext().getUri(), session.getContext().getConnection(), session.getContext().getRequestHeaders());
    }

    public AuthenticationManager.AuthResult authenticateBearerToken(KeycloakSession session, RealmModel realm, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers) {
        return this.authenticateBearerToken(this.extractAuthorizationHeaderToken(headers), session, realm, uriInfo, connection, headers);
    }

    public AuthenticationManager.AuthResult authenticateBearerToken(String tokenString, KeycloakSession session, RealmModel realm, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers) {
        if (tokenString == null) {
            return null;
        }
        AuthenticationManager.AuthResult authResult = AppAuthManager.verifyIdentityToken(session, realm, uriInfo, connection, true, true, false, tokenString, headers);
        return authResult;
    }
}

