/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.util.LinkedList;
import java.util.List;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;

public class OAuthGrantBean {
    private List<ClientScopeEntry> clientScopesRequested = new LinkedList<ClientScopeEntry>();
    private String code;
    private ClientModel client;

    public OAuthGrantBean(String code, ClientModel client, List<ClientScopeModel> clientScopesRequested) {
        this.code = code;
        this.client = client;
        for (ClientScopeModel clientScope : clientScopesRequested) {
            this.clientScopesRequested.add(new ClientScopeEntry(clientScope.getConsentScreenText()));
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getClient() {
        return this.client.getClientId();
    }

    public List<ClientScopeEntry> getClientScopesRequested() {
        return this.clientScopesRequested;
    }

    public static class ClientScopeEntry {
        private final String consentScreenText;

        private ClientScopeEntry(String consentScreenText) {
            this.consentScreenText = consentScreenText;
        }

        public String getConsentScreenText() {
            return this.consentScreenText;
        }
    }
}

