/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.AbstractMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.RestartLoginCookie;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.CookieHelper;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.sessions.StickySessionEncoderProvider;

public class AuthenticationSessionManager {
    public static final String AUTH_SESSION_ID = "AUTH_SESSION_ID";
    public static final int AUTH_SESSION_LIMIT = 3;
    private static final Logger log = Logger.getLogger(AuthenticationSessionManager.class);
    private final KeycloakSession session;

    public AuthenticationSessionManager(KeycloakSession session) {
        this.session = session;
    }

    public RootAuthenticationSessionModel createAuthenticationSession(RealmModel realm, boolean browserCookie) {
        RootAuthenticationSessionModel rootAuthSession = this.session.authenticationSessions().createRootAuthenticationSession(realm);
        if (browserCookie) {
            this.setAuthSessionCookie(rootAuthSession.getId(), realm);
        }
        return rootAuthSession;
    }

    public RootAuthenticationSessionModel getCurrentRootAuthenticationSession(RealmModel realm) {
        List<String> authSessionIds = this.getAuthSessionCookieIds(realm);
        return authSessionIds.stream().map(id -> {
            AbstractMap.SimpleEntry<String, String> entry = this.decodeAuthSessionId((String)id);
            String sessionId = entry.getKey();
            RootAuthenticationSessionModel rootAuthSession = this.session.authenticationSessions().getRootAuthenticationSession(realm, sessionId);
            if (rootAuthSession != null) {
                this.reencodeAuthSessionCookie(sessionId, entry.getValue(), realm);
                return rootAuthSession;
            }
            return null;
        }).filter(authSession -> Objects.nonNull(authSession)).findFirst().orElse(null);
    }

    public UserSessionModel getUserSessionFromAuthCookie(RealmModel realm) {
        List<String> authSessionIds = this.getAuthSessionCookieIds(realm);
        return authSessionIds.stream().map(id -> {
            AbstractMap.SimpleEntry<String, String> entry = this.decodeAuthSessionId((String)id);
            String sessionId = entry.getKey();
            UserSessionModel userSession = this.session.sessions().getUserSession(realm, sessionId);
            if (userSession != null) {
                this.reencodeAuthSessionCookie(sessionId, entry.getValue(), realm);
                return userSession;
            }
            return null;
        }).filter(authSession -> Objects.nonNull(authSession)).findFirst().orElse(null);
    }

    public AuthenticationSessionModel getCurrentAuthenticationSession(RealmModel realm, ClientModel client, String tabId) {
        List<String> authSessionIds = this.getAuthSessionCookieIds(realm);
        return authSessionIds.stream().map(id -> {
            AbstractMap.SimpleEntry<String, String> entry = this.decodeAuthSessionId((String)id);
            String sessionId = entry.getKey();
            AuthenticationSessionModel authSession = this.getAuthenticationSessionByIdAndClient(realm, sessionId, client, tabId);
            if (authSession != null) {
                this.reencodeAuthSessionCookie(sessionId, entry.getValue(), realm);
                return authSession;
            }
            return null;
        }).filter(authSession -> Objects.nonNull(authSession)).findFirst().orElse(null);
    }

    public void setAuthSessionCookie(String authSessionId, RealmModel realm) {
        UriInfo uriInfo = this.session.getContext().getUri();
        String cookiePath = AuthenticationManager.getRealmCookiePath(realm, uriInfo);
        boolean sslRequired = realm.getSslRequired().isRequired(this.session.getContext().getConnection());
        StickySessionEncoderProvider encoder = (StickySessionEncoderProvider)this.session.getProvider(StickySessionEncoderProvider.class);
        String encodedAuthSessionId = encoder.encodeSessionId(authSessionId);
        CookieHelper.addCookie(AUTH_SESSION_ID, encodedAuthSessionId, cookiePath, null, null, -1, sslRequired, true);
        log.debugf("Set AUTH_SESSION_ID cookie with value %s", (Object)encodedAuthSessionId);
    }

    public AbstractMap.SimpleEntry<String, String> decodeAuthSessionId(String authSessionId) {
        log.debugf("Found AUTH_SESSION_ID cookie with value %s", (Object)authSessionId);
        StickySessionEncoderProvider encoder = (StickySessionEncoderProvider)this.session.getProvider(StickySessionEncoderProvider.class);
        String decodedAuthSessionId = encoder.decodeSessionId(authSessionId);
        String reencoded = encoder.encodeSessionId(decodedAuthSessionId);
        return new AbstractMap.SimpleEntry<String, String>(decodedAuthSessionId, reencoded);
    }

    public void reencodeAuthSessionCookie(String decodedAuthSessionId, String reencodedAuthSessionId, RealmModel realm) {
        if (!decodedAuthSessionId.equals(reencodedAuthSessionId)) {
            log.debugf("Route changed. Will update authentication session cookie", new Object[0]);
            this.setAuthSessionCookie(decodedAuthSessionId, realm);
        }
    }

    public List<String> getAuthSessionCookieIds(RealmModel realm) {
        List<String> authSessionIds;
        Set<String> cookiesVal = CookieHelper.getCookieValue(AUTH_SESSION_ID);
        if (cookiesVal.size() > 1) {
            AuthenticationManager.expireOldAuthSessionCookie(realm, this.session.getContext().getUri(), this.session.getContext().getConnection());
        }
        if ((authSessionIds = cookiesVal.stream().limit(3L).collect(Collectors.toList())).isEmpty()) {
            log.debugf("Not found AUTH_SESSION_ID cookie", new Object[0]);
        }
        return authSessionIds;
    }

    public void removeAuthenticationSession(RealmModel realm, AuthenticationSessionModel authSession, boolean expireRestartCookie) {
        RootAuthenticationSessionModel rootAuthSession = authSession.getParentSession();
        log.debugf("Removing authSession '%s'. Expire restart cookie: %b", (Object)rootAuthSession.getId(), (Object)expireRestartCookie);
        this.session.authenticationSessions().removeRootAuthenticationSession(realm, rootAuthSession);
        if (expireRestartCookie) {
            ClientConnection clientConnection = this.session.getContext().getConnection();
            UriInfo uriInfo = this.session.getContext().getUri();
            RestartLoginCookie.expireRestartCookie(realm, clientConnection, uriInfo);
        }
    }

    public UserSessionModel getUserSession(AuthenticationSessionModel authSession) {
        return this.session.sessions().getUserSession(authSession.getRealm(), authSession.getParentSession().getId());
    }

    public AuthenticationSessionModel getAuthenticationSessionByIdAndClient(RealmModel realm, String authSessionId, ClientModel client, String tabId) {
        RootAuthenticationSessionModel rootAuthSession = this.session.authenticationSessions().getRootAuthenticationSession(realm, authSessionId);
        return rootAuthSession == null ? null : rootAuthSession.getAuthenticationSession(client, tabId);
    }
}

