/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.protection.introspect;

import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.AccessTokenIntrospectionProvider;
import org.keycloak.representations.AccessToken;
import org.keycloak.util.JsonSerialization;

public class RPTIntrospectionProvider
extends AccessTokenIntrospectionProvider {
    protected static final Logger LOGGER = Logger.getLogger(RPTIntrospectionProvider.class);

    public RPTIntrospectionProvider(KeycloakSession session) {
        super(session);
    }

    @Override
    public Response introspect(String token) {
        LOGGER.debug((Object)"Introspecting requesting party token");
        try {
            ObjectNode tokenMetadata;
            AccessToken accessToken = this.verifyAccessToken(token);
            if (accessToken != null) {
                AccessToken metadata = new AccessToken();
                metadata.id(accessToken.getId());
                metadata.setAcr(accessToken.getAcr());
                metadata.type(accessToken.getType());
                metadata.expiration(accessToken.getExpiration());
                metadata.issuedAt(accessToken.getIssuedAt());
                metadata.audience(accessToken.getAudience());
                metadata.notBefore(accessToken.getNotBefore());
                metadata.setRealmAccess(null);
                metadata.setResourceAccess(null);
                tokenMetadata = JsonSerialization.createObjectNode((Object)metadata);
                tokenMetadata.putPOJO("permissions", (Object)accessToken.getAuthorization().getPermissions());
            } else {
                tokenMetadata = JsonSerialization.createObjectNode();
            }
            tokenMetadata.put("active", accessToken != null);
            return Response.ok((Object)JsonSerialization.writeValueAsBytes((Object)tokenMetadata)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating token introspection response.", e);
        }
    }

    @Override
    public void close() {
    }
}

