/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.Time;
import org.keycloak.common.util.UriUtils;
import org.keycloak.credential.CredentialInput;
import org.keycloak.events.Event;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.forms.account.AccountPages;
import org.keycloak.forms.account.AccountProvider;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.credential.PasswordUserCredentialModel;
import org.keycloak.models.utils.CredentialValidation;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.AbstractSecuredLocalService;
import org.keycloak.services.resources.AttributeFormDataProcessor;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.account.Constants;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.services.validation.Validation;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.util.JsonSerialization;

public class AccountFormService
extends AbstractSecuredLocalService {
    private static final Logger logger = Logger.getLogger(AccountFormService.class);
    private static Set<String> VALID_PATHS = new HashSet<String>();
    public static final String ACCOUNT_MGMT_FORWARDED_ERROR_NOTE = "ACCOUNT_MGMT_FORWARDED_ERROR";
    private final AppAuthManager authManager;
    private EventBuilder event;
    private AccountProvider account;
    private EventStoreProvider eventStore;

    public AccountFormService(RealmModel realm, ClientModel client, EventBuilder event) {
        super(realm, client);
        this.event = event;
        this.authManager = new AppAuthManager();
    }

    public void init() {
        String referrer;
        this.eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        this.account = ((AccountProvider)this.session.getProvider(AccountProvider.class)).setRealm(this.realm).setUriInfo(this.uriInfo).setHttpHeaders(this.headers);
        AuthenticationManager.AuthResult authResult = this.authManager.authenticateIdentityCookie(this.session, this.realm);
        if (authResult != null) {
            this.stateChecker = (String)this.session.getAttribute("state_checker");
            this.auth = new Auth(this.realm, authResult.getToken(), authResult.getUser(), this.client, authResult.getSession(), true);
            this.account.setStateChecker(this.stateChecker);
        }
        String requestOrigin = UriUtils.getOrigin((URI)this.uriInfo.getBaseUri());
        String origin = (String)this.headers.getRequestHeaders().getFirst((Object)"Origin");
        if (origin != null && !requestOrigin.equals(origin)) {
            throw new ForbiddenException();
        }
        if (!this.request.getHttpMethod().equals("GET") && (referrer = (String)this.headers.getRequestHeaders().getFirst((Object)"Referer")) != null && !requestOrigin.equals(UriUtils.getOrigin((String)referrer))) {
            throw new ForbiddenException();
        }
        if (authResult != null) {
            UserSessionModel userSession = authResult.getSession();
            if (userSession != null) {
                AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(this.client.getId());
                if (clientSession == null) {
                    clientSession = this.session.sessions().createClientSession(userSession.getRealm(), this.client, userSession);
                }
                this.auth.setClientSession(clientSession);
            }
            this.account.setUser(this.auth.getUser());
        }
        this.account.setFeatures(this.realm.isIdentityFederationEnabled(), this.eventStore != null && this.realm.isEventsEnabled(), true, Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION));
    }

    public static UriBuilder accountServiceBaseUrl(UriInfo uriInfo) {
        UriBuilder base = uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getAccountService");
        return base;
    }

    public static UriBuilder accountServiceApplicationPage(UriInfo uriInfo) {
        return AccountFormService.accountServiceBaseUrl(uriInfo).path(AccountFormService.class, "applicationsPage");
    }

    @Override
    protected Set<String> getValidPaths() {
        return VALID_PATHS;
    }

    private Response forwardToPage(String path, AccountPages page) {
        if (this.auth != null) {
            String forwardedError;
            AuthenticationSessionModel authSession;
            try {
                this.auth.require("manage-account");
            }
            catch (ForbiddenException e) {
                return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setError("noAccessMessage", new Object[0]).createErrorPage(Response.Status.FORBIDDEN);
            }
            this.setReferrerOnPage();
            UserSessionModel userSession = this.auth.getSession();
            String tabId = (String)this.request.getUri().getQueryParameters().getFirst((Object)"tab_id");
            if (tabId != null && (authSession = new AuthenticationSessionManager(this.session).getAuthenticationSessionByIdAndClient(this.realm, userSession.getId(), this.client, tabId)) != null && (forwardedError = authSession.getAuthNote(ACCOUNT_MGMT_FORWARDED_ERROR_NOTE)) != null) {
                try {
                    FormMessage errorMessage = (FormMessage)JsonSerialization.readValue((String)forwardedError, FormMessage.class);
                    this.account.setError(Response.Status.INTERNAL_SERVER_ERROR, errorMessage.getMessage(), errorMessage.getParameters());
                    authSession.removeAuthNote(ACCOUNT_MGMT_FORWARDED_ERROR_NOTE);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            return this.account.createResponse(page);
        }
        return this.login(path);
    }

    private void setReferrerOnPage() {
        String[] referrer = this.getReferrer();
        if (referrer != null) {
            this.account.setReferrer(referrer);
        }
    }

    @Path(value="/")
    @GET
    @Produces(value={"text/html"})
    public Response accountPage() {
        return this.forwardToPage(null, AccountPages.ACCOUNT);
    }

    public static UriBuilder totpUrl(UriBuilder base) {
        return RealmsResource.accountUrl(base).path(AccountFormService.class, "totpPage");
    }

    @Path(value="totp")
    @GET
    public Response totpPage() {
        this.account.setAttribute("mode", (String)this.uriInfo.getQueryParameters().getFirst((Object)"mode"));
        return this.forwardToPage("totp", AccountPages.TOTP);
    }

    public static UriBuilder passwordUrl(UriBuilder base) {
        return RealmsResource.accountUrl(base).path(AccountFormService.class, "passwordPage");
    }

    @Path(value="password")
    @GET
    public Response passwordPage() {
        if (this.auth != null) {
            this.account.setPasswordSet(AccountFormService.isPasswordSet(this.session, this.realm, this.auth.getUser()));
        }
        return this.forwardToPage("password", AccountPages.PASSWORD);
    }

    @Path(value="identity")
    @GET
    public Response federatedIdentityPage() {
        return this.forwardToPage("identity", AccountPages.FEDERATED_IDENTITY);
    }

    @Path(value="log")
    @GET
    public Response logPage() {
        if (this.auth != null) {
            List events = this.eventStore.createQuery().type(Constants.EXPOSED_LOG_EVENTS).user(this.auth.getUser().getId()).maxResults(30).getResultList();
            for (Event e : events) {
                if (e.getDetails() == null) continue;
                Iterator itr = e.getDetails().entrySet().iterator();
                while (itr.hasNext()) {
                    if (Constants.EXPOSED_LOG_DETAILS.contains(itr.next().getKey())) continue;
                    itr.remove();
                }
            }
            this.account.setEvents(events);
        }
        return this.forwardToPage("log", AccountPages.LOG);
    }

    @Path(value="sessions")
    @GET
    public Response sessionsPage() {
        if (this.auth != null) {
            this.account.setSessions(this.session.sessions().getUserSessions(this.realm, this.auth.getUser()));
        }
        return this.forwardToPage("sessions", AccountPages.SESSIONS);
    }

    @Path(value="applications")
    @GET
    public Response applicationsPage() {
        return this.forwardToPage("applications", AccountPages.APPLICATIONS);
    }

    @Path(value="/")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processAccountUpdate(MultivaluedMap<String, String> formData) {
        if (this.auth == null) {
            return this.login(null);
        }
        this.auth.require("manage-account");
        String action = (String)formData.getFirst((Object)"submitAction");
        if (action != null && action.equals("Cancel")) {
            this.setReferrerOnPage();
            return this.account.createResponse(AccountPages.ACCOUNT);
        }
        this.csrfCheck(formData);
        UserModel user = this.auth.getUser();
        this.event.event(EventType.UPDATE_PROFILE).client(this.auth.getClient()).user(this.auth.getUser());
        List<FormMessage> errors = Validation.validateUpdateProfileForm(this.realm, formData);
        if (errors != null && !errors.isEmpty()) {
            this.setReferrerOnPage();
            return this.account.setErrors(Response.Status.BAD_REQUEST, errors).setProfileFormData(formData).createResponse(AccountPages.ACCOUNT);
        }
        try {
            this.updateUsername((String)formData.getFirst((Object)"username"), user, this.session);
            this.updateEmail((String)formData.getFirst((Object)"email"), user, this.session, this.event);
            user.setFirstName((String)formData.getFirst((Object)"firstName"));
            user.setLastName((String)formData.getFirst((Object)"lastName"));
            AttributeFormDataProcessor.process(formData, this.realm, user);
            this.event.success();
            this.setReferrerOnPage();
            return this.account.setSuccess("accountUpdatedMessage", new Object[0]).createResponse(AccountPages.ACCOUNT);
        }
        catch (ReadOnlyException roe) {
            this.setReferrerOnPage();
            return this.account.setError(Response.Status.BAD_REQUEST, "readOnlyUserMessage", new Object[0]).setProfileFormData(formData).createResponse(AccountPages.ACCOUNT);
        }
        catch (ModelDuplicateException mde) {
            this.setReferrerOnPage();
            return this.account.setError(Response.Status.CONFLICT, mde.getMessage(), new Object[0]).setProfileFormData(formData).createResponse(AccountPages.ACCOUNT);
        }
    }

    @Path(value="sessions")
    @POST
    public Response processSessionsLogout(MultivaluedMap<String, String> formData) {
        if (this.auth == null) {
            return this.login("sessions");
        }
        this.auth.require("manage-account");
        this.csrfCheck(formData);
        UserModel user = this.auth.getUser();
        this.session.users().setNotBeforeForUser(this.realm, user, Time.currentTime() - 1);
        List userSessions = this.session.sessions().getUserSessions(this.realm, user);
        for (UserSessionModel userSession : userSessions) {
            AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, this.uriInfo, this.clientConnection, this.headers, true);
        }
        UriBuilder builder = Urls.accountBase(this.uriInfo.getBaseUri()).path(AccountFormService.class, "sessionsPage");
        String referrer = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer");
        if (referrer != null) {
            builder.queryParam("referrer", new Object[]{referrer});
        }
        URI location = builder.build(new Object[]{this.realm.getName()});
        return Response.seeOther((URI)location).build();
    }

    @Path(value="applications")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processRevokeGrant(MultivaluedMap<String, String> formData) {
        if (this.auth == null) {
            return this.login("applications");
        }
        this.auth.require("manage-account");
        this.csrfCheck(formData);
        String clientId = (String)formData.getFirst((Object)"clientId");
        if (clientId == null) {
            return this.account.setError(Response.Status.BAD_REQUEST, "clientNotFoundMessage", new Object[0]).createResponse(AccountPages.APPLICATIONS);
        }
        ClientModel client = this.realm.getClientById(clientId);
        if (client == null) {
            return this.account.setError(Response.Status.BAD_REQUEST, "clientNotFoundMessage", new Object[0]).createResponse(AccountPages.APPLICATIONS);
        }
        UserModel user = this.auth.getUser();
        this.session.users().revokeConsentForClient(this.realm, user.getId(), client.getId());
        new UserSessionManager(this.session).revokeOfflineToken(user, client);
        AuthenticationManager.backchannelLogoutUserFromClient(this.session, this.realm, user, client, this.uriInfo, this.headers);
        this.event.event(EventType.REVOKE_GRANT).client(this.auth.getClient()).user(this.auth.getUser()).detail("revoked_client", client.getClientId()).success();
        this.setReferrerOnPage();
        UriBuilder builder = Urls.accountBase(this.uriInfo.getBaseUri()).path(AccountFormService.class, "applicationsPage");
        String referrer = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer");
        if (referrer != null) {
            builder.queryParam("referrer", new Object[]{referrer});
        }
        URI location = builder.build(new Object[]{this.realm.getName()});
        return Response.seeOther((URI)location).build();
    }

    @Path(value="totp")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processTotpUpdate(MultivaluedMap<String, String> formData) {
        if (this.auth == null) {
            return this.login("totp");
        }
        this.auth.require("manage-account");
        this.account.setAttribute("mode", (String)this.uriInfo.getQueryParameters().getFirst((Object)"mode"));
        String action = (String)formData.getFirst((Object)"submitAction");
        if (action != null && action.equals("Cancel")) {
            this.setReferrerOnPage();
            return this.account.createResponse(AccountPages.TOTP);
        }
        this.csrfCheck(formData);
        UserModel user = this.auth.getUser();
        if (action != null && action.equals("Delete")) {
            this.session.userCredentialManager().disableCredentialType(this.realm, user, "otp");
            this.event.event(EventType.REMOVE_TOTP).client(this.auth.getClient()).user(this.auth.getUser()).success();
            this.setReferrerOnPage();
            return this.account.setSuccess("successTotpRemovedMessage", new Object[0]).createResponse(AccountPages.TOTP);
        }
        String totp = (String)formData.getFirst((Object)"totp");
        String totpSecret = (String)formData.getFirst((Object)"totpSecret");
        if (Validation.isBlank(totp)) {
            this.setReferrerOnPage();
            return this.account.setError(Response.Status.BAD_REQUEST, "missingTotpMessage", new Object[0]).createResponse(AccountPages.TOTP);
        }
        if (!CredentialValidation.validOTP((RealmModel)this.realm, (String)totp, (String)totpSecret)) {
            this.setReferrerOnPage();
            return this.account.setError(Response.Status.BAD_REQUEST, "invalidTotpMessage", new Object[0]).createResponse(AccountPages.TOTP);
        }
        UserCredentialModel credentials = new UserCredentialModel();
        credentials.setType(this.realm.getOTPPolicy().getType());
        credentials.setValue(totpSecret);
        this.session.userCredentialManager().updateCredential(this.realm, user, (CredentialInput)credentials);
        UserCredentialModel cred = new UserCredentialModel();
        cred.setType(this.realm.getOTPPolicy().getType());
        cred.setValue(totp);
        this.session.userCredentialManager().isValid(this.realm, user, new CredentialInput[]{cred});
        this.event.event(EventType.UPDATE_TOTP).client(this.auth.getClient()).user(this.auth.getUser()).success();
        this.setReferrerOnPage();
        return this.account.setSuccess("successTotpMessage", new Object[0]).createResponse(AccountPages.TOTP);
    }

    @Path(value="password")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processPasswordUpdate(MultivaluedMap<String, String> formData) {
        if (this.auth == null) {
            return this.login("password");
        }
        this.auth.require("manage-account");
        this.csrfCheck(formData);
        UserModel user = this.auth.getUser();
        boolean requireCurrent = AccountFormService.isPasswordSet(this.session, this.realm, user);
        this.account.setPasswordSet(requireCurrent);
        String password = (String)formData.getFirst((Object)"password");
        String passwordNew = (String)formData.getFirst((Object)"password-new");
        String passwordConfirm = (String)formData.getFirst((Object)"password-confirm");
        EventBuilder errorEvent = this.event.clone().event(EventType.UPDATE_PASSWORD_ERROR).client(this.auth.getClient()).user(this.auth.getSession().getUser());
        if (requireCurrent) {
            if (Validation.isBlank(password)) {
                this.setReferrerOnPage();
                errorEvent.error("password_missing");
                return this.account.setError(Response.Status.BAD_REQUEST, "missingPasswordMessage", new Object[0]).createResponse(AccountPages.PASSWORD);
            }
            PasswordUserCredentialModel cred = UserCredentialModel.password((String)password);
            if (!this.session.userCredentialManager().isValid(this.realm, user, new CredentialInput[]{cred})) {
                this.setReferrerOnPage();
                errorEvent.error("invalid_user_credentials");
                return this.account.setError(Response.Status.BAD_REQUEST, "invalidPasswordExistingMessage", new Object[0]).createResponse(AccountPages.PASSWORD);
            }
        }
        if (Validation.isBlank(passwordNew)) {
            this.setReferrerOnPage();
            errorEvent.error("password_missing");
            return this.account.setError(Response.Status.BAD_REQUEST, "missingPasswordMessage", new Object[0]).createResponse(AccountPages.PASSWORD);
        }
        if (!passwordNew.equals(passwordConfirm)) {
            this.setReferrerOnPage();
            errorEvent.error("password_confirm_error");
            return this.account.setError(Response.Status.BAD_REQUEST, "invalidPasswordConfirmMessage", new Object[0]).createResponse(AccountPages.PASSWORD);
        }
        try {
            this.session.userCredentialManager().updateCredential(this.realm, user, (CredentialInput)UserCredentialModel.password((String)passwordNew, (boolean)false));
        }
        catch (ReadOnlyException mre) {
            this.setReferrerOnPage();
            errorEvent.error("not_allowed");
            return this.account.setError(Response.Status.BAD_REQUEST, "readOnlyPasswordMessage", new Object[0]).createResponse(AccountPages.PASSWORD);
        }
        catch (ModelException me) {
            ServicesLogger.LOGGER.failedToUpdatePassword((Exception)((Object)me));
            this.setReferrerOnPage();
            errorEvent.detail("reason", me.getMessage()).error("password_rejected");
            return this.account.setError(Response.Status.INTERNAL_SERVER_ERROR, me.getMessage(), me.getParameters()).createResponse(AccountPages.PASSWORD);
        }
        catch (Exception ape) {
            ServicesLogger.LOGGER.failedToUpdatePassword(ape);
            this.setReferrerOnPage();
            errorEvent.detail("reason", ape.getMessage()).error("password_rejected");
            return this.account.setError(Response.Status.INTERNAL_SERVER_ERROR, ape.getMessage(), new Object[0]).createResponse(AccountPages.PASSWORD);
        }
        List sessions = this.session.sessions().getUserSessions(this.realm, user);
        for (UserSessionModel s : sessions) {
            if (s.getId().equals(this.auth.getSession().getId())) continue;
            AuthenticationManager.backchannelLogout(this.session, this.realm, s, this.uriInfo, this.clientConnection, this.headers, true);
        }
        this.event.event(EventType.UPDATE_PASSWORD).client(this.auth.getClient()).user(this.auth.getUser()).success();
        this.setReferrerOnPage();
        return this.account.setPasswordSet(true).setSuccess("accountPasswordUpdatedMessage", new Object[0]).createResponse(AccountPages.PASSWORD);
    }

    @Path(value="identity")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processFederatedIdentityUpdate(MultivaluedMap<String, String> formData) {
        if (this.auth == null) {
            return this.login("identity");
        }
        this.auth.require("manage-account");
        this.csrfCheck(formData);
        UserModel user = this.auth.getUser();
        String action = (String)formData.getFirst((Object)"action");
        String providerId = (String)formData.getFirst((Object)"providerId");
        if (Validation.isEmpty(providerId)) {
            this.setReferrerOnPage();
            return this.account.setError(Response.Status.BAD_REQUEST, "missingIdentityProviderMessage", new Object[0]).createResponse(AccountPages.FEDERATED_IDENTITY);
        }
        AccountSocialAction accountSocialAction = AccountSocialAction.getAction(action);
        if (accountSocialAction == null) {
            this.setReferrerOnPage();
            return this.account.setError(Response.Status.BAD_REQUEST, "invalidFederatedIdentityActionMessage", new Object[0]).createResponse(AccountPages.FEDERATED_IDENTITY);
        }
        boolean hasProvider = false;
        for (IdentityProviderModel model : this.realm.getIdentityProviders()) {
            if (!model.getAlias().equals(providerId)) continue;
            hasProvider = true;
        }
        if (!hasProvider) {
            this.setReferrerOnPage();
            return this.account.setError(Response.Status.BAD_REQUEST, "identityProviderNotFoundMessage", new Object[0]).createResponse(AccountPages.FEDERATED_IDENTITY);
        }
        if (!user.isEnabled()) {
            this.setReferrerOnPage();
            return this.account.setError(Response.Status.BAD_REQUEST, "accountDisabledMessage", new Object[0]).createResponse(AccountPages.FEDERATED_IDENTITY);
        }
        switch (accountSocialAction) {
            case ADD: {
                String redirectUri = UriBuilder.fromUri((URI)Urls.accountFederatedIdentityPage(this.uriInfo.getBaseUri(), this.realm.getName())).build(new Object[0]).toString();
                try {
                    String nonce = UUID.randomUUID().toString();
                    MessageDigest md = MessageDigest.getInstance("SHA-256");
                    String input = nonce + this.auth.getSession().getId() + this.client.getClientId() + providerId;
                    byte[] check = md.digest(input.getBytes(StandardCharsets.UTF_8));
                    String hash = Base64Url.encode((byte[])check);
                    URI linkUrl = Urls.identityProviderLinkRequest(this.uriInfo.getBaseUri(), providerId, this.realm.getName());
                    linkUrl = UriBuilder.fromUri((URI)linkUrl).queryParam("nonce", new Object[]{nonce}).queryParam("hash", new Object[]{hash}).queryParam("client_id", new Object[]{this.client.getClientId()}).queryParam("redirect_uri", new Object[]{redirectUri}).build(new Object[0]);
                    return Response.seeOther((URI)linkUrl).build();
                }
                catch (Exception spe) {
                    this.setReferrerOnPage();
                    return this.account.setError(Response.Status.INTERNAL_SERVER_ERROR, "identityProviderRedirectErrorMessage", new Object[0]).createResponse(AccountPages.FEDERATED_IDENTITY);
                }
            }
            case REMOVE: {
                FederatedIdentityModel link = this.session.users().getFederatedIdentity(user, providerId, this.realm);
                if (link != null) {
                    if (this.session.users().getFederatedIdentities(user, this.realm).size() > 1 || user.getFederationLink() != null || AccountFormService.isPasswordSet(this.session, this.realm, user)) {
                        this.session.users().removeFederatedIdentity(this.realm, user, providerId);
                        logger.debugv("Social provider {0} removed successfully from user {1}", (Object)providerId, (Object)user.getUsername());
                        this.event.event(EventType.REMOVE_FEDERATED_IDENTITY).client(this.auth.getClient()).user(this.auth.getUser()).detail("username", this.auth.getUser().getUsername()).detail("identity_provider", link.getIdentityProvider()).detail("identity_provider_identity", link.getUserName()).success();
                        this.setReferrerOnPage();
                        return this.account.setSuccess("identityProviderRemovedMessage", new Object[0]).createResponse(AccountPages.FEDERATED_IDENTITY);
                    }
                    this.setReferrerOnPage();
                    return this.account.setError(Response.Status.BAD_REQUEST, "federatedIdentityRemovingLastProviderMessage", new Object[0]).createResponse(AccountPages.FEDERATED_IDENTITY);
                }
                this.setReferrerOnPage();
                return this.account.setError(Response.Status.BAD_REQUEST, "federatedIdentityLinkNotActiveMessage", new Object[0]).createResponse(AccountPages.FEDERATED_IDENTITY);
            }
        }
        throw new IllegalArgumentException();
    }

    @Path(value="resource")
    @GET
    public Response resourcesPage(@QueryParam(value="resource_id") String resourceId) {
        return this.forwardToPage("resources", AccountPages.RESOURCES);
    }

    @Path(value="resource/{resource_id}")
    @GET
    public Response resourceDetailPage(@PathParam(value="resource_id") String resourceId) {
        return this.forwardToPage("resource-detail", AccountPages.RESOURCE_DETAIL);
    }

    @Path(value="resource/{resource_id}/grant")
    @POST
    public Response grantPermission(@PathParam(value="resource_id") String resourceId, @FormParam(value="action") String action, @FormParam(value="permission_id") String[] permissionId, @FormParam(value="requester") String requester) {
        AuthorizationProvider authorization = (AuthorizationProvider)this.session.getProvider(AuthorizationProvider.class);
        PermissionTicketStore ticketStore = authorization.getStoreFactory().getPermissionTicketStore();
        Resource resource = authorization.getStoreFactory().getResourceStore().findById(resourceId, null);
        if (resource == null) {
            return ErrorResponse.error("Invalid resource", Response.Status.BAD_REQUEST);
        }
        if (action == null) {
            return ErrorResponse.error("Invalid action", Response.Status.BAD_REQUEST);
        }
        boolean isGrant = "grant".equals(action);
        boolean isDeny = "deny".equals(action);
        boolean isRevoke = "revoke".equals(action);
        boolean isRevokePolicy = "revokePolicy".equals(action);
        boolean isRevokePolicyAll = "revokePolicyAll".equals(action);
        if (isRevokePolicy || isRevokePolicyAll) {
            ArrayList<String> ids = new ArrayList<String>(Arrays.asList(permissionId));
            Iterator iterator = ids.iterator();
            PolicyStore policyStore = authorization.getStoreFactory().getPolicyStore();
            Policy policy = null;
            while (iterator.hasNext()) {
                String id = (String)iterator.next();
                if (id.contains(":")) continue;
                policy = policyStore.findById(id, this.client.getId());
                iterator.remove();
                break;
            }
            HashSet<Scope> scopesToKeep = new HashSet<Scope>();
            if (isRevokePolicyAll) {
                for (Scope scope : policy.getScopes()) {
                    policy.removeScope(scope);
                }
            } else {
                for (String id : ids) {
                    scopesToKeep.add(authorization.getStoreFactory().getScopeStore().findById(id.split(":")[1], this.client.getId()));
                }
                for (Scope scope : policy.getScopes()) {
                    if (scopesToKeep.contains(scope)) continue;
                    policy.removeScope(scope);
                }
            }
            if (policy.getScopes().isEmpty()) {
                for (Policy associated : policy.getAssociatedPolicies()) {
                    policyStore.delete(associated.getId());
                }
                policyStore.delete(policy.getId());
            }
        } else {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("resource.id", resource.getId());
            filters.put("requester", this.session.users().getUserByUsername(requester, this.realm).getId());
            if (isRevoke) {
                filters.put("granted", Boolean.TRUE.toString());
            } else {
                filters.put("granted", Boolean.FALSE.toString());
            }
            List tickets = ticketStore.find(filters, resource.getResourceServer().getId(), -1, -1);
            Iterator iterator = tickets.iterator();
            while (iterator.hasNext()) {
                PermissionTicket ticket = (PermissionTicket)iterator.next();
                if (isGrant && permissionId != null && permissionId.length > 0 && !Arrays.asList(permissionId).contains(ticket.getId())) continue;
                if (isGrant && !ticket.isGranted()) {
                    ticket.setGrantedTimestamp(Long.valueOf(System.currentTimeMillis()));
                    iterator.remove();
                    continue;
                }
                if (!isDeny && !isRevoke || permissionId == null || permissionId.length <= 0 || !Arrays.asList(permissionId).contains(ticket.getId())) continue;
                iterator.remove();
            }
            for (PermissionTicket ticket : tickets) {
                ticketStore.delete(ticket.getId());
            }
        }
        if (isRevoke || isRevokePolicy || isRevokePolicyAll) {
            return this.forwardToPage("resource-detail", AccountPages.RESOURCE_DETAIL);
        }
        return this.forwardToPage("resources", AccountPages.RESOURCES);
    }

    @Path(value="resource/{resource_id}/share")
    @POST
    public Response shareResource(@PathParam(value="resource_id") String resourceId, @FormParam(value="user_id") String[] userIds, @FormParam(value="scope_id") String[] scopes) {
        AuthorizationProvider authorization = (AuthorizationProvider)this.session.getProvider(AuthorizationProvider.class);
        PermissionTicketStore ticketStore = authorization.getStoreFactory().getPermissionTicketStore();
        Resource resource = authorization.getStoreFactory().getResourceStore().findById(resourceId, null);
        if (resource == null) {
            return ErrorResponse.error("Invalid resource", Response.Status.BAD_REQUEST);
        }
        if (userIds == null || userIds.length == 0) {
            return this.account.setError(Response.Status.BAD_REQUEST, "missingPasswordMessage", new Object[0]).createResponse(AccountPages.PASSWORD);
        }
        for (String id : userIds) {
            UserModel user = this.session.users().getUserById(id, this.realm);
            if (user == null) {
                user = this.session.users().getUserByUsername(id, this.realm);
            }
            if (user == null) {
                user = this.session.users().getUserByEmail(id, this.realm);
            }
            if (user == null) {
                return this.account.setError(Response.Status.BAD_REQUEST, "invalidUserMessage", new Object[0]).createResponse(AccountPages.RESOURCE_DETAIL);
            }
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("resource.id", resource.getId());
            filters.put("owner", this.auth.getUser().getId());
            filters.put("requester", user.getId());
            List tickets = ticketStore.find(filters, resource.getResourceServer().getId(), -1, -1);
            if (tickets.isEmpty()) {
                if (scopes != null && scopes.length > 0) {
                    for (String scope : scopes) {
                        PermissionTicket ticket = ticketStore.create(resourceId, scope, user.getId(), resource.getResourceServer());
                        ticket.setGrantedTimestamp(Long.valueOf(System.currentTimeMillis()));
                    }
                    continue;
                }
                if (resource.getScopes().isEmpty()) {
                    PermissionTicket ticket = ticketStore.create(resourceId, null, user.getId(), resource.getResourceServer());
                    ticket.setGrantedTimestamp(Long.valueOf(System.currentTimeMillis()));
                    continue;
                }
                for (Scope scope : resource.getScopes()) {
                    PermissionTicket ticket = ticketStore.create(resourceId, scope.getId(), user.getId(), resource.getResourceServer());
                    ticket.setGrantedTimestamp(Long.valueOf(System.currentTimeMillis()));
                }
                continue;
            }
            if (scopes == null || scopes.length <= 0) continue;
            ArrayList<String> grantScopes = new ArrayList<String>(Arrays.asList(scopes));
            for (PermissionTicket ticket : tickets) {
                String scope;
                scope = ticket.getScope();
                if (scope == null) continue;
                grantScopes.remove(scope.getId());
            }
            for (String grantScope : grantScopes) {
                PermissionTicket ticket = ticketStore.create(resourceId, grantScope, user.getId(), resource.getResourceServer());
                ticket.setGrantedTimestamp(Long.valueOf(System.currentTimeMillis()));
            }
        }
        return this.forwardToPage("resource-detail", AccountPages.RESOURCE_DETAIL);
    }

    @Path(value="resource")
    @POST
    public Response processResourceActions(@FormParam(value="resource_id") String[] resourceIds, @FormParam(value="action") String action) {
        AuthorizationProvider authorization = (AuthorizationProvider)this.session.getProvider(AuthorizationProvider.class);
        PermissionTicketStore ticketStore = authorization.getStoreFactory().getPermissionTicketStore();
        if (action == null) {
            return ErrorResponse.error("Invalid action", Response.Status.BAD_REQUEST);
        }
        for (String resourceId : resourceIds) {
            Resource resource = authorization.getStoreFactory().getResourceStore().findById(resourceId, null);
            if (resource == null) {
                return ErrorResponse.error("Invalid resource", Response.Status.BAD_REQUEST);
            }
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("requester", this.auth.getUser().getId());
            filters.put("resource.id", resource.getId());
            if ("cancel".equals(action)) {
                filters.put("granted", Boolean.TRUE.toString());
            } else if ("cancelRequest".equals(action)) {
                filters.put("granted", Boolean.FALSE.toString());
            }
            for (PermissionTicket ticket : ticketStore.find(filters, resource.getResourceServer().getId(), -1, -1)) {
                ticketStore.delete(ticket.getId());
            }
        }
        return this.forwardToPage("authorization", AccountPages.RESOURCES);
    }

    public static UriBuilder loginRedirectUrl(UriBuilder base) {
        return RealmsResource.accountUrl(base).path(AccountFormService.class, "loginRedirect");
    }

    @Override
    protected URI getBaseRedirectUri() {
        return Urls.accountBase(this.uriInfo.getBaseUri()).path("/").build(new Object[]{this.realm.getName()});
    }

    public static boolean isPasswordSet(KeycloakSession session, RealmModel realm, UserModel user) {
        return session.userCredentialManager().isConfiguredFor(realm, user, "password");
    }

    private String[] getReferrer() {
        String referrer = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer");
        if (referrer == null) {
            return null;
        }
        String referrerUri = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer_uri");
        ClientModel referrerClient = this.realm.getClientByClientId(referrer);
        if (referrerClient != null) {
            if ((referrerUri = referrerUri != null ? RedirectUtils.verifyRedirectUri(this.uriInfo, referrerUri, this.realm, referrerClient) : ResolveRelative.resolveRelativeUri(this.uriInfo.getRequestUri(), this.client.getRootUrl(), referrerClient.getBaseUrl())) != null) {
                String referrerName = referrerClient.getName();
                if (Validation.isBlank(referrerName)) {
                    referrerName = referrer;
                }
                return new String[]{referrerName, referrerUri};
            }
        } else if (referrerUri != null) {
            referrerClient = this.realm.getClientByClientId(referrer);
            if (this.client != null && (referrerUri = RedirectUtils.verifyRedirectUri(this.uriInfo, referrerUri, this.realm, referrerClient)) != null) {
                return new String[]{referrer, referrerUri};
            }
        }
        return null;
    }

    private void updateUsername(String username, UserModel user, KeycloakSession session) {
        boolean usernameChanged;
        RealmModel realm = session.getContext().getRealm();
        boolean bl = usernameChanged = username == null || !user.getUsername().equals(username);
        if (realm.isEditUsernameAllowed() && !realm.isRegistrationEmailAsUsername()) {
            if (usernameChanged) {
                UserModel existing = session.users().getUserByUsername(username, realm);
                if (existing != null && !existing.getId().equals(user.getId())) {
                    throw new ModelDuplicateException("usernameExistsMessage");
                }
                user.setUsername(username);
            }
        } else if (usernameChanged) {
            // empty if block
        }
    }

    private void updateEmail(String email, UserModel user, KeycloakSession session, EventBuilder event) {
        UserModel existing;
        boolean emailChanged;
        RealmModel realm = session.getContext().getRealm();
        String oldEmail = user.getEmail();
        boolean bl = oldEmail != null ? !oldEmail.equals(email) : (emailChanged = email != null);
        if (emailChanged && !realm.isDuplicateEmailsAllowed() && (existing = session.users().getUserByEmail(email, realm)) != null && !existing.getId().equals(user.getId())) {
            throw new ModelDuplicateException("emailExistsMessage");
        }
        user.setEmail(email);
        if (emailChanged) {
            user.setEmailVerified(false);
            event.clone().event(EventType.UPDATE_EMAIL).detail("previous_email", oldEmail).detail("updated_email", email).success();
        }
        if (realm.isRegistrationEmailAsUsername()) {
            if (!realm.isDuplicateEmailsAllowed() && (existing = session.users().getUserByEmail(email, realm)) != null && !existing.getId().equals(user.getId())) {
                throw new ModelDuplicateException("usernameExistsMessage");
            }
            user.setUsername(email);
        }
    }

    private void csrfCheck(MultivaluedMap<String, String> formData) {
        String formStateChecker = (String)formData.getFirst((Object)"stateChecker");
        if (formStateChecker == null || !formStateChecker.equals(this.stateChecker)) {
            throw new ForbiddenException();
        }
    }

    static {
        for (Method m : AccountFormService.class.getMethods()) {
            Path p = m.getAnnotation(Path.class);
            if (p == null) continue;
            VALID_PATHS.add(p.value());
        }
    }

    private static enum AccountSocialAction {
        ADD,
        REMOVE;


        public static AccountSocialAction getAction(String action) {
            if ("add".equalsIgnoreCase(action)) {
                return ADD;
            }
            if ("remove".equalsIgnoreCase(action)) {
                return REMOVE;
            }
            return null;
        }
    }
}

