/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.protection.permission;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeyManager;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.representations.idm.authorization.PermissionResponse;
import org.keycloak.representations.idm.authorization.PermissionTicketToken;
import org.keycloak.services.ErrorResponseException;

public class AbstractPermissionService {
    private final AuthorizationProvider authorization;
    private final KeycloakIdentity identity;
    private final ResourceServer resourceServer;

    public AbstractPermissionService(KeycloakIdentity identity, ResourceServer resourceServer, AuthorizationProvider authorization) {
        this.identity = identity;
        this.resourceServer = resourceServer;
        this.authorization = authorization;
    }

    public Response create(List<PermissionRequest> request) {
        if (request == null || request.isEmpty()) {
            throw new ErrorResponseException("invalid_permission_request", "Invalid permission request.", Response.Status.BAD_REQUEST);
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new PermissionResponse(this.createPermissionTicket(request))).build();
    }

    private List<Permission> verifyRequestedResource(List<PermissionRequest> request) {
        ResourceStore resourceStore = this.authorization.getStoreFactory().getResourceStore();
        ArrayList<Permission> requestedResources = new ArrayList<Permission>();
        for (PermissionRequest permissionRequest : request) {
            String resourceSetId = permissionRequest.getResourceId();
            ArrayList<Resource> resources = new ArrayList<Resource>();
            if (resourceSetId == null) {
                if (permissionRequest.getScopes() == null || permissionRequest.getScopes().isEmpty()) {
                    throw new ErrorResponseException("invalid_resource_id", "Resource id or name not provided.", Response.Status.BAD_REQUEST);
                }
            } else {
                Resource resource = resourceStore.findById(resourceSetId, this.resourceServer.getId());
                if (resource != null) {
                    resources.add(resource);
                } else {
                    Resource serverResource;
                    Resource userResource = resourceStore.findByName(resourceSetId, this.identity.getId(), this.resourceServer.getId());
                    if (userResource != null) {
                        resources.add(userResource);
                    }
                    if (!this.identity.isResourceServer() && (serverResource = resourceStore.findByName(resourceSetId, this.resourceServer.getId())) != null) {
                        resources.add(serverResource);
                    }
                }
                if (resources.isEmpty()) {
                    throw new ErrorResponseException("invalid_resource_id", "Resource set with id [" + resourceSetId + "] does not exists in this server.", Response.Status.BAD_REQUEST);
                }
            }
            if (resources.isEmpty()) {
                requestedResources.add(new Permission(null, this.verifyRequestedScopes(permissionRequest, null)));
                continue;
            }
            for (Resource resource : resources) {
                requestedResources.add(new Permission(resource.getId(), this.verifyRequestedScopes(permissionRequest, resource)));
            }
        }
        return requestedResources;
    }

    private Set<String> verifyRequestedScopes(PermissionRequest request, Resource resource) {
        Set requestScopes = request.getScopes();
        if (requestScopes == null) {
            return Collections.emptySet();
        }
        ResourceStore resourceStore = this.authorization.getStoreFactory().getResourceStore();
        return requestScopes.stream().map(scopeName -> {
            Scope scope = null;
            if (resource != null) {
                scope = resource.getScopes().stream().filter(scope1 -> scope1.getName().equals(scopeName)).findFirst().orElse(null);
                if (scope == null && resource.getType() != null) {
                    scope = resourceStore.findByType(resource.getType(), this.resourceServer.getId()).stream().filter(baseResource -> baseResource.getOwner().equals(resource.getResourceServer().getId())).flatMap(resource1 -> resource1.getScopes().stream()).filter(baseScope -> baseScope.getName().equals(scopeName)).findFirst().orElse(null);
                }
            } else {
                scope = this.authorization.getStoreFactory().getScopeStore().findByName(scopeName, this.resourceServer.getId());
            }
            if (scope == null) {
                throw new ErrorResponseException("invalid_scope", "Scope [" + scopeName + "] is invalid", Response.Status.BAD_REQUEST);
            }
            return scope.getName();
        }).collect(Collectors.toSet());
    }

    private String createPermissionTicket(List<PermissionRequest> request) {
        List<Permission> permissions = this.verifyRequestedResource(request);
        KeyManager.ActiveRsaKey keys = this.authorization.getKeycloakSession().keys().getActiveRsaKey(this.authorization.getRealm());
        ClientModel targetClient = this.authorization.getRealm().getClientById(this.resourceServer.getId());
        PermissionTicketToken token = new PermissionTicketToken(permissions, targetClient.getClientId(), this.identity.getAccessToken());
        HashMap claims = new HashMap();
        for (PermissionRequest permissionRequest : request) {
            Map requestClaims = permissionRequest.getClaims();
            if (requestClaims == null) continue;
            claims.putAll(requestClaims);
        }
        if (!claims.isEmpty()) {
            token.setClaims(claims);
        }
        return new JWSBuilder().kid(keys.getKid()).jsonContent((Object)token).rsa256(keys.getPrivateKey());
    }
}

