/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.util.Collections;
import java.util.List;
import javax.crypto.SecretKey;
import org.jboss.logging.Logger;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.Time;
import org.keycloak.crypto.JavaAlgorithm;
import org.keycloak.crypto.KeyStatus;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.keys.FailsafeHmacKeyProvider;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class FailsafeSecretKeyProvider
implements KeyProvider {
    private static KeyWrapper KEY;
    private static long EXPIRES;
    private KeyWrapper key;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FailsafeSecretKeyProvider() {
        this.logger().errorv("No active keys found, using failsafe provider, please login to admin console to add keys. Clustering is not supported.", new Object[0]);
        Class<FailsafeHmacKeyProvider> clazz = FailsafeHmacKeyProvider.class;
        synchronized (FailsafeHmacKeyProvider.class) {
            if (EXPIRES < (long)Time.currentTime()) {
                KEY = this.createKeyWrapper();
                EXPIRES = Time.currentTime() + 600;
                if (EXPIRES > 0L) {
                    this.logger().warnv("Keys expired, re-generated kid={0}", (Object)KEY.getKid());
                }
            }
            this.key = KEY;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public List<KeyWrapper> getKeys() {
        return Collections.singletonList(this.key);
    }

    private KeyWrapper createKeyWrapper() {
        SecretKey secretKey = KeyUtils.loadSecretKey((byte[])KeycloakModelUtils.generateSecret((int)32), (String)JavaAlgorithm.getJavaAlgorithm((String)this.getAlgorithm()));
        KeyWrapper key = new KeyWrapper();
        key.setKid(KeycloakModelUtils.generateId());
        key.setUse(this.getUse());
        key.setType(this.getType());
        key.setAlgorithms(new String[]{this.getAlgorithm()});
        key.setStatus(KeyStatus.ACTIVE);
        key.setSecretKey(secretKey);
        return key;
    }

    protected abstract KeyUse getUse();

    protected abstract String getType();

    protected abstract String getAlgorithm();

    protected abstract Logger logger();
}

