/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapperUtils;
import org.keycloak.protocol.saml.mappers.AbstractSAMLProtocolMapper;
import org.keycloak.protocol.saml.mappers.AttributeStatementHelper;
import org.keycloak.protocol.saml.mappers.SAMLAttributeStatementMapper;
import org.keycloak.provider.ProviderConfigProperty;

public class UserPropertyAttributeStatementMapper
extends AbstractSAMLProtocolMapper
implements SAMLAttributeStatementMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "saml-user-property-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Property";
    }

    public String getDisplayCategory() {
        return "AttributeStatement Mapper";
    }

    public String getHelpText() {
        return "Map a built in user property (email, firstName, lastName) to a SAML attribute type.";
    }

    @Override
    public void transformAttributeStatement(AttributeStatementType attributeStatement, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        String propertyName;
        UserModel user = userSession.getUser();
        String propertyValue = ProtocolMapperUtils.getUserModelValue(user, propertyName = (String)mappingModel.getConfig().get("user.attribute"));
        if (propertyValue == null) {
            return;
        }
        AttributeStatementHelper.addAttribute(attributeStatement, mappingModel, propertyValue);
    }

    public static ProtocolMapperModel createAttributeMapper(String name, String userAttribute, String samlAttributeName, String nameFormat, String friendlyName, boolean consentRequired, String consentText) {
        String mapperId = PROVIDER_ID;
        return AttributeStatementHelper.createAttributeMapper(name, userAttribute, samlAttributeName, nameFormat, friendlyName, mapperId);
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("user.attribute");
        property.setLabel("usermodel.prop.label");
        property.setHelpText("usermodel.prop.tooltip");
        configProperties.add(property);
        AttributeStatementHelper.setConfigProperties(configProperties);
    }
}

