/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.util.LinkedList;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AbstractFormAuthenticator;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.PasswordUserCredentialModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.ServicesLogger;

public abstract class AbstractUsernameFormAuthenticator
extends AbstractFormAuthenticator {
    private static final Logger logger = Logger.getLogger(AbstractUsernameFormAuthenticator.class);
    public static final String REGISTRATION_FORM_ACTION = "registration_form";
    public static final String ATTEMPTED_USERNAME = "ATTEMPTED_USERNAME";

    public void action(AuthenticationFlowContext context) {
    }

    protected Response invalidUser(AuthenticationFlowContext context) {
        return context.form().setError("invalidUserMessage", new Object[0]).createLogin();
    }

    protected Response disabledUser(AuthenticationFlowContext context) {
        return context.form().setError("accountDisabledMessage", new Object[0]).createLogin();
    }

    protected Response temporarilyDisabledUser(AuthenticationFlowContext context) {
        return context.form().setError("invalidUserMessage", new Object[0]).createLogin();
    }

    protected Response invalidCredentials(AuthenticationFlowContext context) {
        return context.form().setError("invalidUserMessage", new Object[0]).createLogin();
    }

    protected Response setDuplicateUserChallenge(AuthenticationFlowContext context, String eventError, String loginFormError, AuthenticationFlowError authenticatorError) {
        context.getEvent().error(eventError);
        Response challengeResponse = context.form().setError(loginFormError, new Object[0]).createLogin();
        context.failureChallenge(authenticatorError, challengeResponse);
        return challengeResponse;
    }

    protected void runDefaultDummyHash(AuthenticationFlowContext context) {
        PasswordHashProvider hash = (PasswordHashProvider)context.getSession().getProvider(PasswordHashProvider.class, "pbkdf2-sha256");
        hash.encode("dummypassword", 27500);
    }

    protected void dummyHash(AuthenticationFlowContext context) {
        PasswordPolicy policy = context.getRealm().getPasswordPolicy();
        if (policy == null) {
            this.runDefaultDummyHash(context);
            return;
        }
        PasswordHashProvider hash = (PasswordHashProvider)context.getSession().getProvider(PasswordHashProvider.class, policy.getHashAlgorithm());
        if (hash == null) {
            this.runDefaultDummyHash(context);
            return;
        }
        hash.encode("dummypassword", policy.getHashIterations());
    }

    public boolean invalidUser(AuthenticationFlowContext context, UserModel user) {
        if (user == null) {
            this.dummyHash(context);
            context.getEvent().error("user_not_found");
            Response challengeResponse = this.invalidUser(context);
            context.failureChallenge(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return true;
        }
        return false;
    }

    public boolean enabledUser(AuthenticationFlowContext context, UserModel user) {
        if (!user.isEnabled()) {
            context.getEvent().user(user);
            context.getEvent().error("user_disabled");
            Response challengeResponse = this.disabledUser(context);
            context.forceChallenge(challengeResponse);
            return false;
        }
        return !this.isTemporarilyDisabledByBruteForce(context, user);
    }

    public boolean validateUserAndPassword(AuthenticationFlowContext context, MultivaluedMap<String, String> inputData) {
        boolean remember;
        String username = (String)inputData.getFirst((Object)"username");
        if (username == null) {
            context.getEvent().error("user_not_found");
            Response challengeResponse = this.invalidUser(context);
            context.failureChallenge(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return false;
        }
        username = username.trim();
        context.getEvent().detail("username", username);
        context.getAuthenticationSession().setAuthNote(ATTEMPTED_USERNAME, username);
        UserModel user = null;
        try {
            user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)context.getSession(), (RealmModel)context.getRealm(), (String)username);
        }
        catch (ModelDuplicateException mde) {
            ServicesLogger.LOGGER.modelDuplicateException(mde);
            if (mde.getDuplicateFieldName() != null && mde.getDuplicateFieldName().equals("email")) {
                this.setDuplicateUserChallenge(context, "email_in_use", "emailExistsMessage", AuthenticationFlowError.INVALID_USER);
            } else {
                this.setDuplicateUserChallenge(context, "username_in_use", "usernameExistsMessage", AuthenticationFlowError.INVALID_USER);
            }
            return false;
        }
        if (this.invalidUser(context, user)) {
            return false;
        }
        if (!this.validatePassword(context, user, inputData)) {
            return false;
        }
        if (!this.enabledUser(context, user)) {
            return false;
        }
        String rememberMe = (String)inputData.getFirst((Object)"rememberMe");
        boolean bl = remember = rememberMe != null && rememberMe.equalsIgnoreCase("on");
        if (remember) {
            context.getAuthenticationSession().setAuthNote("remember_me", "true");
            context.getEvent().detail("remember_me", "true");
        } else {
            context.getAuthenticationSession().removeAuthNote("remember_me");
        }
        context.setUser(user);
        return true;
    }

    public boolean validatePassword(AuthenticationFlowContext context, UserModel user, MultivaluedMap<String, String> inputData) {
        LinkedList<PasswordUserCredentialModel> credentials = new LinkedList<PasswordUserCredentialModel>();
        String password = (String)inputData.getFirst((Object)"password");
        credentials.add(UserCredentialModel.password((String)password));
        if (this.isTemporarilyDisabledByBruteForce(context, user)) {
            return false;
        }
        if (password != null && !password.isEmpty() && context.getSession().userCredentialManager().isValid(context.getRealm(), user, credentials)) {
            return true;
        }
        context.getEvent().user(user);
        context.getEvent().error("invalid_user_credentials");
        Response challengeResponse = this.invalidCredentials(context);
        context.failureChallenge(AuthenticationFlowError.INVALID_CREDENTIALS, challengeResponse);
        context.clearUser();
        return false;
    }

    private boolean isTemporarilyDisabledByBruteForce(AuthenticationFlowContext context, UserModel user) {
        if (context.getRealm().isBruteForceProtected() && context.getProtector().isTemporarilyDisabled(context.getSession(), context.getRealm(), user)) {
            context.getEvent().user(user);
            context.getEvent().error("user_temporarily_disabled");
            Response challengeResponse = this.temporarilyDisabledUser(context);
            context.forceChallenge(challengeResponse);
            return true;
        }
        return false;
    }
}

