/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.challenge;

import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.browser.AbstractUsernameFormAuthenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.util.BasicAuthHelper;

public class BasicAuthAuthenticator
extends AbstractUsernameFormAuthenticator
implements Authenticator {
    public boolean requiresUser() {
        return false;
    }

    public void authenticate(AuthenticationFlowContext context) {
        String authorizationHeader = this.getAuthorizationHeader(context);
        if (authorizationHeader == null) {
            context.challenge(this.challengeResponse(context));
            return;
        }
        String[] challenge = this.getChallenge(authorizationHeader);
        if (challenge == null) {
            context.challenge(this.challengeResponse(context));
            return;
        }
        if (this.onAuthenticate(context, challenge)) {
            context.success();
            return;
        }
        context.setUser(null);
        context.challenge(this.challengeResponse(context));
    }

    protected boolean onAuthenticate(AuthenticationFlowContext context, String[] challenge) {
        return this.checkUsernameAndPassword(context, challenge[0], challenge[1]);
    }

    protected String getAuthorizationHeader(AuthenticationFlowContext context) {
        return (String)context.getHttpRequest().getHttpHeaders().getRequestHeaders().getFirst((Object)"Authorization");
    }

    protected boolean checkUsernameAndPassword(AuthenticationFlowContext context, String username, String password) {
        MultivaluedHashMap map = new MultivaluedHashMap();
        map.putSingle((Object)"username", (Object)username);
        map.putSingle((Object)"password", (Object)password);
        return this.validateUserAndPassword(context, (MultivaluedMap<String, String>)map);
    }

    protected String[] getChallenge(String authorizationHeader) {
        String[] challenge = BasicAuthHelper.parseHeader((String)authorizationHeader);
        if (challenge.length < 2) {
            return null;
        }
        return challenge;
    }

    @Override
    protected Response invalidUser(AuthenticationFlowContext context) {
        return this.challengeResponse(context);
    }

    @Override
    protected Response disabledUser(AuthenticationFlowContext context) {
        return this.challengeResponse(context);
    }

    @Override
    protected Response temporarilyDisabledUser(AuthenticationFlowContext context) {
        return this.challengeResponse(context);
    }

    @Override
    protected Response invalidCredentials(AuthenticationFlowContext context) {
        return this.challengeResponse(context);
    }

    @Override
    protected Response setDuplicateUserChallenge(AuthenticationFlowContext context, String eventError, String loginFormError, AuthenticationFlowError authenticatorError) {
        return this.challengeResponse(context);
    }

    @Override
    public void action(AuthenticationFlowContext context) {
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    @Override
    public void close() {
    }

    private Response challengeResponse(AuthenticationFlowContext context) {
        return Response.status((int)401).header("WWW-Authenticate", (Object)this.getHeader(context)).build();
    }

    private String getHeader(AuthenticationFlowContext context) {
        return "Basic realm=\"" + context.getRealm().getName() + "\"";
    }
}

