/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.authorization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.OAuthErrorException;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.common.KeycloakEvaluationContext;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.PermissionTicketAwareDecisionResultCollector;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.util.Permissions;
import org.keycloak.authorization.util.Tokens;
import org.keycloak.common.util.Base64Url;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PermissionTicketToken;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.util.DefaultClientSessionContext;
import org.keycloak.util.JsonSerialization;

public class AuthorizationTokenService {
    public static final String CLAIM_TOKEN_FORMAT_ID_TOKEN = "http://openid.net/specs/openid-connect-core-1_0.html#IDToken";
    private static final Logger logger = Logger.getLogger(AuthorizationTokenService.class);
    private static final String RESPONSE_MODE_DECISION = "decision";
    private static final String RESPONSE_MODE_PERMISSIONS = "permissions";
    private static final String RESPONSE_MODE_DECISION_RESULT = "result";
    private static Map<String, BiFunction<AuthorizationRequest, AuthorizationProvider, KeycloakEvaluationContext>> SUPPORTED_CLAIM_TOKEN_FORMATS = new HashMap<String, BiFunction<AuthorizationRequest, AuthorizationProvider, KeycloakEvaluationContext>>();
    private static final AuthorizationTokenService INSTANCE;

    public static AuthorizationTokenService instance() {
        return INSTANCE;
    }

    public Response authorize(KeycloakAuthorizationRequest request) {
        if (request == null) {
            throw new CorsErrorResponseException(request.getCors(), "invalid_grant", "Invalid authorization request.", Response.Status.BAD_REQUEST);
        }
        if (this.isPublicClientRequestingEntitlementWithClaims(request)) {
            throw new CorsErrorResponseException(request.getCors(), "invalid_grant", "Public clients are not allowed to send claims", Response.Status.FORBIDDEN);
        }
        try {
            PermissionTicketToken ticket = this.getPermissionTicket(request);
            request.setClaims(ticket.getClaims());
            ResourceServer resourceServer = this.getResourceServer(ticket, request);
            KeycloakEvaluationContext evaluationContext = this.createEvaluationContext(request);
            KeycloakIdentity identity = (KeycloakIdentity)KeycloakIdentity.class.cast(evaluationContext.getIdentity());
            Collection<Permission> permissions = request.getTicket() != null ? this.evaluateUserManagedPermissions(request, ticket, resourceServer, evaluationContext, identity) : (ticket.getPermissions().isEmpty() && request.getRpt() == null ? this.evaluateAllPermissions(request, resourceServer, evaluationContext, identity) : this.evaluatePermissions(request, ticket, resourceServer, evaluationContext, identity));
            if (this.isGranted(ticket, request, permissions)) {
                String responseMode;
                AuthorizationProvider authorization = request.getAuthorization();
                ClientModel targetClient = authorization.getRealm().getClientById(resourceServer.getId());
                AuthorizationRequest.Metadata metadata = request.getMetadata();
                String string = responseMode = metadata != null ? metadata.getResponseMode() : null;
                if (responseMode != null) {
                    if (RESPONSE_MODE_DECISION.equals(metadata.getResponseMode())) {
                        HashMap<String, Boolean> responseClaims = new HashMap<String, Boolean>();
                        responseClaims.put(RESPONSE_MODE_DECISION_RESULT, true);
                        return this.createSuccessfulResponse(responseClaims, request);
                    }
                    if (RESPONSE_MODE_PERMISSIONS.equals(metadata.getResponseMode())) {
                        return this.createSuccessfulResponse(permissions, request);
                    }
                    throw new CorsErrorResponseException(request.getCors(), "invalid_request", "Invalid response_mode", Response.Status.BAD_REQUEST);
                }
                return this.createSuccessfulResponse(this.createAuthorizationResponse(identity, permissions, request, targetClient), request);
            }
            if (request.isSubmitRequest()) {
                throw new CorsErrorResponseException(request.getCors(), "access_denied", "request_submitted", Response.Status.FORBIDDEN);
            }
            throw new CorsErrorResponseException(request.getCors(), "access_denied", "not_authorized", Response.Status.FORBIDDEN);
        }
        catch (CorsErrorResponseException | ErrorResponseException cause) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error while evaluating permissions", (Throwable)cause);
            }
            throw cause;
        }
        catch (Exception cause) {
            logger.error((Object)"Unexpected error while evaluating permissions", (Throwable)cause);
            throw new CorsErrorResponseException(request.getCors(), "server_error", "Unexpected error while evaluating permissions", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response createSuccessfulResponse(Object response, KeycloakAuthorizationRequest request) {
        return Cors.add(request.getHttpRequest(), Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response)).allowedOrigins((UriInfo)request.getKeycloakSession().getContext().getUri(), request.getKeycloakSession().getContext().getClient()).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    private boolean isPublicClientRequestingEntitlementWithClaims(KeycloakAuthorizationRequest request) {
        return request.getClaimToken() != null && request.getKeycloakSession().getContext().getClient().isPublicClient() && request.getTicket() == null;
    }

    private Collection<Permission> evaluatePermissions(KeycloakAuthorizationRequest request, PermissionTicketToken ticket, ResourceServer resourceServer, KeycloakEvaluationContext evaluationContext, KeycloakIdentity identity) {
        AuthorizationProvider authorization = request.getAuthorization();
        return authorization.evaluators().from(this.createPermissions(ticket, request, resourceServer, identity, authorization), (EvaluationContext)evaluationContext).evaluate(resourceServer, (AuthorizationRequest)request);
    }

    private Collection<Permission> evaluateUserManagedPermissions(KeycloakAuthorizationRequest request, PermissionTicketToken ticket, ResourceServer resourceServer, KeycloakEvaluationContext evaluationContext, KeycloakIdentity identity) {
        AuthorizationProvider authorization = request.getAuthorization();
        return ((PermissionTicketAwareDecisionResultCollector)authorization.evaluators().from(this.createPermissions(ticket, request, resourceServer, identity, authorization), (EvaluationContext)evaluationContext).evaluate((Decision)new PermissionTicketAwareDecisionResultCollector((AuthorizationRequest)request, ticket, (Identity)identity, resourceServer, authorization))).results();
    }

    private Collection<Permission> evaluateAllPermissions(KeycloakAuthorizationRequest request, ResourceServer resourceServer, KeycloakEvaluationContext evaluationContext, KeycloakIdentity identity) {
        AuthorizationProvider authorization = request.getAuthorization();
        return authorization.evaluators().from(Permissions.all(resourceServer, identity, authorization, request), (EvaluationContext)evaluationContext).evaluate(resourceServer, (AuthorizationRequest)request);
    }

    private AuthorizationResponse createAuthorizationResponse(KeycloakIdentity identity, Collection<Permission> entitlements, KeycloakAuthorizationRequest request, ClientModel targetClient) {
        KeycloakSession keycloakSession = request.getKeycloakSession();
        AccessToken accessToken = identity.getAccessToken();
        RealmModel realm = request.getRealm();
        UserSessionProvider sessions = keycloakSession.sessions();
        UserSessionModel userSessionModel = sessions.getUserSession(realm, accessToken.getSessionState());
        if (userSessionModel == null) {
            userSessionModel = sessions.getOfflineUserSession(realm, accessToken.getSessionState());
        }
        ClientModel client = realm.getClientByClientId(accessToken.getIssuedFor());
        AuthenticatedClientSessionModel clientSession = userSessionModel.getAuthenticatedClientSessionByClient(client.getId());
        DefaultClientSessionContext clientSessionCtx = DefaultClientSessionContext.fromClientSessionScopeParameter(clientSession);
        TokenManager tokenManager = request.getTokenManager();
        EventBuilder event = request.getEvent();
        TokenManager.AccessTokenResponseBuilder responseBuilder = tokenManager.responseBuilder(realm, clientSession.getClient(), event, keycloakSession, userSessionModel, clientSessionCtx).generateAccessToken().generateRefreshToken();
        AccessToken rpt = responseBuilder.getAccessToken();
        rpt.issuedFor(client.getClientId());
        AccessToken.Authorization authorization = new AccessToken.Authorization();
        authorization.setPermissions(entitlements);
        rpt.setAuthorization(authorization);
        RefreshToken refreshToken = responseBuilder.getRefreshToken();
        refreshToken.issuedFor(client.getClientId());
        refreshToken.setAuthorization(authorization);
        if (!rpt.hasAudience(targetClient.getClientId())) {
            rpt.audience(new String[]{targetClient.getClientId()});
        }
        return new AuthorizationResponse(responseBuilder.build(), this.isUpgraded(request, authorization));
    }

    private boolean isUpgraded(AuthorizationRequest request, AccessToken.Authorization authorization) {
        Collection previousPermissions;
        AccessToken previousRpt = request.getRpt();
        if (previousRpt == null) {
            return false;
        }
        AccessToken.Authorization previousAuthorization = previousRpt.getAuthorization();
        if (previousAuthorization != null && (previousPermissions = previousAuthorization.getPermissions()) != null) {
            for (Permission previousPermission : previousPermissions) {
                if (authorization.getPermissions().contains(previousPermission)) continue;
                return false;
            }
        }
        return true;
    }

    private PermissionTicketToken getPermissionTicket(KeycloakAuthorizationRequest request) {
        if (request.getTicket() != null) {
            return this.verifyPermissionTicket(request);
        }
        PermissionTicketToken permissions = request.getPermissions();
        permissions.audience(new String[]{request.getAudience()});
        return permissions;
    }

    private ResourceServer getResourceServer(PermissionTicketToken ticket, KeycloakAuthorizationRequest request) {
        AuthorizationProvider authorization = request.getAuthorization();
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServerStore resourceServerStore = storeFactory.getResourceServerStore();
        String[] audience = ticket.getAudience();
        if (audience == null || audience.length == 0) {
            throw new CorsErrorResponseException(request.getCors(), "invalid_request", "You must provide the audience", Response.Status.BAD_REQUEST);
        }
        ClientModel clientModel = request.getRealm().getClientByClientId(audience[0]);
        if (clientModel == null) {
            throw new CorsErrorResponseException(request.getCors(), "invalid_request", "Unknown resource server id.", Response.Status.BAD_REQUEST);
        }
        ResourceServer resourceServer = resourceServerStore.findById(clientModel.getId());
        if (resourceServer == null) {
            throw new CorsErrorResponseException(request.getCors(), "invalid_request", "Client does not support permissions", Response.Status.BAD_REQUEST);
        }
        return resourceServer;
    }

    private KeycloakEvaluationContext createEvaluationContext(KeycloakAuthorizationRequest request) {
        BiFunction<AuthorizationRequest, AuthorizationProvider, KeycloakEvaluationContext> evaluationContextProvider;
        String claimTokenFormat = request.getClaimTokenFormat();
        if (claimTokenFormat == null) {
            claimTokenFormat = CLAIM_TOKEN_FORMAT_ID_TOKEN;
        }
        if ((evaluationContextProvider = SUPPORTED_CLAIM_TOKEN_FORMATS.get(claimTokenFormat)) == null) {
            throw new CorsErrorResponseException(request.getCors(), "invalid_request", "Claim token format [" + claimTokenFormat + "] not supported", Response.Status.BAD_REQUEST);
        }
        return evaluationContextProvider.apply(request, request.getAuthorization());
    }

    private Collection<ResourcePermission> createPermissions(PermissionTicketToken ticket, KeycloakAuthorizationRequest request, ResourceServer resourceServer, KeycloakIdentity identity, AuthorizationProvider authorization) {
        Collection permissions;
        AccessToken.Authorization authorizationData;
        AccessToken rpt;
        StoreFactory storeFactory = authorization.getStoreFactory();
        LinkedHashMap<String, ResourcePermission> permissionsToEvaluate = new LinkedHashMap<String, ResourcePermission>();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        ScopeStore scopeStore = storeFactory.getScopeStore();
        AuthorizationRequest.Metadata metadata = request.getMetadata();
        AtomicInteger limit = metadata != null && metadata.getLimit() != null ? new AtomicInteger(metadata.getLimit()) : null;
        block0: for (Permission permission : ticket.getPermissions()) {
            String clientAdditionalScopes;
            if (limit != null && limit.get() <= 0) break;
            HashSet<String> requestedScopes = permission.getScopes();
            if (permission.getScopes() == null) {
                requestedScopes = new HashSet<String>();
            }
            ArrayList<Resource> requestedResources = new ArrayList<Resource>();
            String resourceId = permission.getResourceId();
            if (resourceId != null) {
                Resource resource2 = null;
                if (resourceId.indexOf(45) != -1) {
                    resource2 = resourceStore.findById(resourceId, resourceServer.getId());
                }
                if (resource2 != null) {
                    requestedResources.add(resource2);
                } else {
                    Resource resource3;
                    String resourceName = resourceId;
                    Resource ownerResource = resourceStore.findByName(resourceName, identity.getId(), resourceServer.getId());
                    if (ownerResource != null) {
                        permission.setResourceId(ownerResource.getId());
                        requestedResources.add(ownerResource);
                    }
                    if (!identity.isResourceServer() && (resource3 = resourceStore.findByName(resourceName, resourceServer.getId())) != null) {
                        permission.setResourceId(resource3.getId());
                        requestedResources.add(resource3);
                    }
                }
            }
            if ((clientAdditionalScopes = request.getScope()) != null) {
                requestedScopes.addAll(Arrays.asList(clientAdditionalScopes.split(" ")));
            }
            Set<Scope> requestedScopesModel = requestedScopes.stream().map(s -> scopeStore.findByName(s, resourceServer.getId())).filter(Objects::nonNull).collect(Collectors.toSet());
            if (resourceId != null && requestedResources.isEmpty()) {
                throw new CorsErrorResponseException(request.getCors(), "invalid_resource", "Resource with id [" + resourceId + "] does not exist.", Response.Status.BAD_REQUEST);
            }
            if (!requestedScopes.isEmpty() && requestedScopesModel.isEmpty()) {
                throw new CorsErrorResponseException(request.getCors(), "invalid_scope", "One of the given scopes " + permission.getScopes() + " is invalid", Response.Status.BAD_REQUEST);
            }
            if (!requestedResources.isEmpty()) {
                for (Resource resource4 : requestedResources) {
                    if (limit != null && limit.get() <= 0) continue block0;
                    ResourcePermission perm = (ResourcePermission)permissionsToEvaluate.get(resource4.getId());
                    if (perm == null) {
                        perm = Permissions.createResourcePermissions(resource4, requestedScopesModel, authorization, request);
                        permissionsToEvaluate.put(resource4.getId(), perm);
                        if (limit == null) continue;
                        limit.decrementAndGet();
                        continue;
                    }
                    for (Scope scope2 : requestedScopesModel) {
                        perm.addScope(scope2);
                    }
                }
                continue;
            }
            AtomicBoolean processed = new AtomicBoolean();
            resourceStore.findByScope(requestedScopesModel.stream().map(Scope::getId).collect(Collectors.toList()), resourceServer.getId(), resource -> {
                if (limit != null && limit.get() <= 0) {
                    return;
                }
                ResourcePermission perm = (ResourcePermission)permissionsToEvaluate.get(resource.getId());
                if (perm == null) {
                    perm = Permissions.createResourcePermissions(resource, requestedScopesModel, authorization, request);
                    permissionsToEvaluate.put(resource.getId(), perm);
                    if (limit != null) {
                        limit.decrementAndGet();
                    }
                } else {
                    for (Scope scope : requestedScopesModel) {
                        perm.addScope(scope);
                    }
                }
                processed.compareAndSet(false, true);
            });
            if (processed.get()) continue;
            for (Scope scope : requestedScopesModel) {
                if (limit != null && limit.getAndDecrement() <= 0) continue block0;
                permissionsToEvaluate.computeIfAbsent(scope.getId(), s -> new ResourcePermission(null, new ArrayList<Scope>(Arrays.asList(scope)), resourceServer, request.getClaims()));
            }
        }
        if ((rpt = request.getRpt()) != null && rpt.isActive() && (authorizationData = rpt.getAuthorization()) != null && (permissions = authorizationData.getPermissions()) != null) {
            for (Permission grantedPermission : permissions) {
                if (limit != null && limit.get() <= 0) break;
                Resource resource5 = resourceStore.findById(grantedPermission.getResourceId(), ticket.getAudience()[0]);
                if (resource5 == null) continue;
                ResourcePermission permission = (ResourcePermission)permissionsToEvaluate.get(resource5.getId());
                if (permission == null) {
                    permission = new ResourcePermission(resource5, new ArrayList(), resourceServer, grantedPermission.getClaims());
                    permissionsToEvaluate.put(resource5.getId(), permission);
                    if (limit != null) {
                        limit.decrementAndGet();
                    }
                } else if (grantedPermission.getClaims() != null) {
                    for (Map.Entry entry : grantedPermission.getClaims().entrySet()) {
                        Set claims = (Set)permission.getClaims().get(entry.getKey());
                        if (claims == null) continue;
                        claims.addAll((Collection)entry.getValue());
                    }
                }
                for (String string : grantedPermission.getScopes()) {
                    Scope scope;
                    scope = scopeStore.findByName(string, resourceServer.getId());
                    if (scope == null || permission.getScopes().contains(scope)) continue;
                    permission.getScopes().add(scope);
                }
            }
        }
        return permissionsToEvaluate.values();
    }

    private PermissionTicketToken verifyPermissionTicket(KeycloakAuthorizationRequest request) {
        String ticketString = request.getTicket();
        PermissionTicketToken ticket = (PermissionTicketToken)request.getKeycloakSession().tokens().decode(ticketString, PermissionTicketToken.class);
        if (ticket == null) {
            throw new CorsErrorResponseException(request.getCors(), "invalid_ticket", "Ticket verification failed", Response.Status.FORBIDDEN);
        }
        if (!ticket.isActive()) {
            throw new CorsErrorResponseException(request.getCors(), "invalid_ticket", "Invalid permission ticket.", Response.Status.FORBIDDEN);
        }
        return ticket;
    }

    private boolean isGranted(PermissionTicketToken ticket, AuthorizationRequest request, Collection<Permission> permissions) {
        List requestedPermissions = ticket.getPermissions();
        if (request.getRpt() != null && !requestedPermissions.isEmpty() && requestedPermissions.stream().anyMatch(permission -> !permissions.contains(permission))) {
            return false;
        }
        return !permissions.isEmpty();
    }

    static {
        SUPPORTED_CLAIM_TOKEN_FORMATS.put("urn:ietf:params:oauth:token-type:jwt", (authorizationRequest, authorization) -> {
            String claimToken = authorizationRequest.getClaimToken();
            if (claimToken != null) {
                try {
                    Map claims = (Map)JsonSerialization.readValue((byte[])Base64Url.decode((String)authorizationRequest.getClaimToken()), Map.class);
                    authorizationRequest.setClaims(claims);
                    return new KeycloakEvaluationContext(new KeycloakIdentity(authorization.getKeycloakSession(), (IDToken)Tokens.getAccessToken(authorizationRequest.getSubjectToken(), authorization.getKeycloakSession())), (Map<String, List<String>>)claims, authorization.getKeycloakSession());
                }
                catch (IOException cause) {
                    throw new RuntimeException("Failed to map claims from claim token [" + claimToken + "]", cause);
                }
            }
            throw new RuntimeException("Claim token can not be null");
        });
        SUPPORTED_CLAIM_TOKEN_FORMATS.put(CLAIM_TOKEN_FORMAT_ID_TOKEN, (authorizationRequest, authorization) -> {
            try {
                KeycloakSession keycloakSession = authorization.getKeycloakSession();
                RealmModel realm = authorization.getRealm();
                String accessToken = authorizationRequest.getSubjectToken();
                if (accessToken == null) {
                    throw new RuntimeException("Claim token can not be null and must be a valid IDToken");
                }
                IDToken idToken = new TokenManager().verifyIDTokenSignature(keycloakSession, accessToken);
                return new KeycloakEvaluationContext(new KeycloakIdentity(keycloakSession, idToken), (Map<String, List<String>>)authorizationRequest.getClaims(), keycloakSession);
            }
            catch (OAuthErrorException cause) {
                throw new RuntimeException("Failed to verify ID token", cause);
            }
        });
        INSTANCE = new AuthorizationTokenService();
    }

    public static class KeycloakAuthorizationRequest
    extends AuthorizationRequest {
        private final AuthorizationProvider authorization;
        private final TokenManager tokenManager;
        private final EventBuilder event;
        private final HttpRequest httpRequest;
        private final Cors cors;

        public KeycloakAuthorizationRequest(AuthorizationProvider authorization, TokenManager tokenManager, EventBuilder event, HttpRequest request, Cors cors) {
            this.authorization = authorization;
            this.tokenManager = tokenManager;
            this.event = event;
            this.httpRequest = request;
            this.cors = cors;
        }

        TokenManager getTokenManager() {
            return this.tokenManager;
        }

        EventBuilder getEvent() {
            return this.event;
        }

        HttpRequest getHttpRequest() {
            return this.httpRequest;
        }

        AuthorizationProvider getAuthorization() {
            return this.authorization;
        }

        Cors getCors() {
            return this.cors;
        }

        KeycloakSession getKeycloakSession() {
            return this.getAuthorization().getKeycloakSession();
        }

        RealmModel getRealm() {
            return this.getKeycloakSession().getContext().getRealm();
        }
    }
}

