/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.openshift;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.keycloak.TokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.ext.OIDCExtProvider;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.protocol.openshift.OpenShiftTokenReviewRequestRepresentation;
import org.keycloak.protocol.openshift.OpenShiftTokenReviewResponseRepresentation;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.Urls;

public class OpenShiftTokenReviewEndpoint
implements OIDCExtProvider {
    private KeycloakSession session;
    private TokenManager tokenManager;
    private EventBuilder event;

    public OpenShiftTokenReviewEndpoint(KeycloakSession session) {
        this.session = session;
        this.tokenManager = new TokenManager();
    }

    @Override
    public void setEvent(EventBuilder event) {
        this.event = event;
    }

    @Path(value="/")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response tokenReview(OpenShiftTokenReviewRequestRepresentation reviewRequest) throws Exception {
        return this.tokenReview(null, reviewRequest);
    }

    @Path(value="/{client_id}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response tokenReview(@PathParam(value="client_id") String clientId, OpenShiftTokenReviewRequestRepresentation reviewRequest) throws Exception {
        this.event.event(EventType.INTROSPECT_TOKEN);
        if (clientId != null) {
            this.session.setAttribute("client_id", (Object)clientId);
        }
        this.checkSsl();
        this.checkRealm();
        this.authorizeClient();
        RealmModel realm = this.session.getContext().getRealm();
        AccessToken token = null;
        try {
            TokenVerifier verifier = TokenVerifier.create((String)reviewRequest.getSpec().getToken(), AccessToken.class).realmUrl(Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), realm.getName()));
            SignatureVerifierContext verifierContext = ((SignatureProvider)this.session.getProvider(SignatureProvider.class, verifier.getHeader().getAlgorithm().name())).verifier(verifier.getHeader().getKeyId());
            verifier.verifierContext(verifierContext);
            verifier.verify();
            token = (AccessToken)verifier.getToken();
        }
        catch (VerificationException e) {
            this.error(401, "invalid_token", "Token verification failure");
        }
        if (!this.tokenManager.checkTokenValidForIntrospection(this.session, realm, token)) {
            this.error(401, "invalid_token", "Token verification failure");
        }
        OpenShiftTokenReviewResponseRepresentation response = new OpenShiftTokenReviewResponseRepresentation();
        response.getStatus().setAuthenticated(true);
        response.getStatus().setUser(new OpenShiftTokenReviewResponseRepresentation.User());
        OpenShiftTokenReviewResponseRepresentation.User userRep = response.getStatus().getUser();
        userRep.setUid(token.getSubject());
        userRep.setUsername(token.getPreferredUsername());
        if (token.getScope() != null && !token.getScope().isEmpty()) {
            OpenShiftTokenReviewResponseRepresentation.Extra extra = new OpenShiftTokenReviewResponseRepresentation.Extra();
            extra.setScopes(token.getScope().split(" "));
            userRep.setExtra(extra);
        }
        if (token.getOtherClaims() != null && token.getOtherClaims().get("groups") != null) {
            List groups = (List)token.getOtherClaims().get("groups");
            userRep.setGroups(groups);
        }
        this.event.success();
        return Response.ok((Object)response, (String)"application/json").build();
    }

    private void checkSsl() {
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && this.session.getContext().getRealm().getSslRequired().isRequired(this.session.getContext().getConnection())) {
            this.error(401, "ssl_required", null);
        }
    }

    private void checkRealm() {
        if (!this.session.getContext().getRealm().isEnabled()) {
            this.error(401, "realm_disabled", null);
        }
    }

    private void authorizeClient() {
        try {
            ClientModel client = AuthorizeClientUtil.authorizeClient(this.session, this.event).getClient();
            this.event.client(client);
            if (client == null || client.isPublicClient()) {
                this.error(401, "invalid_client", "Public client is not permitted to invoke token review endpoint");
            }
        }
        catch (ErrorResponseException ere) {
            this.error(401, "invalid_client_credentials", ere.getErrorDescription());
        }
        catch (Exception e) {
            this.error(401, "invalid_client_credentials", null);
        }
    }

    private void error(int statusCode, String error, String description) {
        OpenShiftTokenReviewResponseRepresentation rep = new OpenShiftTokenReviewResponseRepresentation();
        rep.getStatus().setAuthenticated(false);
        Response response = Response.status((int)statusCode).entity((Object)rep).type(MediaType.APPLICATION_JSON_TYPE).build();
        this.event.error(error);
        this.event.detail("reason", description);
        throw new ErrorResponseException(response);
    }
}

