/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ScopeMappedResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ScopeMappedClientResource {
    protected RealmModel realm;
    protected AdminPermissionEvaluator auth;
    protected AdminPermissionEvaluator.RequirePermissionCheck managePermission;
    protected AdminPermissionEvaluator.RequirePermissionCheck viewPermission;
    protected ScopeContainerModel scopeContainer;
    protected KeycloakSession session;
    protected ClientModel scopedClient;
    protected AdminEventBuilder adminEvent;

    public ScopeMappedClientResource(RealmModel realm, AdminPermissionEvaluator auth, ScopeContainerModel scopeContainer, KeycloakSession session, ClientModel scopedClient, AdminEventBuilder adminEvent, AdminPermissionEvaluator.RequirePermissionCheck managePermission, AdminPermissionEvaluator.RequirePermissionCheck viewPermission) {
        this.realm = realm;
        this.auth = auth;
        this.scopeContainer = scopeContainer;
        this.session = session;
        this.scopedClient = scopedClient;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT_SCOPE_MAPPING);
        this.managePermission = managePermission;
        this.viewPermission = viewPermission;
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getClientScopeMappings() {
        this.viewPermission.require();
        Set mappings = KeycloakModelUtils.getClientScopeMappings((ClientModel)this.scopedClient, (ScopeContainerModel)this.scopeContainer);
        ArrayList<RoleRepresentation> mapRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : mappings) {
            mapRep.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
        }
        return mapRep;
    }

    @Path(value="available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getAvailableClientScopeMappings() {
        this.viewPermission.require();
        Set roles = this.scopedClient.getRoles();
        return ScopeMappedResource.getAvailable(this.auth, this.scopeContainer, roles);
    }

    @Path(value="composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getCompositeClientScopeMappings() {
        this.viewPermission.require();
        Set roles = this.scopedClient.getRoles();
        return ScopeMappedResource.getComposite(this.scopeContainer, roles);
    }

    @POST
    @Consumes(value={"application/json"})
    public void addClientScopeMapping(List<RoleRepresentation> roles) {
        this.managePermission.require();
        for (RoleRepresentation role : roles) {
            RoleModel roleModel = this.scopedClient.getRole(role.getName());
            if (roleModel == null) {
                throw new NotFoundException("Role not found");
            }
            this.scopeContainer.addScopeMapping(roleModel);
        }
        this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(roles).success();
    }

    @DELETE
    @Consumes(value={"application/json"})
    public void deleteClientScopeMapping(List<RoleRepresentation> roles) {
        this.managePermission.require();
        if (roles == null) {
            Set roleModels = KeycloakModelUtils.getClientScopeMappings((ClientModel)this.scopedClient, (ScopeContainerModel)this.scopeContainer);
            roles = new LinkedList<RoleRepresentation>();
            for (RoleModel roleModel : roleModels) {
                this.scopeContainer.deleteScopeMapping(roleModel);
                roles.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
            }
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.scopedClient.getRole(role.getName());
                if (roleModel == null) {
                    throw new NotFoundException("Role not found");
                }
                this.scopeContainer.deleteScopeMapping(roleModel);
            }
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(roles).success();
    }
}

