/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jws;

import org.jboss.logging.Logger;
import org.keycloak.Token;
import org.keycloak.TokenCategory;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.TokenManager;

public class DefaultTokenManager
implements TokenManager {
    private static final Logger logger = Logger.getLogger(DefaultTokenManager.class);
    private static String DEFAULT_ALGORITHM_NAME = "RS256";
    private final KeycloakSession session;

    public DefaultTokenManager(KeycloakSession session) {
        this.session = session;
    }

    public String encode(Token token) {
        String signatureAlgorithm = this.signatureAlgorithm(token.getCategory());
        SignatureProvider signatureProvider = (SignatureProvider)this.session.getProvider(SignatureProvider.class, signatureAlgorithm);
        SignatureSignerContext signer = signatureProvider.signer();
        String encodedToken = new JWSBuilder().type("JWT").jsonContent((Object)token).sign(signer);
        return encodedToken;
    }

    public <T extends Token> T decode(String token, Class<T> clazz) {
        if (token == null) {
            return null;
        }
        try {
            boolean valid;
            JWSInput jws = new JWSInput(token);
            String signatureAlgorithm = jws.getHeader().getAlgorithm().name();
            SignatureProvider signatureProvider = (SignatureProvider)this.session.getProvider(SignatureProvider.class, signatureAlgorithm);
            if (signatureProvider == null) {
                return null;
            }
            String kid = jws.getHeader().getKeyId();
            if (kid == null) {
                logger.debugf("KID is null in token. Using the realm active key to verify token signature.", new Object[0]);
                kid = this.session.keys().getActiveKey(this.session.getContext().getRealm(), KeyUse.SIG, signatureAlgorithm).getKid();
            }
            return (T)((valid = signatureProvider.verifier(kid).verify(jws.getEncodedSignatureInput().getBytes("UTF-8"), jws.getSignature())) ? (Token)jws.readJsonContent(clazz) : null);
        }
        catch (Exception e) {
            logger.debug((Object)"Failed to decode token", (Throwable)e);
            return null;
        }
    }

    public String signatureAlgorithm(TokenCategory category) {
        switch (category) {
            case INTERNAL: {
                return "HS256";
            }
            case ADMIN: {
                return this.getSignatureAlgorithm(null);
            }
            case ACCESS: {
                return this.getSignatureAlgorithm("access.token.signed.response.alg");
            }
            case ID: {
                return this.getSignatureAlgorithm("id.token.signed.response.alg");
            }
            case USERINFO: {
                return this.getSignatureAlgorithm("user.info.response.signature.alg");
            }
        }
        throw new RuntimeException("Unknown token type");
    }

    private String getSignatureAlgorithm(String clientAttribute) {
        String algorithm;
        RealmModel realm = this.session.getContext().getRealm();
        ClientModel client = this.session.getContext().getClient();
        String string = algorithm = client != null && clientAttribute != null ? client.getAttribute(clientAttribute) : null;
        if (algorithm != null && !algorithm.equals("")) {
            return algorithm;
        }
        algorithm = realm.getDefaultSignatureAlgorithm();
        if (algorithm != null && !algorithm.equals("")) {
            return algorithm;
        }
        return DEFAULT_ALGORITHM_NAME;
    }
}

