/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.common.util.UriUtils;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.DefaultClientScopes;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.AbstractLoginProtocolFactory;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.OIDCLoginProtocol;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.mappers.AddressMapper;
import org.keycloak.protocol.oidc.mappers.AllowedWebOriginsProtocolMapper;
import org.keycloak.protocol.oidc.mappers.AudienceResolveProtocolMapper;
import org.keycloak.protocol.oidc.mappers.FullNameMapper;
import org.keycloak.protocol.oidc.mappers.UserAttributeMapper;
import org.keycloak.protocol.oidc.mappers.UserClientRoleMappingMapper;
import org.keycloak.protocol.oidc.mappers.UserPropertyMapper;
import org.keycloak.protocol.oidc.mappers.UserRealmRoleMappingMapper;
import org.keycloak.protocol.oidc.mappers.UserSessionNoteMapper;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.ServicesLogger;

public class OIDCLoginProtocolFactory
extends AbstractLoginProtocolFactory {
    private static final Logger logger = Logger.getLogger(OIDCLoginProtocolFactory.class);
    public static final String USERNAME = "username";
    public static final String EMAIL = "email";
    public static final String EMAIL_VERIFIED = "email verified";
    public static final String GIVEN_NAME = "given name";
    public static final String FAMILY_NAME = "family name";
    public static final String MIDDLE_NAME = "middle name";
    public static final String NICKNAME = "nickname";
    public static final String PROFILE_CLAIM = "profile";
    public static final String PICTURE = "picture";
    public static final String WEBSITE = "website";
    public static final String GENDER = "gender";
    public static final String BIRTHDATE = "birthdate";
    public static final String ZONEINFO = "zoneinfo";
    public static final String UPDATED_AT = "updated at";
    public static final String FULL_NAME = "full name";
    public static final String LOCALE = "locale";
    public static final String ADDRESS = "address";
    public static final String PHONE_NUMBER = "phone number";
    public static final String PHONE_NUMBER_VERIFIED = "phone number verified";
    public static final String REALM_ROLES = "realm roles";
    public static final String CLIENT_ROLES = "client roles";
    public static final String AUDIENCE_RESOLVE = "audience resolve";
    public static final String ALLOWED_WEB_ORIGINS = "allowed web origins";
    public static final String ROLES_SCOPE = "roles";
    public static final String WEB_ORIGINS_SCOPE = "web-origins";
    public static final String PROFILE_SCOPE_CONSENT_TEXT = "${profileScopeConsentText}";
    public static final String EMAIL_SCOPE_CONSENT_TEXT = "${emailScopeConsentText}";
    public static final String ADDRESS_SCOPE_CONSENT_TEXT = "${addressScopeConsentText}";
    public static final String PHONE_SCOPE_CONSENT_TEXT = "${phoneScopeConsentText}";
    public static final String OFFLINE_ACCESS_SCOPE_CONSENT_TEXT = "${offlineAccessScopeConsentText}";
    public static final String ROLES_SCOPE_CONSENT_TEXT = "${rolesScopeConsentText}";
    static Map<String, ProtocolMapperModel> builtins = new HashMap<String, ProtocolMapperModel>();

    public LoginProtocol create(KeycloakSession session) {
        return new OIDCLoginProtocol().setSession(session);
    }

    public Map<String, ProtocolMapperModel> getBuiltinMappers() {
        return builtins;
    }

    private static void createUserAttributeMapper(String name, String attrName, String claimName, String type) {
        ProtocolMapperModel model = UserAttributeMapper.createClaimMapper(name, attrName, claimName, type, true, true, false);
        builtins.put(name, model);
    }

    protected void createDefaultClientScopesImpl(RealmModel newRealm) {
        ClientScopeModel offlineAccessScope;
        ClientScopeModel profileScope = newRealm.addClientScope(PROFILE_CLAIM);
        profileScope.setDescription("OpenID Connect built-in scope: profile");
        profileScope.setDisplayOnConsentScreen(true);
        profileScope.setConsentScreenText(PROFILE_SCOPE_CONSENT_TEXT);
        profileScope.setIncludeInTokenScope(true);
        profileScope.setProtocol(this.getId());
        profileScope.addProtocolMapper(builtins.get(FULL_NAME));
        profileScope.addProtocolMapper(builtins.get(FAMILY_NAME));
        profileScope.addProtocolMapper(builtins.get(GIVEN_NAME));
        profileScope.addProtocolMapper(builtins.get(MIDDLE_NAME));
        profileScope.addProtocolMapper(builtins.get(NICKNAME));
        profileScope.addProtocolMapper(builtins.get(USERNAME));
        profileScope.addProtocolMapper(builtins.get(PROFILE_CLAIM));
        profileScope.addProtocolMapper(builtins.get(PICTURE));
        profileScope.addProtocolMapper(builtins.get(WEBSITE));
        profileScope.addProtocolMapper(builtins.get(GENDER));
        profileScope.addProtocolMapper(builtins.get(BIRTHDATE));
        profileScope.addProtocolMapper(builtins.get(ZONEINFO));
        profileScope.addProtocolMapper(builtins.get(LOCALE));
        profileScope.addProtocolMapper(builtins.get(UPDATED_AT));
        ClientScopeModel emailScope = newRealm.addClientScope(EMAIL);
        emailScope.setDescription("OpenID Connect built-in scope: email");
        emailScope.setDisplayOnConsentScreen(true);
        emailScope.setConsentScreenText(EMAIL_SCOPE_CONSENT_TEXT);
        emailScope.setIncludeInTokenScope(true);
        emailScope.setProtocol(this.getId());
        emailScope.addProtocolMapper(builtins.get(EMAIL));
        emailScope.addProtocolMapper(builtins.get(EMAIL_VERIFIED));
        ClientScopeModel addressScope = newRealm.addClientScope(ADDRESS);
        addressScope.setDescription("OpenID Connect built-in scope: address");
        addressScope.setDisplayOnConsentScreen(true);
        addressScope.setConsentScreenText(ADDRESS_SCOPE_CONSENT_TEXT);
        addressScope.setIncludeInTokenScope(true);
        addressScope.setProtocol(this.getId());
        addressScope.addProtocolMapper(builtins.get(ADDRESS));
        ClientScopeModel phoneScope = newRealm.addClientScope("phone");
        phoneScope.setDescription("OpenID Connect built-in scope: phone");
        phoneScope.setDisplayOnConsentScreen(true);
        phoneScope.setConsentScreenText(PHONE_SCOPE_CONSENT_TEXT);
        phoneScope.setIncludeInTokenScope(true);
        phoneScope.setProtocol(this.getId());
        phoneScope.addProtocolMapper(builtins.get(PHONE_NUMBER));
        phoneScope.addProtocolMapper(builtins.get(PHONE_NUMBER_VERIFIED));
        newRealm.addDefaultClientScope(profileScope, true);
        newRealm.addDefaultClientScope(emailScope, true);
        newRealm.addDefaultClientScope(addressScope, false);
        newRealm.addDefaultClientScope(phoneScope, false);
        RoleModel offlineRole = newRealm.getRole("offline_access");
        if (offlineRole != null && (offlineAccessScope = KeycloakModelUtils.getClientScopeByName((RealmModel)newRealm, (String)"offline_access")) == null) {
            DefaultClientScopes.createOfflineAccessClientScope((RealmModel)newRealm, (RoleModel)offlineRole);
        }
        OIDCLoginProtocolFactory.addRolesClientScope(newRealm);
        OIDCLoginProtocolFactory.addWebOriginsClientScope(newRealm);
    }

    public static ClientScopeModel addRolesClientScope(RealmModel newRealm) {
        ClientScopeModel rolesScope = KeycloakModelUtils.getClientScopeByName((RealmModel)newRealm, (String)ROLES_SCOPE);
        if (rolesScope == null) {
            rolesScope = newRealm.addClientScope(ROLES_SCOPE);
            rolesScope.setDescription("OpenID Connect scope for add user roles to the access token");
            rolesScope.setDisplayOnConsentScreen(true);
            rolesScope.setConsentScreenText(ROLES_SCOPE_CONSENT_TEXT);
            rolesScope.setIncludeInTokenScope(false);
            rolesScope.setProtocol("openid-connect");
            rolesScope.addProtocolMapper(builtins.get(REALM_ROLES));
            rolesScope.addProtocolMapper(builtins.get(CLIENT_ROLES));
            rolesScope.addProtocolMapper(builtins.get(AUDIENCE_RESOLVE));
            newRealm.addDefaultClientScope(rolesScope, true);
        } else {
            logger.debugf("Client scope '%s' already exists in realm '%s'. Skip creating it.", (Object)ROLES_SCOPE, (Object)newRealm.getName());
        }
        return rolesScope;
    }

    public static ClientScopeModel addWebOriginsClientScope(RealmModel newRealm) {
        ClientScopeModel originsScope = KeycloakModelUtils.getClientScopeByName((RealmModel)newRealm, (String)WEB_ORIGINS_SCOPE);
        if (originsScope == null) {
            originsScope = newRealm.addClientScope(WEB_ORIGINS_SCOPE);
            originsScope.setDescription("OpenID Connect scope for add allowed web origins to the access token");
            originsScope.setDisplayOnConsentScreen(false);
            originsScope.setConsentScreenText("");
            originsScope.setIncludeInTokenScope(false);
            originsScope.setProtocol("openid-connect");
            originsScope.addProtocolMapper(builtins.get(ALLOWED_WEB_ORIGINS));
            newRealm.addDefaultClientScope(originsScope, true);
        } else {
            logger.debugf("Client scope '%s' already exists in realm '%s'. Skip creating it.", (Object)WEB_ORIGINS_SCOPE, (Object)newRealm.getName());
        }
        return originsScope;
    }

    protected void addDefaults(ClientModel client) {
    }

    public Object createProtocolEndpoint(RealmModel realm, EventBuilder event) {
        return new OIDCLoginProtocolService(realm, event);
    }

    public String getId() {
        return "openid-connect";
    }

    public void setupClientDefaults(ClientRepresentation rep, ClientModel newClient) {
        if (rep.getRootUrl() != null && (rep.getRedirectUris() == null || rep.getRedirectUris().isEmpty())) {
            String root = rep.getRootUrl();
            root = root.endsWith("/") ? root + "*" : root + "/*";
            newClient.addRedirectUri(root);
            HashSet<String> origins = new HashSet<String>();
            String origin = UriUtils.getOrigin((String)root);
            logger.debugv("adding default client origin: {0}", (Object)origin);
            origins.add(origin);
            newClient.setWebOrigins(origins);
        }
        if (rep.isBearerOnly() == null && rep.isPublicClient() == null) {
            newClient.setPublicClient(true);
        }
        if (rep.isBearerOnly() == null) {
            newClient.setBearerOnly(false);
        }
        if (rep.getAdminUrl() == null && rep.getRootUrl() != null) {
            newClient.setManagementUrl(rep.getRootUrl());
        }
        if (rep.isDirectGrantsOnly() != null) {
            ServicesLogger.LOGGER.usingDeprecatedDirectGrantsOnly();
            newClient.setStandardFlowEnabled(rep.isDirectGrantsOnly() == false);
            newClient.setDirectAccessGrantsEnabled(rep.isDirectGrantsOnly().booleanValue());
        } else {
            if (rep.isStandardFlowEnabled() == null) {
                newClient.setStandardFlowEnabled(true);
            }
            if (rep.isDirectAccessGrantsEnabled() == null) {
                newClient.setDirectAccessGrantsEnabled(true);
            }
        }
        if (rep.isImplicitFlowEnabled() == null) {
            newClient.setImplicitFlowEnabled(false);
        }
        if (rep.isPublicClient() == null) {
            newClient.setPublicClient(true);
        }
        if (rep.isFrontchannelLogout() == null) {
            newClient.setFrontchannelLogout(false);
        }
    }

    static {
        ProtocolMapperModel model = UserPropertyMapper.createClaimMapper(USERNAME, USERNAME, "preferred_username", "String", true, true);
        builtins.put(USERNAME, model);
        model = UserPropertyMapper.createClaimMapper(EMAIL, EMAIL, EMAIL, "String", true, true);
        builtins.put(EMAIL, model);
        model = UserPropertyMapper.createClaimMapper(GIVEN_NAME, "firstName", "given_name", "String", true, true);
        builtins.put(GIVEN_NAME, model);
        model = UserPropertyMapper.createClaimMapper(FAMILY_NAME, "lastName", "family_name", "String", true, true);
        builtins.put(FAMILY_NAME, model);
        OIDCLoginProtocolFactory.createUserAttributeMapper(MIDDLE_NAME, "middleName", "middle_name", "String");
        OIDCLoginProtocolFactory.createUserAttributeMapper(NICKNAME, NICKNAME, NICKNAME, "String");
        OIDCLoginProtocolFactory.createUserAttributeMapper(PROFILE_CLAIM, PROFILE_CLAIM, PROFILE_CLAIM, "String");
        OIDCLoginProtocolFactory.createUserAttributeMapper(PICTURE, PICTURE, PICTURE, "String");
        OIDCLoginProtocolFactory.createUserAttributeMapper(WEBSITE, WEBSITE, WEBSITE, "String");
        OIDCLoginProtocolFactory.createUserAttributeMapper(GENDER, GENDER, GENDER, "String");
        OIDCLoginProtocolFactory.createUserAttributeMapper(BIRTHDATE, BIRTHDATE, BIRTHDATE, "String");
        OIDCLoginProtocolFactory.createUserAttributeMapper(ZONEINFO, ZONEINFO, ZONEINFO, "String");
        OIDCLoginProtocolFactory.createUserAttributeMapper(UPDATED_AT, "updatedAt", "updated_at", "String");
        OIDCLoginProtocolFactory.createUserAttributeMapper(LOCALE, LOCALE, LOCALE, "String");
        OIDCLoginProtocolFactory.createUserAttributeMapper(PHONE_NUMBER, "phoneNumber", "phone_number", "String");
        OIDCLoginProtocolFactory.createUserAttributeMapper(PHONE_NUMBER_VERIFIED, "phoneNumberVerified", "phone_number_verified", "boolean");
        model = UserPropertyMapper.createClaimMapper(EMAIL_VERIFIED, "emailVerified", "email_verified", "boolean", true, true);
        builtins.put(EMAIL_VERIFIED, model);
        ProtocolMapperModel fullName = FullNameMapper.create(FULL_NAME, true, true, true);
        builtins.put(FULL_NAME, fullName);
        ProtocolMapperModel address = AddressMapper.createAddressMapper();
        builtins.put(ADDRESS, address);
        model = UserSessionNoteMapper.createClaimMapper("gss delegation credential", "gss_delegation_credential", "gss_delegation_credential", "String", true, false);
        builtins.put("gss_delegation_credential", model);
        model = UserRealmRoleMappingMapper.create(null, REALM_ROLES, "realm_access.roles", true, false, true);
        builtins.put(REALM_ROLES, model);
        model = UserClientRoleMappingMapper.create(null, null, CLIENT_ROLES, "resource_access.${client_id}.roles", true, false, true);
        builtins.put(CLIENT_ROLES, model);
        model = AudienceResolveProtocolMapper.createClaimMapper(AUDIENCE_RESOLVE);
        builtins.put(AUDIENCE_RESOLVE, model);
        model = AllowedWebOriginsProtocolMapper.createClaimMapper(ALLOWED_WEB_ORIGINS);
        builtins.put(ALLOWED_WEB_ORIGINS, model);
    }
}

