/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.util;

import java.io.IOException;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.ExportProvider;
import org.keycloak.exportimport.UsersExportStrategy;
import org.keycloak.exportimport.util.ExportImportSessionTask;
import org.keycloak.exportimport.util.ExportUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;

public abstract class MultipleStepsExportProvider
implements ExportProvider {
    protected final Logger logger = Logger.getLogger(this.getClass());

    public void exportModel(KeycloakSessionFactory factory) throws IOException {
        final RealmsHolder holder = new RealmsHolder();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                List realms;
                holder.realms = realms = session.realms().getRealms();
            }
        });
        for (RealmModel realm : holder.realms) {
            this.exportRealmImpl(factory, realm.getName());
        }
    }

    public void exportRealm(KeycloakSessionFactory factory, String realmName) throws IOException {
        this.exportRealmImpl(factory, realmName);
    }

    protected void exportRealmImpl(KeycloakSessionFactory factory, final String realmName) throws IOException {
        int countPerPage;
        UsersExportStrategy usersExportStrategy = ExportImportConfig.getUsersExportStrategy();
        int usersPerFile = ExportImportConfig.getUsersPerFile();
        final UsersHolder usersHolder = new UsersHolder();
        final boolean exportUsersIntoRealmFile = usersExportStrategy == UsersExportStrategy.REALM_FILE;
        final FederatedUsersHolder federatedUsersHolder = new FederatedUsersHolder();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, (KeycloakSessionTask)new ExportImportSessionTask(){

            @Override
            protected void runExportImportTask(KeycloakSession session) throws IOException {
                RealmModel realm = session.realms().getRealmByName(realmName);
                RealmRepresentation rep = ExportUtils.exportRealm(session, realm, exportUsersIntoRealmFile, true);
                MultipleStepsExportProvider.this.writeRealm(realmName + "-realm.json", rep);
                MultipleStepsExportProvider.this.logger.info((Object)("Realm '" + realmName + "' - data exported"));
                if (!exportUsersIntoRealmFile) {
                    usersHolder.totalCount = session.users().getUsersCount(realm, true);
                    federatedUsersHolder.totalCount = session.userFederatedStorage().getStoredUsersCount(realm);
                }
            }
        });
        if (usersExportStrategy != UsersExportStrategy.SKIP && !exportUsersIntoRealmFile) {
            usersHolder.currentPageStart = 0;
            int n = countPerPage = usersExportStrategy == UsersExportStrategy.SAME_FILE ? usersHolder.totalCount : usersPerFile;
            while (usersHolder.currentPageStart < usersHolder.totalCount) {
                usersHolder.currentPageEnd = usersHolder.currentPageStart + countPerPage < usersHolder.totalCount ? usersHolder.currentPageStart + countPerPage : usersHolder.totalCount;
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, (KeycloakSessionTask)new ExportImportSessionTask(){

                    @Override
                    protected void runExportImportTask(KeycloakSession session) throws IOException {
                        RealmModel realm = session.realms().getRealmByName(realmName);
                        usersHolder.users = session.users().getUsers(realm, usersHolder.currentPageStart, usersHolder.currentPageEnd - usersHolder.currentPageStart, true);
                        MultipleStepsExportProvider.this.writeUsers(realmName + "-users-" + usersHolder.currentPageStart / countPerPage + ".json", session, realm, usersHolder.users);
                        MultipleStepsExportProvider.this.logger.info((Object)("Users " + usersHolder.currentPageStart + "-" + (usersHolder.currentPageEnd - 1) + " exported"));
                    }
                });
                usersHolder.currentPageStart = usersHolder.currentPageEnd;
            }
        }
        if (usersExportStrategy != UsersExportStrategy.SKIP && !exportUsersIntoRealmFile) {
            federatedUsersHolder.currentPageStart = 0;
            int n = countPerPage = usersExportStrategy == UsersExportStrategy.SAME_FILE ? federatedUsersHolder.totalCount : usersPerFile;
            while (federatedUsersHolder.currentPageStart < federatedUsersHolder.totalCount) {
                federatedUsersHolder.currentPageEnd = federatedUsersHolder.currentPageStart + countPerPage < federatedUsersHolder.totalCount ? federatedUsersHolder.currentPageStart + countPerPage : federatedUsersHolder.totalCount;
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, (KeycloakSessionTask)new ExportImportSessionTask(){

                    @Override
                    protected void runExportImportTask(KeycloakSession session) throws IOException {
                        RealmModel realm = session.realms().getRealmByName(realmName);
                        federatedUsersHolder.users = session.userFederatedStorage().getStoredUsers(realm, federatedUsersHolder.currentPageStart, federatedUsersHolder.currentPageEnd - federatedUsersHolder.currentPageStart);
                        MultipleStepsExportProvider.this.writeFederatedUsers(realmName + "-federated-users-" + federatedUsersHolder.currentPageStart / countPerPage + ".json", session, realm, federatedUsersHolder.users);
                        MultipleStepsExportProvider.this.logger.info((Object)("Users " + federatedUsersHolder.currentPageStart + "-" + (federatedUsersHolder.currentPageEnd - 1) + " exported"));
                    }
                });
                federatedUsersHolder.currentPageStart = federatedUsersHolder.currentPageEnd;
            }
        }
    }

    protected abstract void writeRealm(String var1, RealmRepresentation var2) throws IOException;

    protected abstract void writeUsers(String var1, KeycloakSession var2, RealmModel var3, List<UserModel> var4) throws IOException;

    protected abstract void writeFederatedUsers(String var1, KeycloakSession var2, RealmModel var3, List<String> var4) throws IOException;

    public static class FederatedUsersHolder {
        List<String> users;
        int totalCount;
        int currentPageStart;
        int currentPageEnd;
    }

    public static class UsersHolder {
        List<UserModel> users;
        int totalCount;
        int currentPageStart;
        int currentPageEnd;
    }

    public static class RealmsHolder {
        List<RealmModel> realms;
    }
}

