/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.policy.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientregistration.policy.AbstractClientRegistrationPolicyFactory;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.impl.ClientScopesClientRegistrationPolicy;

public class ClientScopesClientRegistrationPolicyFactory
extends AbstractClientRegistrationPolicyFactory {
    private List<ProviderConfigProperty> configProperties;
    public static final String PROVIDER_ID = "allowed-client-templates";
    public static final String ALLOWED_CLIENT_SCOPES = "allowed-client-scopes";
    public static final String ALLOW_DEFAULT_SCOPES = "allow-default-scopes";

    public ClientRegistrationPolicy create(KeycloakSession session, ComponentModel model) {
        return new ClientScopesClientRegistrationPolicy(session, model);
    }

    public String getHelpText() {
        return "When present, it allows to specify whitelist of client scopes, which will be allowed in representation of registered (or updated) client";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties(KeycloakSession session) {
        LinkedList<ProviderConfigProperty> configProps = new LinkedList<ProviderConfigProperty>();
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(ALLOWED_CLIENT_SCOPES);
        property.setLabel("allowed-client-scopes.label");
        property.setHelpText("allowed-client-scopes.tooltip");
        property.setType("MultivaluedList");
        if (session != null) {
            property.setOptions(this.getClientScopes(session));
        }
        configProps.add(property);
        property = new ProviderConfigProperty();
        property.setName(ALLOW_DEFAULT_SCOPES);
        property.setLabel("allow-default-scopes.label");
        property.setHelpText("allow-default-scopes.tooltip");
        property.setType("boolean");
        property.setDefaultValue((Object)true);
        configProps.add(property);
        this.configProperties = configProps;
        return this.configProperties;
    }

    private List<String> getClientScopes(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        if (realm == null) {
            return Collections.emptyList();
        }
        List clientScopes = realm.getClientScopes();
        return clientScopes.stream().map(clientScope -> clientScope.getName()).collect(Collectors.toList());
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return this.getConfigProperties(null);
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

