/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationSelectionOption;
import org.keycloak.services.util.AuthenticationFlowHistoryHelper;

public class AuthenticationContextBean {
    private final AuthenticationFlowContext context;
    private final URI actionUri;

    public AuthenticationContextBean(AuthenticationFlowContext context, URI actionUri) {
        this.context = context;
        this.actionUri = actionUri;
    }

    public List<AuthenticationSelectionOption> getAuthenticationSelections() {
        return this.context == null ? Collections.emptyList() : this.context.getAuthenticationSelections();
    }

    public String getSelectedCredential() {
        return this.context == null ? null : this.context.getSelectedCredentialId();
    }

    public boolean showBackButton() {
        if (this.context == null) {
            return false;
        }
        return this.actionUri != null && new AuthenticationFlowHistoryHelper(this.context.getAuthenticationSession(), this.context.getFlowPath()).hasAnyExecution();
    }
}

