/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.credential.PasswordCredentialProvider;
import org.keycloak.credential.UserCredentialStoreManager;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.managers.Auth;

public class AccountCredentialResource {
    public static final String TYPE = "type";
    public static final String ENABLED_ONLY = "enabled-only";
    public static final String USER_CREDENTIALS = "user-credentials";
    private final KeycloakSession session;
    private final EventBuilder event;
    private final UserModel user;
    private final RealmModel realm;
    private Auth auth;

    public AccountCredentialResource(KeycloakSession session, EventBuilder event, UserModel user, Auth auth) {
        this.session = session;
        this.event = event;
        this.user = user;
        this.auth = auth;
        this.realm = session.getContext().getRealm();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<CredentialContainer> credentialTypes(@QueryParam(value="type") String type, @QueryParam(value="user-credentials") Boolean userCredentials) {
        List models;
        this.auth.requireOneOf("manage-account", "view-profile");
        boolean filterUserCredentials = userCredentials != null && userCredentials == false;
        LinkedList<CredentialContainer> credentialTypes = new LinkedList<CredentialContainer>();
        List<CredentialProvider> credentialProviders = UserCredentialStoreManager.getCredentialProviders(this.session, this.realm, CredentialProvider.class);
        Set<String> enabledCredentialTypes = this.getEnabledCredentialTypes(credentialProviders);
        List list = models = filterUserCredentials ? null : this.session.userCredentialManager().getStoredCredentials(this.realm, this.user);
        if (models != null) {
            for (CredentialModel credential : models) {
                credential.setSecretData(null);
            }
        }
        for (CredentialProvider credentialProvider : credentialProviders) {
            List<Object> userCredentialModels;
            boolean enabled;
            String credentialProviderType = credentialProvider.getType();
            if (type != null && !type.equals(credentialProviderType) || !(enabled = enabledCredentialTypes.contains(credentialProviderType))) continue;
            CredentialTypeMetadataContext ctx = CredentialTypeMetadataContext.builder().user(this.user).build(this.session);
            CredentialTypeMetadata metadata = credentialProvider.getCredentialTypeMetadata(ctx);
            List list2 = userCredentialModels = filterUserCredentials ? null : models.stream().filter(credentialModel -> credentialProvider.getType().equals(credentialModel.getType())).map(ModelToRepresentation::toRepresentation).collect(Collectors.toList());
            if (userCredentialModels != null && userCredentialModels.isEmpty() && this.session.userCredentialManager().isConfiguredFor(this.realm, this.user, credentialProviderType)) {
                CredentialRepresentation credential = new CredentialRepresentation();
                credential.setId(credentialProviderType + "-id");
                credential.setType(credentialProviderType);
                credential.setCreatedDate(Long.valueOf(-1L));
                credential.setPriority(Integer.valueOf(0));
                userCredentialModels = Collections.singletonList(credential);
            }
            CredentialContainer credType = new CredentialContainer(metadata, (List<CredentialRepresentation>)userCredentialModels);
            credentialTypes.add(credType);
        }
        credentialTypes.sort(Comparator.comparing(CredentialContainer::getMetadata));
        return credentialTypes;
    }

    private Set<String> getEnabledCredentialTypes(List<CredentialProvider> credentialProviders) {
        HashSet<String> enabledCredentialTypes = new HashSet<String>();
        for (AuthenticationFlowModel flow : this.realm.getAuthenticationFlows()) {
            if (this.isFlowEffectivelyDisabled(flow)) continue;
            for (AuthenticationExecutionModel execution : this.realm.getAuthenticationExecutions(flow.getId())) {
                AuthenticatorFactory authenticatorFactory;
                if (execution.getAuthenticator() == null || AuthenticationExecutionModel.Requirement.DISABLED == execution.getRequirement() || (authenticatorFactory = (AuthenticatorFactory)this.session.getKeycloakSessionFactory().getProviderFactory(Authenticator.class, execution.getAuthenticator())) == null || authenticatorFactory.getReferenceCategory() == null) continue;
                enabledCredentialTypes.add(authenticatorFactory.getReferenceCategory());
            }
        }
        Set credentialTypes = credentialProviders.stream().map(CredentialProvider::getType).collect(Collectors.toSet());
        enabledCredentialTypes.retainAll(credentialTypes);
        return enabledCredentialTypes;
    }

    private boolean isFlowEffectivelyDisabled(AuthenticationFlowModel flow) {
        while (!flow.isTopLevel()) {
            AuthenticationExecutionModel flowExecution = this.realm.getAuthenticationExecutionByFlowId(flow.getId());
            if (flowExecution == null) {
                return false;
            }
            if (AuthenticationExecutionModel.Requirement.DISABLED == flowExecution.getRequirement()) {
                return true;
            }
            if (flowExecution.getParentFlow() == null) {
                return false;
            }
            flow = this.realm.getAuthenticationFlowById(flowExecution.getParentFlow());
            if (flow != null) continue;
            return false;
        }
        return false;
    }

    @Path(value="{credentialId}")
    @DELETE
    @NoCache
    public void removeCredential(@PathParam(value="credentialId") String credentialId) {
        this.auth.require("manage-account");
        this.session.userCredentialManager().removeStoredCredential(this.realm, this.user, credentialId);
    }

    @PUT
    @Consumes(value={"text/plain"})
    @Path(value="{credentialId}/label")
    public void setLabel(@PathParam(value="credentialId") String credentialId, String userLabel) {
        this.auth.require("manage-account");
        this.session.userCredentialManager().updateCredentialLabel(this.realm, this.user, credentialId, userLabel);
    }

    @GET
    @Path(value="password")
    @Produces(value={"application/json"})
    public PasswordDetails passwordDetails() throws IOException {
        this.auth.requireOneOf("manage-account", "view-profile");
        PasswordCredentialProvider passwordProvider = (PasswordCredentialProvider)this.session.getProvider(CredentialProvider.class, "keycloak-password");
        PasswordCredentialModel password = passwordProvider.getPassword(this.realm, this.user);
        PasswordDetails details = new PasswordDetails();
        if (password != null) {
            details.setRegistered(true);
            Long createdDate = password.getCreatedDate();
            if (createdDate != null) {
                details.setLastUpdate(createdDate);
            }
        } else {
            details.setRegistered(false);
        }
        return details;
    }

    @POST
    @Path(value="password")
    @Consumes(value={"application/json"})
    public Response passwordUpdate(PasswordUpdate update) {
        this.auth.require("manage-account");
        this.event.event(EventType.UPDATE_PASSWORD);
        UserCredentialModel cred = UserCredentialModel.password((String)update.getCurrentPassword());
        if (!this.session.userCredentialManager().isValid(this.realm, this.user, new CredentialInput[]{cred})) {
            this.event.error("invalid_user_credentials");
            return ErrorResponse.error("invalidPasswordExistingMessage", Response.Status.BAD_REQUEST);
        }
        if (update.getNewPassword() == null) {
            return ErrorResponse.error("invalidPasswordExistingMessage", Response.Status.BAD_REQUEST);
        }
        String confirmation = update.getConfirmation();
        if (confirmation != null && !update.getNewPassword().equals(confirmation)) {
            return ErrorResponse.error("notMatchPasswordMessage", Response.Status.BAD_REQUEST);
        }
        try {
            this.session.userCredentialManager().updateCredential(this.realm, this.user, (CredentialInput)UserCredentialModel.password((String)update.getNewPassword(), (boolean)false));
        }
        catch (ModelException e) {
            return ErrorResponse.error(e.getMessage(), e.getParameters(), Response.Status.BAD_REQUEST);
        }
        this.event.client(this.auth.getClient()).user(this.auth.getUser()).success();
        return Response.ok().build();
    }

    public static class PasswordUpdate {
        private String currentPassword;
        private String newPassword;
        private String confirmation;

        public String getCurrentPassword() {
            return this.currentPassword;
        }

        public void setCurrentPassword(String currentPassword) {
            this.currentPassword = currentPassword;
        }

        public String getNewPassword() {
            return this.newPassword;
        }

        public void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }

        public String getConfirmation() {
            return this.confirmation;
        }

        public void setConfirmation(String confirmation) {
            this.confirmation = confirmation;
        }
    }

    public static class PasswordDetails {
        private boolean registered;
        private long lastUpdate;

        public boolean isRegistered() {
            return this.registered;
        }

        public void setRegistered(boolean registered) {
            this.registered = registered;
        }

        public long getLastUpdate() {
            return this.lastUpdate;
        }

        public void setLastUpdate(long lastUpdate) {
            this.lastUpdate = lastUpdate;
        }
    }

    public static class CredentialContainer {
        private String type;
        private String category;
        private String displayName;
        private String helptext;
        private String iconCssClass;
        private String createAction;
        private String updateAction;
        private boolean removeable;
        private List<CredentialRepresentation> userCredentials;
        private CredentialTypeMetadata metadata;

        public CredentialContainer() {
        }

        public CredentialContainer(CredentialTypeMetadata metadata, List<CredentialRepresentation> userCredentials) {
            this.metadata = metadata;
            this.type = metadata.getType();
            this.category = metadata.getCategory().toString();
            this.displayName = metadata.getDisplayName();
            this.helptext = metadata.getHelpText();
            this.iconCssClass = metadata.getIconCssClass();
            this.createAction = metadata.getCreateAction();
            this.updateAction = metadata.getUpdateAction();
            this.removeable = metadata.isRemoveable();
            this.userCredentials = userCredentials;
        }

        public String getCategory() {
            return this.category;
        }

        public String getType() {
            return this.type;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getHelptext() {
            return this.helptext;
        }

        public String getIconCssClass() {
            return this.iconCssClass;
        }

        public String getCreateAction() {
            return this.createAction;
        }

        public String getUpdateAction() {
            return this.updateAction;
        }

        public boolean isRemoveable() {
            return this.removeable;
        }

        public List<CredentialRepresentation> getUserCredentials() {
            return this.userCredentials;
        }

        @JsonIgnore
        public CredentialTypeMetadata getMetadata() {
            return this.metadata;
        }
    }
}

