/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.policy.PasswordPolicyNotMetException;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.UserResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.UserPermissionEvaluator;

public class UsersResource {
    private static final Logger logger = Logger.getLogger(UsersResource.class);
    private static final String SEARCH_ID_PARAMETER = "id:";
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpHeaders headers;

    public UsersResource(RealmModel realm, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent.resource(ResourceType.USER);
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createUser(UserRepresentation rep) {
        this.auth.users().requireManage();
        String username = rep.getUsername();
        if (this.realm.isRegistrationEmailAsUsername()) {
            username = rep.getEmail();
        }
        if (ObjectUtil.isBlank((CharSequence)username)) {
            return ErrorResponse.error("User name is missing", Response.Status.BAD_REQUEST);
        }
        if (this.session.users().getUserByUsername(username, this.realm) != null) {
            return ErrorResponse.exists("User exists with same username");
        }
        if (rep.getEmail() != null && !this.realm.isDuplicateEmailsAllowed() && this.session.users().getUserByEmail(rep.getEmail(), this.realm) != null) {
            return ErrorResponse.exists("User exists with same email");
        }
        try {
            UserModel user = this.session.users().addUser(this.realm, username);
            Set<String> emptySet = Collections.emptySet();
            UserResource.updateUserFromRep(user, rep, emptySet, this.realm, this.session, false);
            RepresentationToModel.createFederatedIdentities((UserRepresentation)rep, (KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user);
            RepresentationToModel.createGroups((UserRepresentation)rep, (RealmModel)this.realm, (UserModel)user);
            RepresentationToModel.createCredentials((UserRepresentation)rep, (KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user, (boolean)true);
            this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), user.getId()).representation(rep).success();
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().commit();
            }
            return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(user.getId()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().setRollbackOnly();
            }
            return ErrorResponse.exists("User exists with same username or email");
        }
        catch (PasswordPolicyNotMetException e) {
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().setRollbackOnly();
            }
            return ErrorResponse.error("Password policy not met", Response.Status.BAD_REQUEST);
        }
        catch (ModelException me) {
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().setRollbackOnly();
            }
            logger.warn((Object)"Could not create user", (Throwable)me);
            return ErrorResponse.error("Could not create user", Response.Status.BAD_REQUEST);
        }
    }

    @Path(value="{id}")
    public UserResource user(@PathParam(value="id") String id) {
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            if (this.auth.users().canQuery()) {
                throw new NotFoundException("User not found");
            }
            throw new ForbiddenException();
        }
        UserResource resource = new UserResource(this.realm, user, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserRepresentation> getUsers(@QueryParam(value="search") String search, @QueryParam(value="lastName") String last, @QueryParam(value="firstName") String first, @QueryParam(value="email") String email, @QueryParam(value="username") String username, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults, @QueryParam(value="briefRepresentation") Boolean briefRepresentation) {
        UserPermissionEvaluator userPermissionEvaluator = this.auth.users();
        userPermissionEvaluator.requireQuery();
        firstResult = firstResult != null ? firstResult : -1;
        maxResults = maxResults != null ? maxResults : 100;
        List list = Collections.emptyList();
        if (search != null) {
            if (search.startsWith(SEARCH_ID_PARAMETER)) {
                void var10_12;
                UserModel userModel = this.session.users().getUserById(search.substring(SEARCH_ID_PARAMETER.length()).trim(), this.realm);
                if (userModel == null) return this.toRepresentation(this.realm, userPermissionEvaluator, briefRepresentation, (List<UserModel>)var10_12);
                List<UserModel> list2 = Arrays.asList(userModel);
                return this.toRepresentation(this.realm, userPermissionEvaluator, briefRepresentation, (List<UserModel>)var10_12);
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("keycloak.session.realm.users.query.search", search.trim());
            return this.searchForUser(attributes, this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, false);
        }
        if (last == null && first == null && email == null) {
            if (username == null) return this.searchForUser(new HashMap<String, String>(), this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, false);
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (last != null) {
            attributes.put("lastName", last);
        }
        if (first != null) {
            attributes.put("firstName", first);
        }
        if (email != null) {
            attributes.put("email", email);
        }
        if (username == null) return this.searchForUser(attributes, this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, true);
        attributes.put("username", username);
        return this.searchForUser(attributes, this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, true);
    }

    @Path(value="count")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Integer getUsersCount(@QueryParam(value="search") String search, @QueryParam(value="lastName") String last, @QueryParam(value="firstName") String first, @QueryParam(value="email") String email, @QueryParam(value="username") String username) {
        UserPermissionEvaluator userPermissionEvaluator = this.auth.users();
        userPermissionEvaluator.requireQuery();
        if (search != null) {
            if (search.startsWith(SEARCH_ID_PARAMETER)) {
                UserModel userModel = this.session.users().getUserById(search.substring(SEARCH_ID_PARAMETER.length()).trim(), this.realm);
                return userModel != null && userPermissionEvaluator.canView(userModel) ? 1 : 0;
            }
            if (userPermissionEvaluator.canView()) {
                return this.session.users().getUsersCount(search.trim(), this.realm);
            }
            return this.session.users().getUsersCount(search.trim(), this.realm, this.auth.groups().getGroupsWithViewPermission());
        }
        if (last != null || first != null || email != null || username != null) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (last != null) {
                parameters.put("lastName", last);
            }
            if (first != null) {
                parameters.put("firstName", first);
            }
            if (email != null) {
                parameters.put("email", email);
            }
            if (username != null) {
                parameters.put("username", username);
            }
            if (userPermissionEvaluator.canView()) {
                return this.session.users().getUsersCount(parameters, this.realm);
            }
            return this.session.users().getUsersCount(parameters, this.realm, this.auth.groups().getGroupsWithViewPermission());
        }
        if (userPermissionEvaluator.canView()) {
            return this.session.users().getUsersCount(this.realm);
        }
        return this.session.users().getUsersCount(this.realm, this.auth.groups().getGroupsWithViewPermission());
    }

    private List<UserRepresentation> searchForUser(Map<String, String> attributes, RealmModel realm, UserPermissionEvaluator usersEvaluator, Boolean briefRepresentation, Integer firstResult, Integer maxResults, Boolean includeServiceAccounts) {
        Set<String> groupModels;
        this.session.setAttribute("keycloak.session.realm.users.query.include_service_account", (Object)includeServiceAccounts);
        if (!this.auth.users().canView() && !(groupModels = this.auth.groups().getGroupsWithViewPermission()).isEmpty()) {
            this.session.setAttribute("keycloak.session.realm.users.query.groups", groupModels);
        }
        List userModels = this.session.users().searchForUser(attributes, realm, firstResult.intValue(), maxResults.intValue());
        return this.toRepresentation(realm, usersEvaluator, briefRepresentation, userModels);
    }

    private List<UserRepresentation> toRepresentation(RealmModel realm, UserPermissionEvaluator usersEvaluator, Boolean briefRepresentation, List<UserModel> userModels) {
        boolean briefRepresentationB = briefRepresentation != null && briefRepresentation != false;
        ArrayList<UserRepresentation> results = new ArrayList<UserRepresentation>();
        boolean canViewGlobal = usersEvaluator.canView();
        usersEvaluator.grantIfNoPermission(this.session.getAttribute("keycloak.session.realm.users.query.groups") != null);
        for (UserModel user : userModels) {
            if (!canViewGlobal && !usersEvaluator.canView(user)) continue;
            UserRepresentation userRep = briefRepresentationB ? ModelToRepresentation.toBriefRepresentation((UserModel)user) : ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)realm, (UserModel)user);
            userRep.setAccess(usersEvaluator.getAccess(user));
            results.add(userRep);
        }
        return results;
    }
}

